/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.desc.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egf.portfolio.genchain.extension.ExtensionHelper;
import org.eclipse.egf.portfolio.genchain.extension.ExtensionProperties;
import org.eclipse.egf.portfolio.genchain.generationChain.EcoreElement;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChain;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationElement;
import org.eclipse.egf.portfolio.genchain.tools.ui.Messages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class GenerationCreatingCommand
extends RecordingCommand
implements ExtensionProperties {
    private GenerationChain gc;
    private List<URI> uriList;
    private final ExtensionHelper extensionHelper;

    public GenerationCreatingCommand(TransactionalEditingDomain domain, GenerationChain gc, List<URI> uriList, ExtensionHelper extensionHelper) {
        super(domain);
        this.gc = gc;
        this.uriList = uriList;
        this.extensionHelper = extensionHelper;
    }

    protected void doExecute() {
        if (this.uriList != null && this.uriList.size() > 0) {
            String project = this.gc.eResource().getURI().segment(1);
            for (URI uri : this.uriList) {
                GenerationElement feature1 = this.createNewElement(uri, project);
                this.gc.getElements().add((Object)feature1);
            }
        } else {
            throw new IllegalStateException("no uri provided");
        }
    }

    public String getPath(URI uri) {
        if (uri.isPlatform()) {
            return uri.toPlatformString(false);
        }
        if (uri.isFile()) {
            return uri.toFileString();
        }
        return "";
    }

    public GenerationElement createNewElement(URI uri, String project) {
        ExtensionHelper extension = this.getExtension();
        HashMap<String, String> context = new HashMap<String, String>();
        HashMap<String, String> properties = new HashMap<String, String>();
        String name = uri.trimFileExtension().lastSegment();
        context.put("ctx.current.project.name", project);
        context.put("ctx.model.path", name);
        Map defaultProperties = extension.getDefaultProperties(context);
        for (Map.Entry entry : defaultProperties.entrySet()) {
            properties.put(((EAttribute)entry.getKey()).getName(), (String)entry.getValue());
        }
        properties.put("model.path", uri.toPlatformString(true));
        EcoreElement element = extension.createEcoreElement(properties);
        element.setName(Messages.bind((String)Messages.genchain_wizard_element_name_creation, (Object)extension.getLabel(), (Object)name));
        return element;
    }

    protected ExtensionHelper getExtension() {
        return this.extensionHelper;
    }
}

