/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.impl.diagram.template;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Class;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.impl.diagram.template.DataClassesPage;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.impl.diagram.template.observer.IObserver;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.impl.diagram.template.observer.ISelectionNotification;

public class TemplateDataClasses
extends Wizard
implements ISelectionNotification {
    private static final Collection<IObserver> observers = new HashSet<IObserver>();

    public TemplateDataClasses() {
        this.setWindowTitle("Accelerator of diagram creation");
    }

    public boolean performFinish() {
        DataClassesPage page = this.getDataClassesPage();
        if (page != null) {
            Collection<Class> selectedClasses = page.getSelectedClass();
            for (Class class1 : selectedClasses) {
                this.notifyObservators(class1);
            }
            page.dispose();
        }
        return true;
    }

    private DataClassesPage getDataClassesPage() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof DataClassesPage) {
                return (DataClassesPage)page;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void registerObserver(IObserver observer) {
        observers.add(observer);
    }

    @Override
    public void unregisterObserver(IObserver observer) {
        if (observers.contains(observer)) {
            observers.remove(observer);
        }
    }

    @Override
    public void notifyObservators(Class vpClass) {
        boolean isExtension = false;
        DataClassesPage page = this.getDataClassesPage();
        if (page != null) {
            isExtension = page.isDiagramExtension();
        }
        for (IObserver observer : observers) {
            observer.update(vpClass, isExtension);
        }
    }
}

