/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.java;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.java.JavaMerger;

public class JDTUtility {
    public static IFolder packageToFolder(IProject project, String packageName) {
        String folder = JDTUtility.getValidPackageName(packageName);
        folder = folder.replaceAll("\\.", "/");
        folder = "src/" + folder;
        return project.getFolder((IPath)new Path(folder));
    }

    public static String mergeJavaCode(IFile javaFile, String generatedCode) {
        String mergerCode = "";
        try {
            mergerCode = JavaMerger.doMerge(javaFile, generatedCode);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return mergerCode;
    }

    public static String formatJavaCode(String javaCode) {
        CodeFormatter codeFormatter = ToolFactory.createCodeFormatter(null);
        TextEdit textEdit = codeFormatter.format(0, javaCode, 0, javaCode.length(), 0, null);
        Document document = new Document(javaCode);
        try {
            textEdit.apply((IDocument)document);
            javaCode = document.get();
        }
        catch (MalformedTreeException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return javaCode;
    }

    public static void writeJavaContent(IFile javaFile, String javaCode) {
        String formatedOutput = JDTUtility.formatJavaCode(javaCode);
        ByteArrayInputStream outputContent = new ByteArrayInputStream(formatedOutput.getBytes());
        try {
            if (javaFile.exists()) {
                javaFile.setContents((InputStream)outputContent, true, false, null);
            } else {
                javaFile.create((InputStream)outputContent, true, null);
            }
            javaFile.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static String getValidPackageName(String name) {
        return name.replaceAll("[^a-zA-Z0-9_.]", "").toLowerCase();
    }

    public static String getValidClassName(String name) {
        String cName = name.replaceAll("[^a-zA-Z0-9_]", "");
        return String.valueOf(cName.substring(0, 1).toUpperCase()) + cName.substring(1);
    }

    public static IFolder createOrGetPackageFolders(IProject project, String packageName) {
        Path packageFolderPath;
        IFolder src = project.getFolder("src");
        if (!src.exists()) {
            try {
                src.create(true, true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (src.getFolder((IPath)(packageFolderPath = new Path(packageName.replace('.', '/')))).exists()) {
            return src.getFolder((IPath)packageFolderPath);
        }
        IFolder parent = src;
        int i = 0;
        while (i < packageFolderPath.segmentCount()) {
            IFolder curFolder = parent.getFolder(packageFolderPath.segment(i));
            if (!curFolder.exists()) {
                try {
                    curFolder.create(true, true, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            parent = curFolder;
            ++i;
        }
        return parent;
    }

    public static String organizeImport(IFile javaFile, String javaCode) {
        return javaCode;
    }

    public static void organizeImport(IFile javaCode) {
    }
}

