/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.extension.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.polarsys.kitalpha.doc.gen.business.core.extension.page.PageExtensionElement;
import org.polarsys.kitalpha.doc.gen.business.core.extension.page.helpers.NamingOptionalityPreferencesHelper;
import org.polarsys.kitalpha.doc.gen.business.core.util.IDiagramHelper;
import org.polarsys.kitalpha.doc.gen.business.core.util.IFileNameService;

public class PageExtensionManager {
    private static final String DOCGEN_CONTENT_EXTENSION = "org.polarsys.kitalpha.doc.gen.business.core.contentExtension";
    private static final String DOCGEN_PAGE_EXTENSION_ELEMENT = "pageExtension";
    private static final String DOCGEN_PAGE_EXTENSION_ELEMENT__NAME = "name";
    private static final String DOCGEN_PAGE_EXTENSION_ELEMENT__DESCRIPTION = "description";
    private static final String DOCGEN_PAGE_EXTENSION_ELEMENT__DOMAIN = "domain";
    private static final String DOCGEN_PAGE_EXTENSION_ELEMENT__CATEGORY = "category";
    private static final String DOCGEN_PAGE_EXTENSION_ELEMENT__DIAGRAMHELPER = "diagramHelper";
    private static final String DOCGEN_PAGE_EXTENSION_ELEMENT__FILENAMESERVICE = "fileNameService";
    private static final String DOCGEN_PAGE_EXTENSION_ELEMENT__DEFAULT_STATUS = "defaultStatus";
    private static final String DOCGEN_PAGE_EXTENSION_PATTERN_URI = "URI";
    private static final String DOCGEN_PAGE_EXTENSION_PATTERN_PAGE = "pagePattern";
    private static final String DOCGEN_PAGE_EXTENSION_PATTERN_SIDEBAR = "sidebarPattern";

    public Collection<PageExtensionElement> loadExtensions() {
        LinkedHashSet<PageExtensionElement> result = new LinkedHashSet<PageExtensionElement>();
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(DOCGEN_CONTENT_EXTENSION);
        if (config.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elt = iConfigurationElementArray[n2];
                if (elt.getName().equalsIgnoreCase(DOCGEN_PAGE_EXTENSION_ELEMENT)) {
                    PageExtensionElement pageExtensionElement = this.createPageExtensionElement(elt);
                    this.updateActivationStatusFromUserPreferences(pageExtensionElement);
                    pageExtensionElement.getPageURI().addAll(this.collectPatterns(elt, DOCGEN_PAGE_EXTENSION_PATTERN_PAGE));
                    pageExtensionElement.getSidebarURI().addAll(this.collectPatterns(elt, DOCGEN_PAGE_EXTENSION_PATTERN_SIDEBAR));
                    result.add(pageExtensionElement);
                }
                ++n2;
            }
        }
        return result;
    }

    private void updateActivationStatusFromUserPreferences(PageExtensionElement pageExtensionElement) {
        String name = NamingOptionalityPreferencesHelper.getKeyOfPageExtensionElement(pageExtensionElement);
        String customizedBooleanValue = NamingOptionalityPreferencesHelper.getCustomizedStringValue((String)name);
        if (!customizedBooleanValue.isEmpty()) {
            pageExtensionElement.setCurrentActivactionStatus(PageExtensionElement.PageExtensionActivationStatus.getStatus(customizedBooleanValue));
        }
    }

    private List<URI> collectPatterns(IConfigurationElement element, String childName) {
        ArrayList<URI> patternURIs = new ArrayList<URI>();
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(childName);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String fcorePath = child.getAttribute(DOCGEN_PAGE_EXTENSION_PATTERN_URI);
            URI uri = URI.createURI((String)fcorePath);
            patternURIs.add(uri);
            ++n2;
        }
        return patternURIs;
    }

    public PageExtensionElement createPageExtensionElement(IConfigurationElement element) {
        PageExtensionElement peElement = new PageExtensionElement();
        peElement.setName(element.getAttribute(DOCGEN_PAGE_EXTENSION_ELEMENT__NAME));
        peElement.setDescription(element.getAttribute(DOCGEN_PAGE_EXTENSION_ELEMENT__DESCRIPTION));
        peElement.setDomain(element.getAttribute(DOCGEN_PAGE_EXTENSION_ELEMENT__DOMAIN));
        peElement.setCategory(element.getAttribute(DOCGEN_PAGE_EXTENSION_ELEMENT__CATEGORY));
        peElement.setDescription(element.getAttribute(DOCGEN_PAGE_EXTENSION_ELEMENT__DESCRIPTION));
        String deaultActivationStatus = element.getAttribute(DOCGEN_PAGE_EXTENSION_ELEMENT__DEFAULT_STATUS);
        peElement.setDefaultActivationStatus(PageExtensionElement.PageExtensionActivationStatus.getStatus(deaultActivationStatus));
        try {
            Object helper = element.createExecutableExtension(DOCGEN_PAGE_EXTENSION_ELEMENT__DIAGRAMHELPER);
            if (helper instanceof IDiagramHelper) {
                peElement.setDiagramHelper((IDiagramHelper)helper);
            }
        }
        catch (CoreException coreException) {
            peElement.setDiagramHelper(null);
        }
        try {
            Object fileNS = element.createExecutableExtension(DOCGEN_PAGE_EXTENSION_ELEMENT__FILENAMESERVICE);
            if (fileNS instanceof IFileNameService) {
                peElement.setFileNameService((IFileNameService)fileNS);
            }
        }
        catch (CoreException coreException) {
            peElement.setFileNameService(null);
        }
        return peElement;
    }
}

