/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.diagram.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.impl.EcoreFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.presentation.EcoreActionBarContributor;
import org.eclipse.emf.ecore.provider.EClassItemProvider;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.editing.EditingDomainFactoryService;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.polarsys.kitalpha.emde.diagram.Activator;
import org.polarsys.kitalpha.emde.diagram.services.ReadOnlyResourceManager;
import org.polarsys.kitalpha.emde.model.EmdePackage;

public class ExtensibilityService {
    private static final EClass MODEL_ELEMENT_ECLASS = ExtensibilityService.convert(EmdePackage.Literals.EXTENSIBLE_ELEMENT);
    private static final EClassItemProvider ECLASS_ITEM_PROVIDER = new EClassItemProvider((AdapterFactory)new EcoreItemProviderAdapterFactory());
    private static final String EXTENDING = "Extensible: ";
    private static final String PLATFORM_PLUGIN = "platform:/plugin";
    private static final String PLATFORM_RESOURCE = "platform:/resource";
    private static final String MODEL_TO_BE_EXTENDED = "model to be extended";
    private static final String EXTENSION_MODEL = "extension model";
    private static final String SELECT = "Select ";
    private static final String SELECTION_DIALOG = "Selection dialog";
    private static final NullProgressMonitor NPM = new NullProgressMonitor();
    private static TransactionalEditingDomain editingDomain = EditingDomainFactoryService.INSTANCE.getEditingDomainFactory().createEditingDomain();
    public static final String EXTENDED_ELEMENT = "ExtendedElement";
    public static final String MAPPING = "Mapping";
    public static final String SOURCE2 = "http://www.polarsys.org/kitalpha/emde/1.0.0/constraint";
    public static final String SOURCE3 = "http://www.polarsys.org/kitalpha/emde/1.0.0/constraintMapping";
    private static final String EXTENDS_MODEL_LABEL = "Extends Model";
    private static final String EXTENSIBLE_MODEL_LABEL = "Extensible Model";
    public static final String USE_UUIDS_LABEL = "Use UUIDs";
    public static final String USE_ID_ATTRIBUTES_LABEL = "Use ID Attributes";
    private static final String CHILD_CREATION_EXTENDERS = "childCreationExtenders";
    private static final String EXTENSIBLE_PROVIDER_FACTORY = "extensibleProviderFactory";
    public static final String USE_UUIDS = "useUUIDs";
    public static final String USE_ID_ATTRIBUTES = "useIDAttributes";
    private static final String NEW_SOURCE = "http://www.polarsys.org/kitalpha/emde/1.0.0/extension";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static URI emdeURI = null;

    public boolean isExtensible(EClass eClass) {
        return ExtensibilityService.isInstanceOf(eClass, EmdePackage.Literals.EXTENSIBLE_ELEMENT);
    }

    public boolean isExtensibleModelElement(EClass eClass) {
        return ExtensibilityService.isInstanceOf(eClass, EmdePackage.Literals.ELEMENT_EXTENSION);
    }

    public static boolean isInstanceOf(EClass eClass, EClass superType) {
        EClass newSP = ExtensibilityService.convert(superType);
        for (EClass sp : eClass.getESuperTypes()) {
            if (!EcoreUtil.equals((EObject)sp, (EObject)newSP)) continue;
            return true;
        }
        return false;
    }

    public Collection<Object> getEntry(EPackage ePackage) {
        EAnnotation annotation = ePackage.getEAnnotation(NEW_SOURCE);
        if (annotation != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (EObject eObject : annotation.eContents()) {
                EStringToStringMapEntryImpl entry;
                if (!(eObject instanceof EStringToStringMapEntryImpl) || !this.isQualified((entry = (EStringToStringMapEntryImpl)eObject).getKey())) continue;
                result.add(entry);
            }
            if (!result.isEmpty()) {
                this.init(annotation);
                return this.getEntry(ePackage);
            }
            return result;
        }
        this.init(ePackage);
        return this.getEntry(ePackage);
    }

    private void init(EPackage ePackage) {
        EAnnotation annotation = ePackage.getEAnnotation(NEW_SOURCE);
        if (annotation == null) {
            annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource(NEW_SOURCE);
            this.init(annotation);
            ePackage.getEAnnotations().add((Object)annotation);
        }
        try {
            Session session = SessionManager.INSTANCE.getSession((EObject)ePackage);
            session.addSemanticResource(ExtensibilityService.convert(EmdePackage.Literals.ELEMENT_EXTENSION).eResource().getURI(), (IProgressMonitor)NPM);
        }
        catch (Exception exception) {}
    }

    private void init(EAnnotation annotation) {
        this.addNewEntry(annotation, EXTENSIBLE_PROVIDER_FACTORY);
        this.addNewEntry(annotation, CHILD_CREATION_EXTENDERS);
        this.addNewEntry(annotation, USE_UUIDS);
        this.addNewEntry(annotation, USE_ID_ATTRIBUTES);
    }

    private void addNewEntry(EAnnotation eAnnotation, String key) {
        EStringToStringMapEntryImpl entry = ExtensibilityService.createNewEntry(key);
        if (key.equals(USE_ID_ATTRIBUTES)) {
            entry.setValue(FALSE);
        } else {
            entry.setValue(TRUE);
        }
        eAnnotation.getDetails().add((Object)entry);
    }

    private boolean isQualified(String key) {
        if (key.equals(USE_UUIDS)) {
            return true;
        }
        if (key.equals(USE_ID_ATTRIBUTES)) {
            return true;
        }
        if (key.equals(EXTENSIBLE_PROVIDER_FACTORY)) {
            return true;
        }
        return key.equals(CHILD_CREATION_EXTENDERS);
    }

    public String getEntryLabel(String key) {
        if (key.equals(USE_UUIDS)) {
            return USE_UUIDS_LABEL;
        }
        if (key.equals(USE_ID_ATTRIBUTES)) {
            return USE_ID_ATTRIBUTES_LABEL;
        }
        if (key.equals(EXTENSIBLE_PROVIDER_FACTORY)) {
            return EXTENSIBLE_MODEL_LABEL;
        }
        if (key.equals(CHILD_CREATION_EXTENDERS)) {
            return EXTENDS_MODEL_LABEL;
        }
        return "";
    }

    public Collection<EObject> getExtendedModel(EPackage ePackage) {
        if (ePackage.getEAnnotation(NEW_SOURCE) == null) {
            this.init(ePackage);
        }
        UniqueEList result = new UniqueEList();
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            result.addAll(this.getExtendedModel(eClassifier));
        }
        return result;
    }

    public Collection<EObject> getExtendedModel(EClassifier eClassifier) {
        EAnnotation annotation = eClassifier.getEAnnotation(SOURCE3);
        if (annotation != null) {
            for (Map.Entry entry : annotation.getDetails()) {
                if (!(entry instanceof EStringToStringMapEntryImpl)) continue;
                return ExtensibilityService.getExtendedModel((EStringToStringMapEntryImpl)entry);
            }
        }
        return Collections.emptyList();
    }

    public static Collection<EObject> getExtendedModel(EStringToStringMapEntryImpl entry) {
        if (entry.getKey().equals(MAPPING)) {
            UniqueEList result = new UniqueEList();
            StringTokenizer stringTokenizer = new StringTokenizer(entry.getValue());
            if (editingDomain == null) {
                editingDomain = EditingDomainFactoryService.INSTANCE.getEditingDomainFactory().createEditingDomain();
            }
            ResourceSet resourceSet = editingDomain.getResourceSet();
            while (stringTokenizer.hasMoreTokens()) {
                String uriString = stringTokenizer.nextToken();
                URI uri = URI.createURI((String)uriString);
                EObject object = null;
                try {
                    object = resourceSet.getEObject(uri, true);
                }
                catch (Exception exception) {}
                if (object == null && uri.isPlatformResource()) {
                    String s = uri.toString().replace(PLATFORM_RESOURCE, PLATFORM_PLUGIN);
                    object = resourceSet.getEObject(URI.createURI((String)s), true);
                }
                if (object == null) continue;
                result.add(object);
                Session session = SessionManager.INSTANCE.getSession((EObject)entry);
                Collection semanticResources = session.getSemanticResources();
                boolean addResource = true;
                for (Resource resource : semanticResources) {
                    if (!resource.getURI().toString().equalsIgnoreCase(object.eResource().getURI().toString())) continue;
                    addResource = false;
                    break;
                }
                if (addResource) {
                    session.addSemanticResource(object.eResource().getURI(), (IProgressMonitor)NPM);
                }
                try {
                    if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null || PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() == null || !(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor() instanceof DiagramEditor)) continue;
                    DiagramEditPart diagramEditPart = ((DiagramEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getDiagramEditPart();
                    ReadOnlyResourceManager.handler(diagramEditPart, entry.eResource(), object.eResource());
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.polarsys.kitalpha.emde.diagram", e.getMessage(), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    private Collection<EObject> openDialog(EObject receiver) {
        List selectionList;
        EcoreActionBarContributor.ExtendedLoadResourceAction.ExtendedLoadResourceDialog loadResourceDialog = new EcoreActionBarContributor.ExtendedLoadResourceAction.ExtendedLoadResourceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (EditingDomain)editingDomain);
        loadResourceDialog.open();
        ArrayList uriList = null;
        try {
            selectionList = loadResourceDialog.getURIs();
            uriList = new ArrayList(selectionList);
        }
        catch (RuntimeException runtimeException) {}
        loadResourceDialog = null;
        if (uriList != null && !uriList.isEmpty()) {
            selectionList = new UniqueEList();
            for (URI uri : uriList) {
                if (editingDomain == null) {
                    editingDomain = EditingDomainFactoryService.INSTANCE.getEditingDomainFactory().createEditingDomain();
                }
                Resource r = editingDomain.getResourceSet().getResource(uri, true);
                try {
                    EPackage ePackage = (EPackage)r.getContents().get(0);
                    if (ePackage == null) continue;
                    for (EObject eObject : ePackage.eContents()) {
                        if (!(eObject instanceof EClass)) continue;
                        selectionList.add(eObject);
                    }
                }
                catch (Exception exception) {}
            }
            return selectionList;
        }
        return null;
    }

    public Object getAllExtendedModel(EObject receiver) {
        if (receiver instanceof EClass) {
            return receiver;
        }
        if (receiver instanceof EPackage) {
            UniqueEList input = new UniqueEList();
            EPackage ePackage = (EPackage)receiver;
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || !this.isExtensibleModelElement(eClass = (EClass)eClassifier)) continue;
                input.add(eClass);
            }
            if (!input.isEmpty()) {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new EcoreItemProviderAdapterFactory()));
                dialog.setElements(input.toArray());
                dialog.setMultipleSelection(true);
                dialog.setTitle(SELECTION_DIALOG);
                dialog.setMessage("Select extension model");
                if (dialog.open() == 0) {
                    return dialog.getResult();
                }
            }
        }
        return null;
    }

    public Collection<EClass> openDialog3(EClass receiver) {
        Object[] selectedElement = this.openDialog2((EObject)receiver);
        HashSet<EClass> selectedEClasses = new HashSet<EClass>();
        Object[] objectArray = selectedElement;
        int n = selectedElement.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            selectedEClasses.add((EClass)object);
            ++n2;
        }
        return selectedEClasses;
    }

    public Object[] openDialog2(EObject receiver) {
        Collection<EObject> list = this.openDialog(receiver);
        if (list != null && !list.isEmpty()) {
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new EcoreItemProviderAdapterFactory()));
            dialog.setElements(list.toArray());
            dialog.setMultipleSelection(true);
            dialog.setTitle(SELECTION_DIALOG);
            dialog.setMessage("Select model to be extended");
            if (dialog.open() == 0) {
                return dialog.getResult();
            }
        }
        return Collections.emptyList().toArray();
    }

    public Object[] getExtensionElement(EPackage ePackage) {
        UniqueEList result = new UniqueEList();
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            EClass eClass;
            if (!(eClassifier instanceof EClass) || !this.isExtensibleModelElement(eClass = (EClass)eClassifier)) continue;
            result.add(eClass);
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new EcoreItemProviderAdapterFactory()));
        dialog.setElements(result.toArray());
        dialog.setMultipleSelection(true);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return Collections.emptyList().toArray();
    }

    public Collection<EObject> getSelectionCandidate(EObject eObject, DSemanticDiagram diagram) {
        ArrayList<EClass> eClasses = new ArrayList<EClass>();
        EPackage ePackage = null;
        ePackage = eObject instanceof EPackage ? (EPackage)eObject : (EPackage)diagram.getTarget();
        EList eClassifiers = ePackage.getEClassifiers();
        for (EClassifier eClassifier : eClassifiers) {
            if (!(eClassifier instanceof EClass)) continue;
            eClasses.add((EClass)eClassifier);
        }
        HashSet<DDiagramElement> dElement = new HashSet<DDiagramElement>();
        for (DDiagramElement dDiagramElement : diagram.getOwnedDiagramElements()) {
            if (!(dDiagramElement instanceof DNodeList)) continue;
            dElement.add(dDiagramElement);
        }
        return this.getSelectionCandidate(eClasses, dElement);
    }

    public Collection<EObject> getSelectionCandidate(Collection<EClass> candidateList, Collection<DDiagramElement> displayedList) {
        UniqueEList result = new UniqueEList(candidateList);
        if (displayedList != null && !displayedList.isEmpty()) {
            for (DDiagramElement element : displayedList) {
                result.remove(element.getTarget());
            }
        }
        return result;
    }

    public static EStringToStringMapEntryImpl createNewEntry(String key) {
        EStringToStringMapEntryImpl entry = (EStringToStringMapEntryImpl)((EcoreFactoryImpl)EcoreFactory.eINSTANCE).createEStringToStringMapEntry();
        entry.setKey(key);
        return entry;
    }

    public static EClass convert(EClass superType) {
        ResourceSet resourceSet;
        EObject object;
        Resource resource = superType.eResource();
        URI uri = resource.getURI();
        if (emdeURI == null) {
            emdeURI = ExtensibilityService.convert(uri, "http://www.polarsys.org/kitalpha/emde/1.0.0");
        }
        URI objectURI = EcoreUtil.getURI((EObject)superType);
        String newURI = objectURI.toString().replace(uri.toString(), emdeURI.toString());
        if (editingDomain == null) {
            editingDomain = EditingDomainFactoryService.INSTANCE.getEditingDomainFactory().createEditingDomain();
        }
        if ((object = (resourceSet = editingDomain.getResourceSet()).getEObject(URI.createURI((String)newURI), true)) instanceof EClass) {
            return (EClass)object;
        }
        return null;
    }

    public static URI convert(URI uri, String ns) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
        URI location = (URI)ePackageNsURItoGenModelLocationMap.get(uri.toString());
        Resource resource = resourceSet.getResource(location, true);
        EcoreUtil.resolveAll((Resource)resource);
        for (Resource r : resourceSet.getResources()) {
            EcoreUtil.ContentTreeIterator<Object> j = new EcoreUtil.ContentTreeIterator<Object>((Collection)r.getContents()){
                private static final long serialVersionUID = 1L;

                protected Iterator<? extends EObject> getEObjectChildren(EObject eObject) {
                    return eObject instanceof EPackage ? ((EPackage)eObject).getESubpackages().iterator() : Collections.emptyList().iterator();
                }
            };
            while (j.hasNext()) {
                EPackage ePackage;
                Object content = j.next();
                if (!(content instanceof EPackage) || !ns.equals((ePackage = (EPackage)content).getNsURI())) continue;
                return r.getURI();
            }
        }
        return null;
    }

    public static EAnnotation getAnnotation(EClass owner, String source) {
        EAnnotation eAnnotation = owner.getEAnnotation(source);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(source);
            owner.getEAnnotations().add((Object)eAnnotation);
        }
        return eAnnotation;
    }

    public static void clean(EObject view, Collection<EObject> objectList) {
        DView container;
        if (!objectList.isEmpty() && (container = ExtensibilityService.getContainer(view)) != null) {
            UniqueEList resourceList = new UniqueEList();
            EList ownedRepresentationDescs = container.getOwnedRepresentationDescriptors();
            for (DRepresentationDescriptor dRepresentationDesc : ownedRepresentationDescs) {
                DRepresentation dRepresentation = dRepresentationDesc.getRepresentation();
                if (!(dRepresentation instanceof DDiagram)) continue;
                DDiagram diagram = (DDiagram)dRepresentation;
                for (DDiagramElement element : diagram.getOwnedDiagramElements()) {
                    EObject target = element.getTarget();
                    if (!(target instanceof EClass) || objectList.contains(target)) continue;
                    resourceList.add(target.eResource());
                }
            }
            UniqueEList potentialToBeDeletedList = new UniqueEList();
            for (EObject eObject : objectList) {
                potentialToBeDeletedList.add(eObject.eResource());
            }
            potentialToBeDeletedList.removeAll((Collection<?>)resourceList);
            if (!potentialToBeDeletedList.isEmpty()) {
                Session session = SessionManager.INSTANCE.getSession((Resource)potentialToBeDeletedList.get(0));
                for (Resource resource : potentialToBeDeletedList) {
                    try {
                        session.removeSemanticResource(resource, (IProgressMonitor)NPM, false);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static DView getContainer(EObject view) {
        EObject container = view.eContainer();
        if (container != null) {
            if (container instanceof DView) {
                return (DView)container;
            }
            return ExtensibilityService.getContainer(container);
        }
        return null;
    }

    public static EStringToStringMapEntryImpl getEntry(EAnnotation annotation, String key) {
        for (Map.Entry entry : annotation.getDetails()) {
            if (!key.equals(entry.getKey())) continue;
            return (EStringToStringMapEntryImpl)entry;
        }
        EStringToStringMapEntryImpl newEntry = ExtensibilityService.createNewEntry(key);
        annotation.getDetails().add((Object)newEntry);
        return newEntry;
    }

    public String getValue(EObject receiver) {
        if (receiver instanceof EStringToStringMapEntryImpl) {
            return ((EStringToStringMapEntryImpl)receiver).getValue();
        }
        if (receiver instanceof EClass) {
            for (EClass eClass : ((EClass)receiver).getEAllSuperTypes()) {
                if (!EcoreUtil.equals((EObject)eClass, (EObject)MODEL_ELEMENT_ECLASS)) continue;
                return TRUE;
            }
            return FALSE;
        }
        return null;
    }

    public String getLineLabel(EClass eClass) {
        StringBuilder builder = new StringBuilder();
        builder.append(EXTENDING);
        String text = ECLASS_ITEM_PROVIDER.getText((Object)eClass);
        builder.append(text);
        return builder.toString();
    }
}

