/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.core.notification;

import ca.odell.glazedlists.ObservableElementList;
import java.util.Collection;
import java.util.EventListener;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.polarsys.kitalpha.massactions.core.glazedlists.MAObservableElementList;

public class MAConnector
implements ObservableElementList.Connector<EObject> {
    protected MAObservableElementList list;
    protected MAEObjectChangedListener eObjectChangedListener = this.createEObjectChangedListener();
    protected LockStatusChangedListener lockStatusChangedListener = this.createLockStatusChangedListener();

    public EventListener installListener(EObject element) {
        EList adapters = element.eAdapters();
        if (!adapters.contains(this.eObjectChangedListener)) {
            adapters.add(this.eObjectChangedListener);
        }
        IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(element);
        permissionAuthority.addAuthorityListener((IAuthorityListener)this.lockStatusChangedListener);
        return this.eObjectChangedListener;
    }

    public void uninstallListener(EObject element, EventListener listener) {
        if (listener instanceof MAEObjectChangedListener) {
            element.eAdapters().remove((Object)((MAEObjectChangedListener)listener));
        }
    }

    public void setObservableElementList(ObservableElementList<? extends EObject> list) {
        this.list = (MAObservableElementList)list;
    }

    protected MAEObjectChangedListener createEObjectChangedListener() {
        return new MAEObjectChangedListener();
    }

    protected LockStatusChangedListener createLockStatusChangedListener() {
        return new LockStatusChangedListener();
    }

    public class LockStatusChangedListener
    implements IAuthorityListener {
        public void notifyIsLocked(EObject instance) {
            MAConnector.this.list.elementChanged(instance);
        }

        public void notifyIsReleased(EObject instance) {
            MAConnector.this.list.elementChanged(instance);
        }

        public void notifyIsLocked(Collection<EObject> instances) {
            MAConnector.this.list.multipleElementsChanged(instances);
        }

        public void notifyIsReleased(Collection<EObject> instances) {
            MAConnector.this.list.multipleElementsChanged(instances);
        }
    }

    public class MAEObjectChangedListener
    extends AdapterImpl
    implements EventListener {
        private void objectChangedAction(Object notifier) {
            MAConnector.this.list.elementChanged(notifier);
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getEventType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.objectChangedAction(notification.getNotifier());
                    break;
                }
            }
        }
    }
}

