/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.extension.registry;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.polarsys.kitalpha.emde.extension.utils.Log;

public abstract class RegistryProvider
implements IRegistryChangeListener {
    private static final String TAG_DESCRIPTION = "description";
    private static final Map<String, IExtension[]> extensionPoints = Collections.synchronizedMap(new Hashtable());
    private final String pluginID;
    private final String extensionPointName;
    private final String extensionPointID;
    private static final Comparator<IExtension> comparer = new Comparator<IExtension>(){

        @Override
        public int compare(IExtension i1, IExtension i2) {
            String s1 = i1.getNamespaceIdentifier();
            String s2 = i2.getNamespaceIdentifier();
            return s1.compareToIgnoreCase(s2);
        }
    };

    protected RegistryProvider(String pluginID, String extensionPointName) {
        Assert.isNotNull((Object)extensionPointName, (String)"extensionPointName cannot be null");
        Assert.isLegal((extensionPointName.trim().length() > 0 ? 1 : 0) != 0, (String)"extensionPointName cannot be empty");
        Assert.isNotNull((Object)pluginID, (String)"pluginID cannot be null");
        Assert.isLegal((pluginID.trim().length() > 0 ? 1 : 0) != 0, (String)"pluginID cannot be empty");
        this.extensionPointName = extensionPointName;
        this.pluginID = pluginID;
        this.extensionPointID = String.valueOf(pluginID) + "-" + extensionPointName;
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    public static Map<String, IExtension[]> getExtensionPoints() {
        return extensionPoints;
    }

    public void dispose() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    protected abstract void addExtension(IExtension var1);

    protected abstract void removeExtension(IExtension var1);

    public void registryChanged(IRegistryChangeEvent event) {
        if (!Platform.isRunning()) {
            return;
        }
        IExtensionDelta[] delta = event.getExtensionDeltas(this.pluginID);
        int i = 0;
        while (i < delta.length) {
            switch (delta[i].getKind()) {
                case 1: {
                    this.addExtension(delta[i].getExtension());
                    break;
                }
                case 2: {
                    this.removeExtension(delta[i].getExtension());
                    break;
                }
            }
            ++i;
        }
    }

    protected String getDescription(IConfigurationElement config) {
        IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
        if (children.length >= 1) {
            return children[0].getValue();
        }
        return "";
    }

    protected void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        String pluginId = extension.getNamespaceIdentifier();
        StringBuffer buf = new StringBuffer();
        buf.append("Plugin '" + pluginId + "', extension '" + extension.getExtensionPointUniqueIdentifier() + "'");
        buf.append("\n" + text);
        Log.getDefault().logInfo(buf.toString());
    }

    protected void logMissingAttribute(IConfigurationElement element, String attributeName) {
        this.logError(element, "Required attribute '" + attributeName + "' not defined");
    }

    protected void logMissingElement(IConfigurationElement element, String elementName) {
        this.logError(element, "Required sub element '" + elementName + "' not defined");
    }

    protected void logUnknownElement(IConfigurationElement element) {
        this.logError(element, "Unknown extension tag found: '" + element.getName() + "'");
    }

    protected IExtension[] orderExtensions(IExtension[] extensions) {
        IExtension[] sortedExtension = new IExtension[extensions.length];
        System.arraycopy(extensions, 0, sortedExtension, 0, extensions.length);
        Collections.sort(Arrays.asList(sortedExtension), comparer);
        return sortedExtension;
    }

    protected abstract boolean readElement(IConfigurationElement var1);

    protected void readElementChildren(IConfigurationElement element) {
        this.readElements(element.getChildren());
    }

    protected void readElements(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!this.readElement(elements[i])) {
                this.logUnknownElement(elements[i]);
            }
            ++i;
        }
    }

    protected void readExtension(IExtension extension) {
        this.readElements(extension.getConfigurationElements());
    }

    protected void readRegistry(IExtensionRegistry registry) {
        IExtension[] extensions = extensionPoints.get(this.extensionPointID);
        if (extensions == null) {
            IExtensionPoint point = registry.getExtensionPoint(this.pluginID, this.extensionPointName);
            if (point == null) {
                return;
            }
            extensions = point.getExtensions();
            extensions = this.orderExtensions(extensions);
            extensionPoints.put(this.extensionPointID, extensions);
        }
        int i = 0;
        while (i < extensions.length) {
            this.readExtension(extensions[i]);
            ++i;
        }
    }
}

