/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.desc.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.portfolio.genchain.extension.ExtensionHelper;
import org.eclipse.egf.portfolio.genchain.generationChain.EmfGeneration;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChain;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChainFactory;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationElement;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.common.tools.api.editing.EditingDomainFactoryService;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetFactory;
import org.polarsys.kitalpha.ad.ta.extension.ITargetApplication;
import org.polarsys.kitalpha.ad.ta.extension.TargetApplicationExtensionManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.configuration.VpDslConfigurationHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.manager.VpdslDescriptionModelManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.conf.chain.GenerationChainConfiguration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.desc.helper.GenerationCreatingCommand;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.desc.operation.AbstractGenerationOperation;

public class GenchainGenerationOperation
extends AbstractGenerationOperation {
    protected TransactionalEditingDomain _editingDomain;
    protected ResourceSet _resourceSet;

    public GenchainGenerationOperation(String projectName, String ecoreModelName, String modelsFolder) {
        super(projectName, ecoreModelName, modelsFolder);
    }

    protected void execute(IProgressMonitor monitor) {
        this.setMonitor(monitor);
        try {
            Resource genchainResource = this.getGenerationChainResource();
            genchainResource.save(null);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String setupModelExtension() {
        return "generationchain";
    }

    private Resource getGenerationChainResource() throws CoreException {
        GenerationChain chain = this.createGenerationChain();
        EObject genchainRootElement = EcoreUtil.getRootContainer((EObject)chain);
        Resource resource = this.createGenerationChainResource();
        resource.getContents().add((Object)genchainRootElement);
        List<RecordingCommand> elementsCmds = this.getElementGenerationCommands(chain);
        if (elementsCmds != null && elementsCmds.size() > 0) {
            RecordingCommand configurationCommand;
            CompoundCommand genchainCreationCommands = new CompoundCommand();
            for (RecordingCommand genCmd : elementsCmds) {
                genchainCreationCommands.append((Command)genCmd);
            }
            RecordingCommand setupCommand = this.getSetupCommand(chain);
            if (setupCommand != null) {
                genchainCreationCommands.append((Command)setupCommand);
            }
            if ((configurationCommand = this.getConfigurationCommand(chain)) != null) {
                genchainCreationCommands.append((Command)configurationCommand);
            }
            this.getEditingDomain().getCommandStack().execute((Command)genchainCreationCommands);
        }
        return resource;
    }

    public TransactionalEditingDomain getEditingDomain() {
        if (this._editingDomain == null || this._editingDomain.getCommandStack() == null) {
            this._editingDomain = EditingDomainFactoryService.INSTANCE.getEditingDomainFactory().createEditingDomain(this._resourceSet);
        }
        return this._editingDomain;
    }

    protected Resource createGenerationChainResource() {
        URI genchainURI = this.getModelUri(true);
        this._resourceSet = ResourceSetFactory.createFactory().createResourceSet(genchainURI);
        Resource resource = this._resourceSet.createResource(genchainURI);
        return resource;
    }

    protected GenerationChain createGenerationChain() {
        GenerationChain genchainRootElement = GenerationChainFactory.eINSTANCE.createGenerationChain();
        genchainRootElement.setName(this._shortName);
        genchainRootElement.setFactoryComponentName(this._projectName);
        GenerationChain chain = GenerationChainFactory.eINSTANCE.createGenerationChain();
        EPackage ePackage = (EPackage)this._ecoreResource.getContents().get(0);
        chain.setName(ePackage.getName());
        genchainRootElement.getElements().add((Object)chain);
        return chain;
    }

    protected RecordingCommand getSetupCommand(final GenerationChain chain) {
        RecordingCommand command = new RecordingCommand(this.getEditingDomain()){

            protected void doExecute() {
                for (GenerationElement element : chain.getElements()) {
                    String ecoreFQN = "/" + GenchainGenerationOperation.this._projectName + "/" + GenchainGenerationOperation.this._modelsFolder + "/" + GenchainGenerationOperation.this._shortName + "." + "ecore";
                    if (!(element instanceof EmfGeneration)) continue;
                    EmfGeneration model = (EmfGeneration)element;
                    model.setGenerateEditor(false);
                    model.setBasePackage(GenchainGenerationOperation.this._projectName);
                    model.setModelPath(ecoreFQN);
                    model.setPluginName(String.valueOf(GenchainGenerationOperation.this._projectName) + ".model");
                }
            }
        };
        return command;
    }

    protected RecordingCommand getConfigurationCommand(final GenerationChain chain) {
        RecordingCommand command = new RecordingCommand(this.getEditingDomain()){

            protected void doExecute() {
                GenerationChainConfiguration.configure((GenerationChain)chain, (boolean)true);
            }
        };
        return command;
    }

    protected List<RecordingCommand> getElementGenerationCommands(GenerationChain chain) throws CoreException {
        ArrayList<RecordingCommand> result = new ArrayList<RecordingCommand>();
        ArrayList<URI> uriList = new ArrayList<URI>();
        uriList.add(this._ecoreResource.getURI());
        Viewpoint vp = VpdslDescriptionModelManager.INSTANCE.getVpDescriptionElement();
        String targetApplication = VpDslConfigurationHelper.getTargetApplication((Object)vp);
        ITargetApplication iTargetApplication = TargetApplicationExtensionManager.getTargetApplicationClass((String)targetApplication);
        if (iTargetApplication != null) {
            List extesionList = iTargetApplication.getGenerationExtensionHelpers();
            for (ExtensionHelper extensionHelper : extesionList) {
                GenerationCreatingCommand subCommand = new GenerationCreatingCommand(this.getEditingDomain(), chain, uriList, extensionHelper);
                result.add(subCommand);
            }
        }
        return result;
    }
}

