/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.wizards;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.extensions.ConcreteSyntaxResourceCreationManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.message.Messages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.utils.NamesValidityChecker;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.wizards.DefaultWizardSelection;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.wizards.NewDSLVpProjectWizard;

public class NewDSLVpProjectSecondPage
extends WizardPage {
    private String vpTargetApplication = "";
    private String vpShortName = "";
    protected Map<String, String> availableCreator = new HashMap<String, String>();
    protected Map<String, String> selectedCreator = new HashMap<String, String>();
    private Text vpRootProjectNameText;
    private Text vpDescriptionProjectNameText;
    private List lSelectedCreators;
    private List lAvailableCreators;
    private Button bAdd;
    private Button bRemove;
    private Button bAddAll;
    private Button bRemoveAll;
    private static final int availableCreator_source = 0;
    private static final int selectedCreator_source = 1;

    public void setVisible(boolean visible) {
        String newTargetApp;
        super.setVisible(visible);
        boolean dataChanged = false;
        String newShortName = ((NewDSLVpProjectWizard)this.getWizard()).getVpShortName().toLowerCase();
        if (!newShortName.equals(this.vpShortName)) {
            this.vpShortName = newShortName;
            dataChanged = true;
        }
        if (!(newTargetApp = ((NewDSLVpProjectWizard)this.getWizard()).getVpTargetApplication()).equals(this.vpTargetApplication)) {
            this.vpTargetApplication = newTargetApp;
            dataChanged = true;
        }
        String vpRootProjectName = ((NewDSLVpProjectWizard)this.getWizard()).getVpRootProjectName();
        String vpDescriptionProjectName = ((NewDSLVpProjectWizard)this.getWizard()).getVpDescriptionProjectName();
        if (this.vpRootProjectNameText.getText().length() == 0 || dataChanged) {
            this.vpRootProjectNameText.setText(vpRootProjectName.toLowerCase());
        }
        if (this.vpDescriptionProjectNameText.getText().length() == 0 || dataChanged) {
            this.vpDescriptionProjectNameText.setText(vpDescriptionProjectName.toLowerCase());
        }
    }

    public NewDSLVpProjectSecondPage(ISelection selection) {
        super(Messages.Wizard_Page2_Title);
    }

    public NewDSLVpProjectSecondPage() {
        super(Messages.Wizard_Page2_Title);
    }

    public void createControl(Composite parent) {
        Composite cparent = new Composite(parent, 0);
        cparent.setLayoutData((Object)new GridData(768));
        cparent.setLayout((Layout)new GridLayout(1, false));
        this.computeDefaultSelectedCreator();
        this.createConcretSyntaxWidgets(cparent);
        this.createProjectsWidgets(cparent);
        this.setControl((Control)cparent);
        this.vpDataChanged();
    }

    protected Map<String, String> getAvailableConcreteSyntaxesHandlers() throws CoreException {
        return ConcreteSyntaxResourceCreationManager.getAvailableConcreteSyntaxResourceCreators();
    }

    private void computeDefaultSelectedCreator() {
        try {
            this.availableCreator = this.getAvailableConcreteSyntaxesHandlers();
            HashMap<String, String> availableCreatorMap = new HashMap<String, String>();
            availableCreatorMap.putAll(this.availableCreator);
            for (Map.Entry map : availableCreatorMap.entrySet()) {
                String creatorID = (String)map.getKey();
                if (!this.isDefaultRepresentation(creatorID)) continue;
                this.availableCreator.remove(map.getKey());
                this.selectedCreator.put((String)map.getKey(), (String)map.getValue());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected boolean isDefaultRepresentation(String represnetationManagerID) {
        return DefaultWizardSelection.isDefault(represnetationManagerID, 1);
    }

    private Composite createConcretSyntaxWidgets(Composite parent) {
        if (!(this.availableCreator != null && this.availableCreator.size() != 0 || this.selectedCreator != null && this.selectedCreator.size() != 0)) {
            return null;
        }
        Composite csComposit = new Composite(parent, 0);
        csComposit.setLayoutData((Object)new GridData(768));
        csComposit.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(csComposit, 0);
        label.setText(Messages.Wizard_Page2_Label_Representation_Select);
        GridData labelGD = new GridData(768);
        labelGD.horizontalSpan = 3;
        label.setLayoutData((Object)labelGD);
        this.lAvailableCreators = new List(csComposit, 2816);
        GridData lAvailableCreatorsGD = new GridData(1808);
        lAvailableCreatorsGD.widthHint = (csComposit.getSize().x - 50) / 2;
        this.lAvailableCreators.setLayoutData((Object)lAvailableCreatorsGD);
        this.lAvailableCreators.addSelectionListener((SelectionListener)new ListSelectionListener());
        this.lAvailableCreators.addMouseListener((MouseListener)new ListMouseListener());
        if (this.availableCreator != null && this.availableCreator.size() != 0) {
            Set<Map.Entry<String, String>> entrySet = this.availableCreator.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                this.lAvailableCreators.add(entry.getValue());
            }
        }
        Composite bCompo = new Composite(csComposit, 0);
        GridData bComboGD = new GridData(6);
        bComboGD.widthHint = 50;
        bCompo.setLayoutData((Object)bComboGD);
        bCompo.setLayout((Layout)new GridLayout(1, false));
        GridData bGridData = new GridData(1808);
        ButtonMouseListener listener = new ButtonMouseListener();
        this.bAdd = new Button(bCompo, 256);
        this.bAdd.setText(">");
        this.bAdd.setLayoutData((Object)bGridData);
        this.bAdd.addMouseListener((MouseListener)listener);
        this.bAdd.setEnabled(false);
        this.bRemove = new Button(bCompo, 256);
        this.bRemove.setText("<");
        this.bRemove.setLayoutData((Object)bGridData);
        this.bRemove.addMouseListener((MouseListener)listener);
        this.bRemove.setEnabled(false);
        this.bAddAll = new Button(bCompo, 256);
        this.bAddAll.setText(">>");
        this.bAddAll.setLayoutData((Object)bGridData);
        this.bAddAll.addMouseListener((MouseListener)listener);
        this.bRemoveAll = new Button(bCompo, 256);
        this.bRemoveAll.setText("<<");
        this.bRemoveAll.setLayoutData((Object)bGridData);
        this.bRemoveAll.addMouseListener((MouseListener)listener);
        this.bRemoveAll.setEnabled(false);
        this.lSelectedCreators = new List(csComposit, 2816);
        GridData lSelectedCreatorsGD = new GridData(1808);
        lSelectedCreatorsGD.widthHint = (csComposit.getSize().x - 50) / 2;
        this.lSelectedCreators.setLayoutData((Object)lSelectedCreatorsGD);
        this.lSelectedCreators.addSelectionListener((SelectionListener)new ListSelectionListener());
        this.lSelectedCreators.addMouseListener((MouseListener)new ListMouseListener());
        if (this.selectedCreator != null && this.selectedCreator.size() != 0) {
            Set<Map.Entry<String, String>> entrySet = this.selectedCreator.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                this.lSelectedCreators.add(entry.getValue());
                ((NewDSLVpProjectWizard)this.getWizard()).setSelectedConcreteSyntaxCreators(this.selectedCreator);
            }
        }
        return csComposit;
    }

    private Composite createProjectsWidgets(Composite parent) {
        Composite compo = new Composite(parent, 0);
        compo.setLayoutData((Object)new GridData(768));
        compo.setLayout((Layout)new GridLayout(2, false));
        Label rootProjectName = new Label(compo, 0);
        rootProjectName.setText(Messages.Wizard_Page2_Label_RootProject_Name);
        this.vpRootProjectNameText = new Text(compo, 2052);
        this.vpRootProjectNameText.setLayoutData((Object)new GridData(768));
        this.vpRootProjectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewDSLVpProjectSecondPage.this.vpDataChanged();
                ((NewDSLVpProjectWizard)NewDSLVpProjectSecondPage.this.getWizard()).setVpRootProjectName(NewDSLVpProjectSecondPage.this.vpRootProjectNameText.getText());
            }
        });
        Label descriptionProjectName = new Label(compo, 0);
        descriptionProjectName.setText(Messages.Wizard_Page2_Label_DescriptionProject_Name);
        this.vpDescriptionProjectNameText = new Text(compo, 2052);
        this.vpDescriptionProjectNameText.setLayoutData((Object)new GridData(768));
        this.vpDescriptionProjectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewDSLVpProjectSecondPage.this.vpDataChanged();
                ((NewDSLVpProjectWizard)NewDSLVpProjectSecondPage.this.getWizard()).setVpDescriptionProjectName(NewDSLVpProjectSecondPage.this.vpDescriptionProjectNameText.getText());
            }
        });
        return compo;
    }

    private boolean vpDataChanged() {
        String rootProjectName;
        String msg = Messages.Wizard_Page2_DataCheck_AlowedCharacters;
        String descProjectName = this.vpDescriptionProjectNameText.getText();
        if (descProjectName != null && descProjectName.trim().length() > 0) {
            if (!NamesValidityChecker.isValid(descProjectName, true)) {
                this.updateStatus(String.valueOf(Messages.Wizard_Page2_DataCheck_DescriptionProject_Invalid) + msg);
                return false;
            }
            IProject descProject = ResourcesPlugin.getWorkspace().getRoot().getProject(descProjectName);
            if (descProject.exists()) {
                this.updateStatus(Messages.bind((String)Messages.Wizard_Page2_DataCheck_ProjectExists, (Object)descProject.getName()));
                return false;
            }
        }
        if ((rootProjectName = this.vpRootProjectNameText.getText()) != null && rootProjectName.trim().length() > 0) {
            if (!NamesValidityChecker.isValid(rootProjectName, true)) {
                this.updateStatus(String.valueOf(Messages.Wizard_Page2_DataCheck_RootProjectName_Invalid) + msg);
                return false;
            }
            IProject rootProject = ResourcesPlugin.getWorkspace().getRoot().getProject(rootProjectName);
            if (rootProject.exists()) {
                this.updateStatus(Messages.bind((String)Messages.Wizard_Page2_DataCheck_ProjectExists, (Object)rootProject.getName()));
                return false;
            }
        }
        this.updateStatus(null);
        return true;
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getDslVpProjectName() {
        return this.vpDescriptionProjectNameText.getText();
    }

    class ButtonMouseListener
    implements MouseListener {
        ButtonMouseListener() {
        }

        public void mouseUp(MouseEvent e) {
            int index;
            String id;
            Button b = (Button)e.getSource();
            ListenerUtilities lUtil = new ListenerUtilities();
            if (b.equals(NewDSLVpProjectSecondPage.this.bAdd) && (id = lUtil.getCreatorID(0, index = NewDSLVpProjectSecondPage.this.lAvailableCreators.getSelectionIndex())) != null) {
                NewDSLVpProjectSecondPage.this.selectedCreator.put(id, NewDSLVpProjectSecondPage.this.availableCreator.get(id));
                NewDSLVpProjectSecondPage.this.availableCreator.remove(id);
                NewDSLVpProjectSecondPage.this.lAvailableCreators.setFocus();
            }
            if (b.equals(NewDSLVpProjectSecondPage.this.bRemove) && (id = lUtil.getCreatorID(1, index = NewDSLVpProjectSecondPage.this.lSelectedCreators.getSelectionIndex())) != null) {
                NewDSLVpProjectSecondPage.this.availableCreator.put(id, NewDSLVpProjectSecondPage.this.selectedCreator.get(id));
                NewDSLVpProjectSecondPage.this.selectedCreator.remove(id);
                NewDSLVpProjectSecondPage.this.lSelectedCreators.setFocus();
            }
            if (b.equals(NewDSLVpProjectSecondPage.this.bAddAll)) {
                NewDSLVpProjectSecondPage.this.selectedCreator.putAll(NewDSLVpProjectSecondPage.this.availableCreator);
                NewDSLVpProjectSecondPage.this.availableCreator.clear();
                NewDSLVpProjectSecondPage.this.lAvailableCreators.removeAll();
            }
            if (b.equals(NewDSLVpProjectSecondPage.this.bRemoveAll)) {
                NewDSLVpProjectSecondPage.this.availableCreator.putAll(NewDSLVpProjectSecondPage.this.selectedCreator);
                NewDSLVpProjectSecondPage.this.selectedCreator.clear();
                NewDSLVpProjectSecondPage.this.lSelectedCreators.removeAll();
            }
            ((NewDSLVpProjectWizard)NewDSLVpProjectSecondPage.this.getWizard()).setSelectedConcreteSyntaxCreators(NewDSLVpProjectSecondPage.this.selectedCreator);
            lUtil.updateUI();
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }
    }

    class ListMouseListener
    implements MouseListener {
        ListMouseListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            ListenerUtilities lUtil = new ListenerUtilities();
            List list = (List)e.getSource();
            if (list.equals(NewDSLVpProjectSecondPage.this.lAvailableCreators)) {
                int index = NewDSLVpProjectSecondPage.this.lAvailableCreators.getSelectionIndex();
                String id = lUtil.getCreatorID(0, index);
                if (id != null) {
                    NewDSLVpProjectSecondPage.this.selectedCreator.put(id, NewDSLVpProjectSecondPage.this.availableCreator.get(id));
                    NewDSLVpProjectSecondPage.this.availableCreator.remove(id);
                    NewDSLVpProjectSecondPage.this.lAvailableCreators.setFocus();
                }
            } else {
                int index = NewDSLVpProjectSecondPage.this.lSelectedCreators.getSelectionIndex();
                String id = lUtil.getCreatorID(1, index);
                if (id != null) {
                    NewDSLVpProjectSecondPage.this.availableCreator.put(id, NewDSLVpProjectSecondPage.this.selectedCreator.get(id));
                    NewDSLVpProjectSecondPage.this.selectedCreator.remove(id);
                    NewDSLVpProjectSecondPage.this.lSelectedCreators.setFocus();
                }
            }
            ((NewDSLVpProjectWizard)NewDSLVpProjectSecondPage.this.getWizard()).setSelectedConcreteSyntaxCreators(NewDSLVpProjectSecondPage.this.selectedCreator);
            lUtil.updateUI();
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
        }
    }

    class ListSelectionListener
    implements SelectionListener {
        ListSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            NewDSLVpProjectSecondPage.this.bAdd.setEnabled(NewDSLVpProjectSecondPage.this.lAvailableCreators.getSelectionIndex() != -1);
            NewDSLVpProjectSecondPage.this.bRemove.setEnabled(NewDSLVpProjectSecondPage.this.lSelectedCreators.getSelectionIndex() != -1);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    class ListenerUtilities {
        ListenerUtilities() {
        }

        public void updateUI() {
            Set<String> idSet;
            NewDSLVpProjectSecondPage.this.lAvailableCreators.removeAll();
            if (NewDSLVpProjectSecondPage.this.availableCreator != null && NewDSLVpProjectSecondPage.this.availableCreator.size() != 0) {
                idSet = NewDSLVpProjectSecondPage.this.availableCreator.keySet();
                for (String id : idSet) {
                    NewDSLVpProjectSecondPage.this.lAvailableCreators.add(NewDSLVpProjectSecondPage.this.availableCreator.get(id));
                }
            }
            NewDSLVpProjectSecondPage.this.lSelectedCreators.removeAll();
            if (NewDSLVpProjectSecondPage.this.availableCreator != null && NewDSLVpProjectSecondPage.this.selectedCreator.size() != 0) {
                idSet = NewDSLVpProjectSecondPage.this.selectedCreator.keySet();
                for (String id : idSet) {
                    NewDSLVpProjectSecondPage.this.lSelectedCreators.add(NewDSLVpProjectSecondPage.this.selectedCreator.get(id));
                }
            }
            NewDSLVpProjectSecondPage.this.bAdd.setEnabled(NewDSLVpProjectSecondPage.this.lAvailableCreators.getSelectionIndex() != -1 && NewDSLVpProjectSecondPage.this.availableCreator.size() != 0);
            NewDSLVpProjectSecondPage.this.bAddAll.setEnabled(NewDSLVpProjectSecondPage.this.availableCreator.size() != 0);
            NewDSLVpProjectSecondPage.this.bRemove.setEnabled(NewDSLVpProjectSecondPage.this.lSelectedCreators.getSelectionIndex() != -1 && NewDSLVpProjectSecondPage.this.selectedCreator.size() != 0);
            NewDSLVpProjectSecondPage.this.bRemoveAll.setEnabled(NewDSLVpProjectSecondPage.this.selectedCreator.size() != 0);
        }

        private String getCreatorID(int source, int index) {
            if (index == -1) {
                return null;
            }
            Set<String> key = null;
            switch (source) {
                case 0: {
                    key = NewDSLVpProjectSecondPage.this.availableCreator.keySet();
                    break;
                }
                case 1: {
                    key = NewDSLVpProjectSecondPage.this.selectedCreator.keySet();
                }
            }
            if (key == null) {
                return null;
            }
            Object[] list = key.toArray();
            return (String)list[index];
        }
    }
}

