/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.desc.ext.command;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.query.AbstractNodeMappingQuery;
import org.eclipse.sirius.diagram.business.internal.componentization.mappings.DiagramMappingsManagerRegistryImpl;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramSynchronizer;
import org.eclipse.sirius.diagram.business.internal.sync.DNodeCandidate;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.model.business.internal.helper.MappingHelper;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;

public class CreateNodeCommand
extends RecordingCommand {
    private DDiagram _diagram;
    private Session _session;
    private AbstractNodeMapping _mapping;
    private EObject _target;
    private DDiagramSynchronizer diagramSynchronizer;
    private DiagramMappingsManager diagramMappingsManager;
    private IInterpreter interpreter;
    private ModelAccessor modelAccessor;

    public CreateNodeCommand(Session session, DDiagram diagram, AbstractNodeMapping mapping, EObject target) {
        this(session.getTransactionalEditingDomain());
        this._diagram = diagram;
        this._session = session;
        this._mapping = mapping;
        this._target = target;
        this.interpreter = this._session.getInterpreter();
        this.diagramSynchronizer = new DDiagramSynchronizer(this.interpreter, this._diagram.getDescription(), this._session.getModelAccessor());
        this.diagramSynchronizer.setDiagram((DSemanticDiagram)this._diagram);
        this.diagramMappingsManager = DiagramMappingsManagerRegistryImpl.INSTANCE.getDiagramMappingsManager(this._session, this._diagram);
        this.modelAccessor = this._session.getModelAccessor();
    }

    private CreateNodeCommand(TransactionalEditingDomain domain) {
        super(domain);
    }

    protected void doExecute() {
        AbstractNodeMappingQuery abstractNodeMappingQuery = new AbstractNodeMappingQuery(this._mapping);
        boolean preCondition = abstractNodeMappingQuery.evaluatePrecondition((DSemanticDiagram)this._diagram, (DragAndDropTarget)this._diagram, this.interpreter, this._target);
        if (preCondition) {
            this.createNodeAndItChildrenNodes(this._target, this._mapping, (DragAndDropTarget)this._diagram);
        }
    }

    private void createNodeAndItChildrenNodes(EObject semantic, AbstractNodeMapping nodeMapping, DragAndDropTarget parent) {
        AbstractDNode parentNode = this.createOneNode(semantic, nodeMapping, parent);
        BasicEList childrenNodeMapping = new BasicEList();
        for (DiagramElementMapping iDiagramElementMapping : MappingHelper.getAllMappings((DiagramElementMapping)nodeMapping)) {
            if (!(iDiagramElementMapping instanceof AbstractNodeMapping)) continue;
            childrenNodeMapping.add((Object)((AbstractNodeMapping)iDiagramElementMapping));
        }
        for (AbstractNodeMapping childNodeMapping : childrenNodeMapping) {
            Collection candidatesSemanticChildren = new ArrayList();
            try {
                candidatesSemanticChildren = this.interpreter.evaluateCollection(semantic, childNodeMapping.getSemanticCandidatesExpression());
            }
            catch (EvaluationException e) {
                e.printStackTrace();
            }
            for (EObject childSemantic : candidatesSemanticChildren) {
                if (!this.modelAccessor.eInstanceOf(childSemantic, childNodeMapping.getDomainClass())) continue;
                this.createNodeAndItChildrenNodes(childSemantic, childNodeMapping, (DragAndDropTarget)parentNode);
            }
        }
    }

    private AbstractDNode createOneNode(EObject target, AbstractNodeMapping mapping, DragAndDropTarget parent) {
        RefreshIdsHolder refreshIdsHolder = new RefreshIdsHolder();
        DNodeCandidate abstractDNodeCandidate = new DNodeCandidate(mapping, target, parent, refreshIdsHolder);
        return this.diagramSynchronizer.getElementSynchronizer().createNewNode(this.diagramMappingsManager, abstractDNodeCandidate, false);
    }
}

