/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.output;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.util.IAcceptor;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.output.ITreeAppendable;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.output.SharedAppendableState;

public class TreeAppendable
implements ITreeAppendable,
IAcceptor<String>,
CharSequence {
    private List<Object> children = Lists.newArrayList();
    private final SharedAppendableState state;
    private boolean closed = false;

    public TreeAppendable(EObject source, String indentation, String lineSeparator) {
        this(new SharedAppendableState(indentation, lineSeparator), source);
    }

    public TreeAppendable(SharedAppendableState state, EObject source) {
        this.state = state;
    }

    @Override
    public ITreeAppendable trace(EObject object) {
        TreeAppendable result = new TreeAppendable(this.state, object);
        this.children.add(result);
        return result;
    }

    @Override
    public ITreeAppendable append(CharSequence content) {
        if (content instanceof ITreeAppendable) {
            return this.appendTreeAppendable((ITreeAppendable)((Object)content));
        }
        this.closeLastChild();
        this.appendIndented(content.toString());
        return this;
    }

    private void appendIndented(String text) {
        int length = text.length();
        int nextLineOffset = 0;
        int idx = 0;
        while (idx < length) {
            char currentChar = text.charAt(idx);
            if (currentChar == '\r') {
                int delimiterLength = 1;
                if (idx + 1 < length && text.charAt(idx + 1) == '\n') {
                    ++delimiterLength;
                    ++idx;
                }
                int lineLength = idx - delimiterLength - nextLineOffset + 1;
                this.children.add(text.substring(nextLineOffset, nextLineOffset + lineLength));
                nextLineOffset = idx + 1;
            } else if (currentChar == '\n') {
                int lineLength = idx - nextLineOffset;
                this.children.add(text.substring(nextLineOffset, nextLineOffset + lineLength));
                nextLineOffset = idx + 1;
            }
            ++idx;
        }
        if (nextLineOffset != length) {
            int lineLength = length - nextLineOffset;
            this.children.add(text.substring(nextLineOffset, nextLineOffset + lineLength));
        }
    }

    private void closeLastChild() {
        Object lastChild;
        if (this.closed) {
            throw new IllegalStateException("Tree Appendable was already closed");
        }
        if (!this.children.isEmpty() && (lastChild = this.children.get(this.children.size() - 1)) instanceof TreeAppendable) {
            ((TreeAppendable)lastChild).markClosed();
        }
    }

    private ITreeAppendable appendTreeAppendable(ITreeAppendable other) {
        this.closeLastChild();
        if (!(other instanceof TreeAppendable)) {
            throw new IllegalArgumentException("Unexpected implementation");
        }
        ((TreeAppendable)other).markClosed();
        this.children.add(other);
        return this;
    }

    private void markClosed() {
        if (this.closed) {
            return;
        }
        this.closeLastChild();
        this.closed = true;
    }

    @Override
    public ITreeAppendable newLine() {
        this.closeLastChild();
        this.state.appendNewLineAndIndentation(this);
        return this;
    }

    @Override
    public ITreeAppendable increaseIndentation() {
        this.closeLastChild();
        this.state.increaseIndentation();
        return this;
    }

    @Override
    public ITreeAppendable decreaseIndentation() {
        this.closeLastChild();
        this.state.decreaseIndentation();
        return this;
    }

    public void setChildren(List<Object> children) {
        this.children = children;
    }

    public List<Object> getChildren() {
        return this.children;
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public void accept(String text) {
        this.children.add(text);
    }

    public String getContent() {
        StringBuilder result = new StringBuilder(8192);
        this.doGetContent(result);
        return result.toString();
    }

    private void doGetContent(StringBuilder result) {
        for (Object child : this.children) {
            if (child instanceof String) {
                result.append(child);
                continue;
            }
            ((TreeAppendable)child).doGetContent(result);
        }
    }
}

