/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkUtil {
    private static final Logger s_logger = LoggerFactory.getLogger(NetworkUtil.class);

    private NetworkUtil() {
    }

    public static String calculateNetwork(String ipAddress, String netmask) {
        int ipAddressValue = NetworkUtil.convertIp4Address(ipAddress);
        int netmaskValue = NetworkUtil.convertIp4Address(netmask);
        int network = ipAddressValue & netmaskValue;
        return NetworkUtil.dottedQuad(network);
    }

    public static String calculateBroadcast(String ipAddress, String netmask) {
        int ipAddressValue = NetworkUtil.convertIp4Address(ipAddress);
        int netmaskValue = NetworkUtil.convertIp4Address(netmask);
        int network = ipAddressValue | ~netmaskValue;
        return NetworkUtil.dottedQuad(network);
    }

    public static String getNetmaskStringForm(int prefix) {
        if (prefix >= 1 && prefix <= 32) {
            int mask = ~((1 << 32 - prefix) - 1);
            return NetworkUtil.dottedQuad(mask);
        }
        throw new IllegalArgumentException("prefix is invalid: " + Integer.toString(prefix));
    }

    public static short getNetmaskShortForm(String netmask) {
        if (netmask == null) {
            throw new IllegalArgumentException("netmask is null");
        }
        int netmaskValue = NetworkUtil.convertIp4Address(netmask);
        boolean hitZero = false;
        int displayMask = Integer.MIN_VALUE;
        int count = 0;
        int c = 1;
        while (c <= 32) {
            if ((netmaskValue & displayMask) == 0) {
                hitZero = true;
            } else {
                if (hitZero) {
                    s_logger.error("received invalid mask: " + netmask);
                    throw new IllegalArgumentException("netmask is invalid: " + netmask);
                }
                ++count;
            }
            netmaskValue <<= 1;
            ++c;
        }
        return (short)count;
    }

    public static String dottedQuad(int ip) {
        CharSequence[] items = new String[4];
        int i = 3;
        while (i >= 0) {
            int value = ip & 0xFF;
            items[i] = Integer.toString(value);
            ip >>>= 8;
            --i;
        }
        return String.join((CharSequence)".", items);
    }

    public static int convertIp4Address(String ipAddress) {
        if (ipAddress == null) {
            throw new IllegalArgumentException("ipAddress is null");
        }
        String[] splitIpAddress = ipAddress.split("\\.");
        if (splitIpAddress.length != 4) {
            throw new IllegalArgumentException("ipAddress is invalid: " + ipAddress);
        }
        short[] addressBytes = new short[4];
        int i = 0;
        while (i < 4) {
            String octet = splitIpAddress[i];
            addressBytes[i] = Short.parseShort(octet);
            ++i;
        }
        return NetworkUtil.packIp4AddressBytes(addressBytes);
    }

    public static int packIp4AddressBytes(short[] bytes) {
        if (bytes == null || bytes.length != 4) {
            throw new IllegalArgumentException("bytes is null or invalid");
        }
        int val = 0;
        int i = 0;
        while (i < 4) {
            if (bytes[i] < 0 || bytes[i] > 255) {
                throw new IllegalArgumentException("bytes is invalid; value is out of range: " + Integer.toString(bytes[i]));
            }
            val <<= 8;
            val |= bytes[i];
            ++i;
        }
        return val;
    }

    public static short[] unpackIP4AddressInt(int address) {
        short[] addressBytes = new short[4];
        int value = address;
        int i = 3;
        while (i >= 0) {
            addressBytes[i] = (short)(value & 0xFF);
            value >>>= 8;
            --i;
        }
        return addressBytes;
    }

    public static byte[] convertIP6Address(String fullFormIP6Address) {
        if (fullFormIP6Address == null) {
            throw new IllegalArgumentException("fullFormIP6Address is null");
        }
        byte[] retVal = new byte[16];
        String[] ip6Split = fullFormIP6Address.split(":");
        if (ip6Split.length != 8) {
            throw new IllegalArgumentException("fullFormIP6Address is invalid: " + fullFormIP6Address);
        }
        int i = 0;
        while (i < 8) {
            try {
                String octet = ip6Split[i];
                int value = Integer.parseInt(octet, 16);
                if (value < 0 || value > 65535) {
                    throw new IllegalArgumentException("fullFormIP6Address is invalid: " + fullFormIP6Address);
                }
                int k = i * 2;
                retVal[k] = (byte)(value >>> 8 & 0xFF);
                retVal[k + 1] = (byte)(value & 0xFF);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("fullFormIP6Address is invalid: " + fullFormIP6Address, e);
            }
            ++i;
        }
        return retVal;
    }

    public static String convertIP6Address(byte[] bytes) {
        if (bytes == null || bytes.length != 16) {
            throw new IllegalArgumentException("bytes is null or invalid");
        }
        CharSequence[] items = new String[8];
        int i = 0;
        while (i < 8) {
            int k = i * 2;
            int value = bytes[k] << 8 & 0xFF00;
            items[i] = Integer.toHexString(value |= bytes[k + 1] & 0xFF);
            ++i;
        }
        return String.join((CharSequence)":", items);
    }

    public static String macToString(byte[] mac) {
        if (mac == null || mac.length != 6) {
            throw new IllegalArgumentException("mac is null or invalid");
        }
        CharSequence[] items = new String[6];
        int i = 0;
        while (i < 6) {
            String octet = Integer.toHexString(mac[i] & 0xFF).toUpperCase();
            if (octet.length() == 1) {
                octet = "0" + octet;
            }
            items[i] = octet;
            ++i;
        }
        return String.join((CharSequence)":", items);
    }

    public static byte[] macToBytes(String mac) {
        if (mac == null) {
            throw new IllegalArgumentException("mac is null");
        }
        String[] items = mac.split("\\:");
        if (items.length != 6) {
            throw new IllegalArgumentException("mac is invalid: " + mac);
        }
        byte[] bytes = new byte[6];
        int i = 0;
        while (i < 6) {
            String item = items[i];
            if (item.isEmpty() || item.length() > 2) {
                throw new IllegalArgumentException("mac is invalid: " + mac);
            }
            try {
                bytes[i] = (byte)Integer.parseInt(items[i], 16);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("mac is invalid: " + mac, e);
            }
            ++i;
        }
        return bytes;
    }
}

