/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.cloud;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eclipse.kura.KuraConnectException;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraInvalidMessageException;
import org.eclipse.kura.certificate.CertificatesService;
import org.eclipse.kura.cloud.CloudClient;
import org.eclipse.kura.cloud.CloudConnectionEstablishedEvent;
import org.eclipse.kura.cloud.CloudConnectionLostEvent;
import org.eclipse.kura.cloud.CloudPayloadEncoding;
import org.eclipse.kura.cloud.CloudPayloadProtoBufDecoder;
import org.eclipse.kura.cloud.CloudPayloadProtoBufEncoder;
import org.eclipse.kura.cloud.CloudService;
import org.eclipse.kura.cloudconnection.CloudConnectionManager;
import org.eclipse.kura.cloudconnection.CloudEndpoint;
import org.eclipse.kura.cloudconnection.listener.CloudConnectionListener;
import org.eclipse.kura.cloudconnection.listener.CloudDeliveryListener;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.publisher.CloudNotificationPublisher;
import org.eclipse.kura.cloudconnection.request.RequestHandler;
import org.eclipse.kura.cloudconnection.request.RequestHandlerRegistry;
import org.eclipse.kura.cloudconnection.subscriber.listener.CloudSubscriberListener;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.core.cloud.CloudClientImpl;
import org.eclipse.kura.core.cloud.CloudPayloadEncoder;
import org.eclipse.kura.core.cloud.CloudPayloadGZipEncoder;
import org.eclipse.kura.core.cloud.CloudPayloadProtoBufDecoderImpl;
import org.eclipse.kura.core.cloud.CloudPayloadProtoBufEncoderImpl;
import org.eclipse.kura.core.cloud.CloudPublisherDeliveryListener;
import org.eclipse.kura.core.cloud.CloudServiceOptions;
import org.eclipse.kura.core.cloud.KuraTopicImpl;
import org.eclipse.kura.core.cloud.LifeCyclePayloadBuilder;
import org.eclipse.kura.core.cloud.MessageHandlerCallable;
import org.eclipse.kura.core.cloud.publisher.NotificationPublisherImpl;
import org.eclipse.kura.core.cloud.subscriber.CloudSubscriptionRecord;
import org.eclipse.kura.core.data.DataServiceImpl;
import org.eclipse.kura.core.message.MessageConstants;
import org.eclipse.kura.data.DataService;
import org.eclipse.kura.data.listener.DataServiceListener;
import org.eclipse.kura.marshalling.Marshaller;
import org.eclipse.kura.marshalling.Unmarshaller;
import org.eclipse.kura.message.KuraApplicationTopic;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.net.NetworkService;
import org.eclipse.kura.net.modem.ModemReadyEvent;
import org.eclipse.kura.position.PositionService;
import org.eclipse.kura.system.SystemAdminService;
import org.eclipse.kura.system.SystemService;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudServiceImpl
implements CloudService,
DataServiceListener,
ConfigurableComponent,
EventHandler,
CloudPayloadProtoBufEncoder,
CloudPayloadProtoBufDecoder,
RequestHandlerRegistry,
CloudConnectionManager,
CloudEndpoint {
    private static final String NOTIFICATION_PUBLISHER_PID = "org.eclipse.kura.cloud.publisher.CloudNotificationPublisher";
    private static final Logger logger = LoggerFactory.getLogger(CloudServiceImpl.class);
    private static final String TOPIC_BA_APP = "BA";
    private static final String TOPIC_MQTT_APP = "MQTT";
    private static final String CONNECTION_EVENT_PID_PROPERTY_KEY = "cloud.service.pid";
    private static final int NUM_CONCURRENT_CALLBACKS = 2;
    private static ExecutorService callbackExecutor = Executors.newFixedThreadPool(2);
    private ComponentContext ctx;
    private CloudServiceOptions options;
    private DataService dataService;
    private SystemService systemService;
    private SystemAdminService systemAdminService;
    private NetworkService networkService;
    private PositionService positionService;
    private EventAdmin eventAdmin;
    private CertificatesService certificatesService;
    private Unmarshaller jsonUnmarshaller;
    private Marshaller jsonMarshaller;
    private final List<CloudClientImpl> cloudClients = new CopyOnWriteArrayList<CloudClientImpl>();
    private final Set<CloudConnectionListener> registeredCloudConnectionListeners;
    private final Set<CloudPublisherDeliveryListener> registeredCloudPublisherDeliveryListeners;
    private final Set<CloudDeliveryListener> registeredCloudDeliveryListeners;
    private final Map<CloudSubscriptionRecord, List<CloudSubscriberListener>> registeredSubscribers;
    String imei;
    String iccid;
    String imsi;
    String rssi;
    private boolean subscribed;
    private boolean birthPublished;
    private final AtomicInteger messageId = new AtomicInteger();
    private ServiceRegistration<?> cloudServiceRegistration;
    private final Map<String, RequestHandler> registeredRequestHandlers = new HashMap<String, RequestHandler>();
    private ServiceRegistration<?> notificationPublisherRegistration;
    private final CloudNotificationPublisher notificationPublisher;

    public CloudServiceImpl() {
        this.registeredSubscribers = new ConcurrentHashMap<CloudSubscriptionRecord, List<CloudSubscriberListener>>();
        this.registeredCloudConnectionListeners = new CopyOnWriteArraySet<CloudConnectionListener>();
        this.registeredCloudPublisherDeliveryListeners = new CopyOnWriteArraySet<CloudPublisherDeliveryListener>();
        this.registeredCloudDeliveryListeners = new CopyOnWriteArraySet<CloudDeliveryListener>();
        this.notificationPublisher = new NotificationPublisherImpl(this);
    }

    public void setDataService(DataService dataService) {
        this.dataService = dataService;
    }

    public void unsetDataService(DataService dataService) {
        this.dataService = null;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public void setSystemAdminService(SystemAdminService systemAdminService) {
        this.systemAdminService = systemAdminService;
    }

    public void unsetSystemAdminService(SystemAdminService systemAdminService) {
        this.systemAdminService = null;
    }

    public SystemAdminService getSystemAdminService() {
        return this.systemAdminService;
    }

    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        this.systemService = null;
    }

    public SystemService getSystemService() {
        return this.systemService;
    }

    public void setNetworkService(NetworkService networkService) {
        this.networkService = networkService;
    }

    public void unsetNetworkService(NetworkService networkService) {
        this.networkService = null;
    }

    public NetworkService getNetworkService() {
        return this.networkService;
    }

    public void setPositionService(PositionService positionService) {
        this.positionService = positionService;
    }

    public void unsetPositionService(PositionService positionService) {
        this.positionService = null;
    }

    public PositionService getPositionService() {
        return this.positionService;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void unsetEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = null;
    }

    public void setJsonUnmarshaller(Unmarshaller jsonUnmarshaller) {
        this.jsonUnmarshaller = jsonUnmarshaller;
    }

    public void unsetJsonUnmarshaller(Unmarshaller jsonUnmarshaller) {
        this.jsonUnmarshaller = null;
    }

    public void setJsonMarshaller(Marshaller jsonMarshaller) {
        this.jsonMarshaller = jsonMarshaller;
    }

    public void unsetJsonMarshaller(Marshaller jsonMarshaller) {
        this.jsonMarshaller = null;
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.info("activate {}...", properties.get("kura.service.pid"));
        this.ctx = componentContext;
        this.options = new CloudServiceOptions(properties, this.systemService);
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        String[] eventTopics = new String[]{"org/eclipse/kura/position/locked", "org/eclipse/kura/net/modem/READY"};
        ((Dictionary)props).put("event.topics", eventTopics);
        this.cloudServiceRegistration = this.ctx.getBundleContext().registerService(EventHandler.class.getName(), (Object)this, props);
        this.dataService.addDataServiceListener((DataServiceListener)this);
        Hashtable<String, String> notificationPublisherProps = new Hashtable<String, String>();
        ((Dictionary)notificationPublisherProps).put("kura.service.pid", NOTIFICATION_PUBLISHER_PID);
        ((Dictionary)notificationPublisherProps).put("service.pid", NOTIFICATION_PUBLISHER_PID);
        this.notificationPublisherRegistration = this.ctx.getBundleContext().registerService(CloudNotificationPublisher.class.getName(), (Object)this.notificationPublisher, notificationPublisherProps);
        if (this.isConnected()) {
            logger.warn("DataService is already connected. Publish BIRTH certificate");
            try {
                this.setupCloudConnection(true);
            }
            catch (KuraException e) {
                logger.warn("Cannot setup cloud service connection", (Throwable)e);
            }
        }
    }

    public void updated(Map<String, Object> properties) {
        logger.info("updated {}...", properties.get("kura.service.pid"));
        this.options = new CloudServiceOptions(properties, this.systemService);
        if (this.isConnected()) {
            try {
                this.setupCloudConnection(false);
            }
            catch (KuraException kuraException) {
                logger.warn("Cannot setup cloud service connection");
            }
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.info("deactivate {}...", componentContext.getProperties().get("kura.service.pid"));
        if (this.isConnected()) {
            try {
                this.publishDisconnectCertificate();
            }
            catch (KuraException kuraException) {
                logger.warn("Cannot publish disconnect certificate");
            }
        }
        this.dataService.removeDataServiceListener((DataServiceListener)this);
        this.cloudClients.clear();
        this.dataService = null;
        this.systemService = null;
        this.systemAdminService = null;
        this.networkService = null;
        this.positionService = null;
        this.eventAdmin = null;
        this.certificatesService = null;
        this.cloudServiceRegistration.unregister();
        this.notificationPublisherRegistration.unregister();
    }

    public void handleEvent(Event event) {
        if ("org/eclipse/kura/position/locked".contains(event.getTopic())) {
            logger.info("Handling PositionLockedEvent");
            if (this.dataService.isConnected() && this.options.getRepubBirthCertOnGpsLock()) {
                try {
                    this.publishBirthCertificate();
                }
                catch (KuraException e) {
                    logger.warn("Cannot publish birth certificate", (Throwable)e);
                }
            }
        } else if ("org/eclipse/kura/net/modem/READY".contains(event.getTopic())) {
            logger.info("Handling ModemReadyEvent");
            ModemReadyEvent modemReadyEvent = (ModemReadyEvent)event;
            this.imei = (String)modemReadyEvent.getProperty("IMEI");
            this.imsi = (String)modemReadyEvent.getProperty("IMSI");
            this.iccid = (String)modemReadyEvent.getProperty("ICCID");
            this.rssi = (String)modemReadyEvent.getProperty("RSSI");
            logger.trace("handleEvent() :: IMEI={}", (Object)this.imei);
            logger.trace("handleEvent() :: IMSI={}", (Object)this.imsi);
            logger.trace("handleEvent() :: ICCID={}", (Object)this.iccid);
            logger.trace("handleEvent() :: RSSI={}", (Object)this.rssi);
            if (this.dataService.isConnected() && this.options.getRepubBirthCertOnModemDetection() && (this.imei != null && this.imei.length() != 0 && !this.imei.equals("ERROR") || this.imsi != null && this.imsi.length() != 0 && !this.imsi.equals("ERROR") || this.iccid != null && this.iccid.length() != 0 && !this.iccid.equals("ERROR"))) {
                logger.debug("handleEvent() :: publishing BIRTH certificate ...");
                try {
                    this.publishBirthCertificate();
                }
                catch (KuraException e) {
                    logger.warn("Cannot publish birth certificate", (Throwable)e);
                }
            }
        }
    }

    public CloudClient newCloudClient(String applicationId) throws KuraException {
        CloudClientImpl cloudClient = new CloudClientImpl(applicationId, this.dataService, this);
        this.cloudClients.add(cloudClient);
        if (this.isConnected()) {
            this.publishAppCertificate();
        }
        return cloudClient;
    }

    public String[] getCloudApplicationIdentifiers() {
        ArrayList<String> appIds = new ArrayList<String>();
        for (CloudClientImpl cloudClientImpl : this.cloudClients) {
            appIds.add(cloudClientImpl.getApplicationId());
        }
        for (Map.Entry entry : this.registeredRequestHandlers.entrySet()) {
            appIds.add((String)entry.getKey());
        }
        return appIds.toArray(new String[0]);
    }

    public boolean isConnected() {
        return this.dataService != null && this.dataService.isConnected();
    }

    public CloudServiceOptions getCloudServiceOptions() {
        return this.options;
    }

    public void removeCloudClient(CloudClientImpl cloudClient) {
        this.cloudClients.remove(cloudClient);
        if (this.isConnected()) {
            try {
                this.publishAppCertificate();
            }
            catch (KuraException kuraException) {
                logger.warn("Cannot publish app certificate");
            }
        }
    }

    public byte[] encodePayload(KuraPayload payload) throws KuraException {
        byte[] bytes;
        CloudPayloadEncoding preferencesEncoding = this.options.getPayloadEncoding();
        if (preferencesEncoding == CloudPayloadEncoding.KURA_PROTOBUF) {
            bytes = this.encodeProtobufPayload(payload);
        } else if (preferencesEncoding == CloudPayloadEncoding.SIMPLE_JSON) {
            bytes = this.encodeJsonPayload(payload);
        } else {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR);
        }
        return bytes;
    }

    public void onConnectionEstablished() {
        try {
            this.setupCloudConnection(true);
        }
        catch (KuraException kuraException) {
            logger.warn("Cannot setup cloud service connection");
        }
        this.registeredSubscribers.keySet().forEach(this::subscribe);
        this.postConnectionStateChangeEvent(true);
        this.cloudClients.forEach(CloudClientImpl::onConnectionEstablished);
        this.registeredCloudConnectionListeners.forEach(CloudConnectionListener::onConnectionEstablished);
    }

    private void setupDeviceSubscriptions(boolean subscribe) throws KuraException {
        StringBuilder sbDeviceSubscription = new StringBuilder();
        sbDeviceSubscription.append(this.options.getTopicControlPrefix()).append(CloudServiceOptions.getTopicSeparator()).append(CloudServiceOptions.getTopicAccountToken()).append(CloudServiceOptions.getTopicSeparator()).append(CloudServiceOptions.getTopicClientIdToken()).append(CloudServiceOptions.getTopicSeparator()).append(CloudServiceOptions.getTopicWildCard());
        if (subscribe) {
            this.dataService.subscribe(sbDeviceSubscription.toString(), 1);
        } else {
            this.dataService.unsubscribe(sbDeviceSubscription.toString());
        }
    }

    public void onDisconnecting() {
        try {
            this.publishDisconnectCertificate();
        }
        catch (KuraException kuraException) {
            logger.warn("Cannot publish disconnect certificate");
        }
        this.birthPublished = false;
    }

    public void onDisconnected() {
        this.postConnectionStateChangeEvent(false);
        this.registeredCloudConnectionListeners.forEach(CloudConnectionListener::onDisconnected);
    }

    public void onConnectionLost(Throwable cause) {
        this.postConnectionStateChangeEvent(false);
        this.cloudClients.forEach(CloudClientImpl::onConnectionLost);
        this.registeredCloudConnectionListeners.forEach(CloudConnectionListener::onConnectionLost);
    }

    public void onMessageArrived(String topic, byte[] payload, int qos, boolean retained) {
        logger.info("Message arrived on topic: {}", (Object)topic);
        KuraTopicImpl kuraTopic = new KuraTopicImpl(topic, this.options.getTopicControlPrefix());
        if (TOPIC_MQTT_APP.equals(kuraTopic.getApplicationId()) || TOPIC_BA_APP.equals(kuraTopic.getApplicationId())) {
            logger.info("Ignoring feedback message from {}", (Object)topic);
        } else {
            KuraPayload kuraPayload = this.encodeKuraPayload(topic, payload);
            try {
                if (this.options.getTopicControlPrefix().equals(kuraTopic.getPrefix())) {
                    boolean validMessage = this.isValidMessage(kuraTopic, kuraPayload);
                    if (validMessage) {
                        this.dispatchControlMessage(qos, retained, kuraTopic, kuraPayload);
                    } else {
                        logger.warn("Message verification failed! Not valid signature or message not signed.");
                    }
                } else {
                    this.dispatchDataMessage(qos, retained, kuraTopic, kuraPayload);
                }
            }
            catch (Exception e) {
                logger.error("Error during CloudClientListener notification.", (Throwable)e);
            }
        }
    }

    private KuraPayload encodeKuraPayload(String topic, byte[] payload) {
        KuraPayload kuraPayload = null;
        if (this.options.getPayloadEncoding() == CloudPayloadEncoding.SIMPLE_JSON) {
            try {
                kuraPayload = this.createKuraPayloadFromJson(payload);
            }
            catch (KuraException e) {
                logger.warn("Error creating Kura Payload from Json", (Throwable)e);
            }
        } else if (this.options.getPayloadEncoding() == CloudPayloadEncoding.KURA_PROTOBUF) {
            kuraPayload = this.createKuraPayloadFromProtoBuf(topic, payload);
        }
        return kuraPayload;
    }

    private void dispatchControlMessage(int qos, boolean retained, KuraTopicImpl kuraTopic, KuraPayload kuraPayload) {
        String applicationId = kuraTopic.getApplicationId();
        RequestHandler cloudlet = this.registeredRequestHandlers.get(applicationId);
        if (cloudlet != null) {
            StringBuilder sb = new StringBuilder(applicationId).append("/").append("REPLY");
            if (kuraTopic.getApplicationTopic().startsWith(sb.toString())) {
                return;
            }
            callbackExecutor.submit(new MessageHandlerCallable(cloudlet, applicationId, kuraTopic.getApplicationTopic(), kuraPayload, this));
        }
        this.cloudClients.stream().filter(cloudClient -> cloudClient.getApplicationId().equals(kuraTopic.getApplicationId())).forEach(cloudClient -> cloudClient.onControlMessageArrived(kuraTopic.getDeviceId(), kuraTopic.getApplicationTopic(), kuraPayload, qos, retained));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("deviceId", kuraTopic.getDeviceId());
        properties.put("appTopic", kuraTopic.getApplicationTopic());
        KuraMessage receivedMessage = new KuraMessage(kuraPayload, properties);
        this.registeredSubscribers.entrySet().stream().filter(cloudSubscriberEntry -> ((CloudSubscriptionRecord)cloudSubscriberEntry.getKey()).matches(kuraTopic.getFullTopic())).forEach(e -> CloudServiceImpl.dispatchMessage(receivedMessage, (List)e.getValue()));
    }

    private void dispatchDataMessage(int qos, boolean retained, KuraTopicImpl kuraTopic, KuraPayload kuraPayload) {
        this.cloudClients.stream().filter(cloudClient -> cloudClient.getApplicationId().equals(kuraTopic.getApplicationId())).forEach(cloudClient -> cloudClient.onMessageArrived(kuraTopic.getDeviceId(), kuraTopic.getApplicationTopic(), kuraPayload, qos, retained));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("deviceId", kuraTopic.getDeviceId());
        properties.put("appTopic", kuraTopic.getApplicationTopic());
        KuraMessage receivedMessage = new KuraMessage(kuraPayload, properties);
        this.registeredSubscribers.entrySet().stream().filter(cloudSubscriberEntry -> ((CloudSubscriptionRecord)cloudSubscriberEntry.getKey()).matches(kuraTopic.getFullTopic())).forEach(e -> CloudServiceImpl.dispatchMessage(receivedMessage, (List)e.getValue()));
    }

    private static void dispatchMessage(KuraMessage message, List<CloudSubscriberListener> listeners) {
        for (CloudSubscriberListener listener : listeners) {
            try {
                listener.onMessageArrived(message);
            }
            catch (Exception e) {
                logger.warn("unhandled exception in CloudSubscriberListener", (Throwable)e);
            }
        }
    }

    private boolean isValidMessage(KuraApplicationTopic kuraTopic, KuraPayload kuraPayload) {
        ServiceReference sr;
        if (this.certificatesService == null && (sr = this.ctx.getBundleContext().getServiceReference(CertificatesService.class)) != null) {
            this.certificatesService = (CertificatesService)this.ctx.getBundleContext().getService(sr);
        }
        boolean validMessage = false;
        if (this.certificatesService == null || this.certificatesService.verifySignature(kuraTopic, kuraPayload)) {
            validMessage = true;
        }
        return validMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessagePublished(int messageId, String topic) {
        AtomicInteger atomicInteger = this.messageId;
        synchronized (atomicInteger) {
            if (this.messageId.get() != -1 && this.messageId.get() == messageId) {
                if (CloudServiceOptions.getLifeCycleMessageQos() == 0) {
                    this.messageId.set(-1);
                }
                this.messageId.notifyAll();
                return;
            }
        }
        KuraTopicImpl kuraTopic = new KuraTopicImpl(topic, this.options.getTopicControlPrefix());
        this.cloudClients.stream().filter(cloudClient -> cloudClient.getApplicationId().equals(kuraTopic.getApplicationId())).collect(Collectors.toList()).forEach(cloudClient -> cloudClient.onMessagePublished(messageId, kuraTopic.getApplicationTopic()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessageConfirmed(int messageId, String topic) {
        AtomicInteger atomicInteger = this.messageId;
        synchronized (atomicInteger) {
            if (this.messageId.get() != -1 && this.messageId.get() == messageId) {
                this.messageId.set(-1);
                this.messageId.notifyAll();
                return;
            }
        }
        KuraTopicImpl kuraTopic = new KuraTopicImpl(topic, this.options.getTopicControlPrefix());
        this.cloudClients.stream().filter(cloudClient -> cloudClient.getApplicationId().equals(kuraTopic.getApplicationId())).collect(Collectors.toList()).forEach(cloudClient -> cloudClient.onMessageConfirmed(messageId, kuraTopic.getApplicationTopic()));
        this.registeredCloudPublisherDeliveryListeners.forEach(deliveryListener -> deliveryListener.onMessageConfirmed(String.valueOf(messageId), topic));
        this.registeredCloudDeliveryListeners.forEach(deliveryListener -> deliveryListener.onMessageConfirmed(String.valueOf(messageId)));
    }

    public byte[] getBytes(KuraPayload kuraPayload, boolean gzipped) throws KuraException {
        CloudPayloadEncoder encoder = new CloudPayloadProtoBufEncoderImpl(kuraPayload);
        if (gzipped) {
            encoder = new CloudPayloadGZipEncoder(encoder);
        }
        try {
            byte[] bytes = encoder.getBytes();
            return bytes;
        }
        catch (IOException e) {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR, (Throwable)e, new Object[0]);
        }
    }

    public KuraPayload buildFromByteArray(byte[] payload) throws KuraException {
        CloudPayloadProtoBufDecoderImpl encoder = new CloudPayloadProtoBufDecoderImpl(payload);
        try {
            KuraPayload kuraPayload = encoder.buildFromByteArray();
            return kuraPayload;
        }
        catch (IOException | KuraInvalidMessageException e) {
            throw new KuraException(KuraErrorCode.DECODER_ERROR, e, new Object[0]);
        }
    }

    private void setupCloudConnection(boolean onConnect) throws KuraException {
        if (onConnect) {
            this.subscribed = false;
        }
        boolean publishBirth = true;
        if (this.birthPublished && !this.options.getRepubBirthCertOnReconnect()) {
            publishBirth = false;
            logger.info("Birth certificate republish is disabled in configuration");
        }
        if (publishBirth) {
            this.publishBirthCertificate();
            this.birthPublished = true;
        }
        if (this.options.getEnableDefaultSubscriptions()) {
            if (!this.subscribed) {
                this.setupDeviceSubscriptions(true);
                this.subscribed = true;
            }
        } else {
            logger.info("Default subscriptions are disabled in configuration");
            if (this.subscribed) {
                this.setupDeviceSubscriptions(false);
                this.subscribed = false;
            }
        }
    }

    private void publishBirthCertificate() throws KuraException {
        if (this.options.isLifecycleCertsDisabled()) {
            return;
        }
        StringBuilder sbTopic = new StringBuilder();
        sbTopic.append(this.options.getTopicControlPrefix()).append(CloudServiceOptions.getTopicSeparator()).append(CloudServiceOptions.getTopicAccountToken()).append(CloudServiceOptions.getTopicSeparator()).append(CloudServiceOptions.getTopicClientIdToken()).append(CloudServiceOptions.getTopicSeparator()).append(CloudServiceOptions.getTopicBirthSuffix());
        String topic = sbTopic.toString();
        KuraPayload payload = this.createBirthPayload();
        this.publishLifeCycleMessage(topic, payload);
    }

    private void publishDisconnectCertificate() throws KuraException {
        if (this.options.isLifecycleCertsDisabled()) {
            return;
        }
        StringBuilder sbTopic = new StringBuilder();
        sbTopic.append(this.options.getTopicControlPrefix()).append(CloudServiceOptions.getTopicSeparator()).append(CloudServiceOptions.getTopicAccountToken()).append(CloudServiceOptions.getTopicSeparator()).append(CloudServiceOptions.getTopicClientIdToken()).append(CloudServiceOptions.getTopicSeparator()).append(CloudServiceOptions.getTopicDisconnectSuffix());
        String topic = sbTopic.toString();
        KuraPayload payload = this.createDisconnectPayload();
        this.publishLifeCycleMessage(topic, payload);
    }

    private void publishAppCertificate() throws KuraException {
        if (this.options.isLifecycleCertsDisabled()) {
            return;
        }
        StringBuilder sbTopic = new StringBuilder();
        sbTopic.append(this.options.getTopicControlPrefix()).append(CloudServiceOptions.getTopicSeparator()).append(CloudServiceOptions.getTopicAccountToken()).append(CloudServiceOptions.getTopicSeparator()).append(CloudServiceOptions.getTopicClientIdToken()).append(CloudServiceOptions.getTopicSeparator()).append(CloudServiceOptions.getTopicAppsSuffix());
        String topic = sbTopic.toString();
        KuraPayload payload = this.createBirthPayload();
        this.publishLifeCycleMessage(topic, payload);
    }

    private KuraPayload createBirthPayload() {
        LifeCyclePayloadBuilder payloadBuilder = new LifeCyclePayloadBuilder(this);
        return payloadBuilder.buildBirthPayload();
    }

    private KuraPayload createDisconnectPayload() {
        LifeCyclePayloadBuilder payloadBuilder = new LifeCyclePayloadBuilder(this);
        return payloadBuilder.buildDisconnectPayload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishLifeCycleMessage(String topic, KuraPayload payload) throws KuraException {
        AtomicInteger atomicInteger = this.messageId;
        synchronized (atomicInteger) {
            this.messageId.set(-1);
            payload.setTimestamp(new Date());
            byte[] encodedPayload = this.encodePayload(payload);
            int messageId = this.dataService.publish(topic, encodedPayload, CloudServiceOptions.getLifeCycleMessageQos(), CloudServiceOptions.getLifeCycleMessageRetain(), CloudServiceOptions.getLifeCycleMessagePriority());
            this.messageId.set(messageId);
            try {
                this.messageId.wait(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.info("Interrupted while waiting for the message to be published", (Throwable)e);
            }
        }
    }

    private byte[] encodeProtobufPayload(KuraPayload payload) throws KuraException {
        byte[] bytes = new byte[]{};
        if (payload == null) {
            return bytes;
        }
        CloudPayloadEncoder encoder = new CloudPayloadProtoBufEncoderImpl(payload);
        if (this.options.getEncodeGzip()) {
            encoder = new CloudPayloadGZipEncoder(encoder);
        }
        try {
            bytes = encoder.getBytes();
        }
        catch (IOException e) {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR, (Throwable)e, new Object[0]);
        }
        return bytes;
    }

    private byte[] encodeJsonPayload(KuraPayload payload) throws KuraException {
        return this.jsonMarshaller.marshal((Object)payload).getBytes(StandardCharsets.UTF_8);
    }

    private KuraPayload createKuraPayloadFromJson(byte[] payload) throws KuraException {
        return (KuraPayload)this.jsonUnmarshaller.unmarshal(new String(payload), KuraPayload.class);
    }

    private KuraPayload createKuraPayloadFromProtoBuf(String topic, byte[] payload) {
        KuraPayload kuraPayload;
        try {
            kuraPayload = new CloudPayloadProtoBufDecoderImpl(payload).buildFromByteArray();
        }
        catch (Exception exception) {
            logger.debug("Received message on topic {} that could not be decoded. Wrapping it into an KuraPayload.", (Object)topic);
            kuraPayload = new KuraPayload();
            kuraPayload.setBody(payload);
        }
        return kuraPayload;
    }

    private void postConnectionStateChangeEvent(boolean isConnected) {
        Map<String, String> eventProperties = Collections.singletonMap(CONNECTION_EVENT_PID_PROPERTY_KEY, (String)this.ctx.getProperties().get("kura.service.pid"));
        CloudConnectionEstablishedEvent event = isConnected ? new CloudConnectionEstablishedEvent(eventProperties) : new CloudConnectionLostEvent(eventProperties);
        this.eventAdmin.postEvent((Event)event);
    }

    public void registerRequestHandler(String appId, RequestHandler requestHandler) {
        this.registeredRequestHandlers.put(appId, requestHandler);
        if (this.isConnected()) {
            try {
                this.publishAppCertificate();
            }
            catch (KuraException kuraException) {
                logger.warn("Unable to publish updated App Certificate");
            }
        }
    }

    public void unregister(String appId) {
        this.registeredRequestHandlers.remove(appId);
        if (this.isConnected()) {
            try {
                this.publishAppCertificate();
            }
            catch (KuraException kuraException) {
                logger.warn("Unable to publish updated App Certificate");
            }
        }
    }

    public void connect() throws KuraConnectException {
        if (this.dataService != null) {
            this.dataService.connect();
        }
    }

    public void disconnect() {
        if (this.dataService != null) {
            this.dataService.disconnect(10L);
        }
    }

    public Map<String, String> getInfo() {
        DataServiceImpl dataServiceImpl = (DataServiceImpl)this.dataService;
        return dataServiceImpl.getConnectionInfo();
    }

    public String getNotificationPublisherPid() {
        return NOTIFICATION_PUBLISHER_PID;
    }

    public CloudNotificationPublisher getNotificationPublisher() {
        return this.notificationPublisher;
    }

    public void registerCloudConnectionListener(CloudConnectionListener cloudConnectionListener) {
        this.registeredCloudConnectionListeners.add(cloudConnectionListener);
    }

    public void unregisterCloudConnectionListener(CloudConnectionListener cloudConnectionListener) {
        this.registeredCloudConnectionListeners.remove(cloudConnectionListener);
    }

    public void registerCloudPublisherDeliveryListener(CloudPublisherDeliveryListener cloudPublisherDeliveryListener) {
        this.registeredCloudPublisherDeliveryListeners.add(cloudPublisherDeliveryListener);
    }

    public void unregisterCloudPublisherDeliveryListener(CloudPublisherDeliveryListener cloudPublisherDeliveryListener) {
        this.registeredCloudPublisherDeliveryListeners.remove(cloudPublisherDeliveryListener);
    }

    public String publish(KuraMessage message) throws KuraException {
        Map messageProps = message.getProperties();
        int qos = (Integer)messageProps.get(MessageConstants.QOS.name());
        boolean retain = (Boolean)messageProps.get(MessageConstants.RETAIN.name());
        int priority = (Integer)messageProps.get(MessageConstants.PRIORITY.name());
        String fullTopic = (String)messageProps.get(MessageConstants.FULL_TOPIC.name());
        if (Objects.isNull(fullTopic)) {
            String appId = (String)messageProps.get(MessageConstants.APP_ID.name());
            String appTopic = (String)messageProps.get(MessageConstants.APP_TOPIC.name());
            boolean isControl = (Boolean)messageProps.get(MessageConstants.CONTROL.name());
            String deviceId = CloudServiceOptions.getTopicClientIdToken();
            fullTopic = this.encodeTopic(appId, deviceId, appTopic, isControl);
        }
        byte[] appPayload = this.encodePayload(message.getPayload());
        int id = this.dataService.publish(fullTopic, appPayload, qos, retain, priority);
        if (qos == 0) {
            return null;
        }
        return String.valueOf(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSubscriber(Map<String, Object> subscriptionProperties, CloudSubscriberListener subscriber) {
        List subscribers;
        String appId = (String)subscriptionProperties.get(MessageConstants.APP_ID.name());
        String appTopic = (String)subscriptionProperties.get(MessageConstants.APP_TOPIC.name());
        int qos = (Integer)subscriptionProperties.get(MessageConstants.QOS.name());
        boolean isControl = (Boolean)subscriptionProperties.get(MessageConstants.CONTROL.name());
        if (Objects.isNull(appId) || Objects.isNull(appTopic)) {
            return;
        }
        String fullTopic = this.encodeTopic(appId, CloudServiceOptions.getTopicClientIdToken(), appTopic, isControl);
        CloudSubscriptionRecord subscriptionRecord = new CloudSubscriptionRecord(fullTopic, qos);
        CloudServiceImpl cloudServiceImpl = this;
        synchronized (cloudServiceImpl) {
            subscribers = this.registeredSubscribers.compute(subscriptionRecord, (t, list) -> {
                if (list == null) {
                    return new CopyOnWriteArrayList<CloudSubscriberListener>(Collections.singletonList(subscriber));
                }
                list.add(subscriber);
                return list;
            });
        }
        if (subscribers.size() == 1) {
            this.subscribe(subscriptionRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSubscriber(CloudSubscriberListener subscriber) {
        ArrayList toUnsubscribe = new ArrayList();
        CloudServiceImpl cloudServiceImpl = this;
        synchronized (cloudServiceImpl) {
            this.registeredSubscribers.entrySet().removeIf(e -> {
                List subscribers = (List)e.getValue();
                subscribers.removeIf(s -> s == subscriber);
                if (subscribers.isEmpty()) {
                    toUnsubscribe.add((CloudSubscriptionRecord)e.getKey());
                    return true;
                }
                return false;
            });
        }
        for (CloudSubscriptionRecord subscription : toUnsubscribe) {
            this.unsubscribe(subscription);
        }
    }

    private synchronized void subscribe(CloudSubscriptionRecord subscriptionRecord) {
        String fullTopic = subscriptionRecord.getTopic();
        int qos = subscriptionRecord.getQos();
        try {
            this.dataService.subscribe(fullTopic, qos);
        }
        catch (KuraException kuraException) {
            logger.info("Failed to subscribe");
        }
    }

    private synchronized void unsubscribe(CloudSubscriptionRecord subscriptionRecord) {
        String fullTopic = subscriptionRecord.getTopic();
        try {
            this.dataService.unsubscribe(fullTopic);
        }
        catch (KuraException kuraException) {
            logger.info("Failed to unsubscribe");
        }
    }

    private String encodeTopic(String appId, String deviceId, String appTopic, boolean isControl) {
        StringBuilder sb = new StringBuilder();
        if (isControl) {
            sb.append(this.options.getTopicControlPrefix()).append(CloudServiceOptions.getTopicSeparator());
        }
        sb.append(CloudServiceOptions.getTopicAccountToken()).append(CloudServiceOptions.getTopicSeparator()).append(deviceId).append(CloudServiceOptions.getTopicSeparator()).append(appId);
        if (appTopic != null && !appTopic.isEmpty()) {
            sb.append(CloudServiceOptions.getTopicSeparator()).append(appTopic);
        }
        return sb.toString();
    }

    public void registerCloudDeliveryListener(CloudDeliveryListener cloudDeliveryListener) {
        this.registeredCloudDeliveryListeners.add(cloudDeliveryListener);
    }

    public void unregisterCloudDeliveryListener(CloudDeliveryListener cloudDeliveryListener) {
        this.registeredCloudDeliveryListeners.remove(cloudDeliveryListener);
    }
}

