/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag;

import com.bugsnag.DateUtils;
import com.bugsnag.serialization.Expose;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;

final class SessionCount {
    private final String startedAt;
    private final AtomicLong sessionsStarted = new AtomicLong();
    private final Date roundedDate;

    SessionCount(Date startedAt) {
        this.roundedDate = DateUtils.roundTimeToLatestMinute(startedAt);
        this.startedAt = DateUtils.toIso8601(this.roundedDate);
    }

    void incrementSessionsStarted() {
        this.sessionsStarted.incrementAndGet();
    }

    @Expose
    String getStartedAt() {
        return this.startedAt;
    }

    @Expose
    long getSessionsStarted() {
        return this.sessionsStarted.get();
    }

    Date getRoundedDate() {
        return this.roundedDate;
    }
}

