/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.sasl;

import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Base64;
import org.apache.qpid.jms.sasl.AbstractMechanism;
import org.apache.qpid.jms.sasl.Mechanism;

public class XOauth2Mechanism
extends AbstractMechanism {
    private String additionalFailureInformation;

    @Override
    public int getPriority() {
        return Mechanism.PRIORITY.LOWER_STILL.getValue();
    }

    @Override
    public String getName() {
        return "XOAUTH2";
    }

    @Override
    public byte[] getInitialResponse() {
        String username = this.getUsername();
        String password = this.getPassword();
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        byte[] usernameBytes = username.getBytes(StandardCharsets.UTF_8);
        byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] data = new byte[usernameBytes.length + passwordBytes.length + 20];
        System.arraycopy("user=".getBytes(StandardCharsets.US_ASCII), 0, data, 0, 5);
        System.arraycopy(usernameBytes, 0, data, 5, usernameBytes.length);
        data[5 + usernameBytes.length] = 1;
        System.arraycopy("auth=Bearer ".getBytes(StandardCharsets.US_ASCII), 0, data, 6 + usernameBytes.length, 12);
        System.arraycopy(passwordBytes, 0, data, 18 + usernameBytes.length, passwordBytes.length);
        data[data.length - 2] = 1;
        data[data.length - 1] = 1;
        return data;
    }

    @Override
    public byte[] getChallengeResponse(byte[] challenge) {
        if (challenge != null && challenge.length > 0 && this.additionalFailureInformation == null) {
            this.additionalFailureInformation = new String(challenge, StandardCharsets.UTF_8);
        }
        return EMPTY;
    }

    @Override
    public boolean isApplicable(String username, String password, Principal localPrincipal) {
        if (username != null && username.length() > 0 && password != null && password.length() > 0) {
            try {
                Base64.getDecoder().decode(password);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getAdditionalFailureInformation() {
        return this.additionalFailureInformation;
    }
}

