/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.provider.security.impl;

import com.eclipsesource.jaxrs.provider.security.AuthenticationHandler;
import com.eclipsesource.jaxrs.provider.security.AuthorizationHandler;
import com.eclipsesource.jaxrs.provider.security.impl.Activator;
import com.eclipsesource.jaxrs.provider.security.impl.SecurityContextImpl;
import java.security.Principal;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.SecurityContext;

public class SecurityAdmin {
    public SecurityContext getSecurityContext(ContainerRequestContext requestContext) {
        SecurityContext result = null;
        AuthenticationHandler authenticationHandler = Activator.getInstance().getAuthenticationHandler();
        AuthorizationHandler authorizationHandler = Activator.getInstance().getAuthorizationHandler();
        if (authenticationHandler != null && authorizationHandler != null) {
            result = this.createSecurityContext(requestContext, authenticationHandler, authorizationHandler);
        }
        return result;
    }

    private SecurityContext createSecurityContext(ContainerRequestContext requestContext, AuthenticationHandler authenticationHandler, AuthorizationHandler authorizationHandler) {
        Principal principal = authenticationHandler.authenticate(requestContext);
        if (principal != null) {
            return new SecurityContextImpl(authenticationHandler.getAuthenticationScheme(), principal, requestContext.getUriInfo().getRequestUri().getScheme().equals("https"), authorizationHandler);
        }
        return null;
    }
}

