/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.KuraErrorCode;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class KuraRuntimeException
extends RuntimeException {
    private static final String KURA_EXCEPTION_MESSAGES_BUNDLE = "org.eclipse.kura.core.messages.KuraExceptionMessagesBundle";
    private static final String KURA_GENERIC_MESSAGES_PATTERN = "Generic Error - {0}: {1}";
    private static final Logger logger = LogManager.getLogger(KuraRuntimeException.class);
    private static final long serialVersionUID = -7202805328805688329L;
    private Object[] arguments;
    private final KuraErrorCode code;

    public KuraRuntimeException(KuraErrorCode code) {
        this.code = code;
    }

    public KuraRuntimeException(KuraErrorCode code, Object ... arguments) {
        this.code = code;
        this.arguments = arguments;
    }

    public KuraRuntimeException(KuraErrorCode code, Throwable cause, Object ... arguments) {
        super(cause);
        this.code = code;
        this.arguments = arguments;
    }

    public KuraErrorCode getCode() {
        return this.code;
    }

    @Override
    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    private String getLocalizedMessage(Locale locale) {
        String pattern = this.getMessagePattern(locale, this.code);
        if ((this.code == null || KuraErrorCode.INTERNAL_ERROR.equals((Object)this.code)) && this.arguments != null && this.arguments.length > 1) {
            StringBuilder sbAllArgs = new StringBuilder();
            Object[] objectArray = this.arguments;
            int n = this.arguments.length;
            int n2 = 0;
            while (n2 < n) {
                Object arg = objectArray[n2];
                sbAllArgs.append(" - ");
                sbAllArgs.append(arg);
                ++n2;
            }
            this.arguments = new Object[]{sbAllArgs.toString()};
        }
        return MessageFormat.format(pattern, this.arguments);
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage(Locale.US);
    }

    private String getMessagePattern(Locale locale, KuraErrorCode code) {
        String messagePattern = null;
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(KURA_EXCEPTION_MESSAGES_BUNDLE, locale);
            if (resourceBundle != null && code != null && (messagePattern = resourceBundle.getString(code.name())) == null) {
                logger.warn("Could not find Exception Messages for Locale {} and code {}", (Object)locale, (Object)code);
            }
        }
        catch (MissingResourceException missingResourceException) {
            logger.warn("Could not load Exception Messages Bundle for Locale {}", (Object)locale);
        }
        if (messagePattern == null) {
            messagePattern = code != null ? MessageFormat.format(KURA_GENERIC_MESSAGES_PATTERN, code.name()) : MessageFormat.format(KURA_GENERIC_MESSAGES_PATTERN, "Unknown");
        }
        return messagePattern;
    }
}

