/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.util;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.eclipse.kura.web.client.util.HelpPanel;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.DeviceSize;

public class HelpButton
extends Composite {
    @UiField
    Button helpButton;
    private String helpText;
    private HelpTextProvider helpTextProvider;
    private static HelpButtonUiBinder uiBinder = (HelpButtonUiBinder)GWT.create(HelpButtonUiBinder.class);

    public HelpButton() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.helpButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (HelpButton.this.helpTextProvider != null) {
                    HelpPanel.show(HelpButton.this.helpTextProvider.getHelpText());
                } else {
                    HelpPanel.show(HelpButton.this.helpText);
                }
            }
        });
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public void setHelpTextProvider(HelpTextProvider provider) {
        this.helpTextProvider = provider;
    }

    public void updateHelpText() {
        if (this.helpTextProvider != null) {
            HelpPanel.setHelpText(this.helpTextProvider.getHelpText());
        } else {
            HelpPanel.setHelpText(this.helpText);
        }
    }

    public void setVisibleOn(DeviceSize deviceSize) {
        this.helpButton.setVisibleOn(deviceSize);
    }

    static interface HelpButtonUiBinder
    extends UiBinder<Widget, HelpButton> {
    }

    public static interface HelpTextProvider {
        public String getHelpText();
    }
}

