/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.db;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.kura.KuraStoreException;
import org.eclipse.kura.type.BooleanValue;
import org.eclipse.kura.type.ByteArrayValue;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.DoubleValue;
import org.eclipse.kura.type.FloatValue;
import org.eclipse.kura.type.IntegerValue;
import org.eclipse.kura.type.LongValue;
import org.eclipse.kura.type.StringValue;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.util.jdbc.ConnectionProvider;
import org.eclipse.kura.util.wire.store.AbstractJdbcWireRecordStoreImpl;
import org.eclipse.kura.util.wire.store.JdbcWireRecordStoreQueries;

public class H2DbWireRecordStoreImpl
extends AbstractJdbcWireRecordStoreImpl {
    private static final Map<Class<? extends TypedValue<?>>, String> TYPE_MAPPING = H2DbWireRecordStoreImpl.buildTypeMapping();

    public H2DbWireRecordStoreImpl(ConnectionProvider provider, String tableName) throws KuraStoreException {
        super(provider, tableName);
        super.createTable();
        super.createTimestampIndex();
    }

    protected JdbcWireRecordStoreQueries buildSqlWireRecordStoreQueries() {
        return JdbcWireRecordStoreQueries.builder().withSqlAddColumn("ALTER TABLE " + this.escapedTableName + " ADD COLUMN {0} {1};").withSqlCreateTable("CREATE TABLE IF NOT EXISTS " + this.escapedTableName + " (ID BIGINT GENERATED BY DEFAULT " + "AS IDENTITY(START WITH 1 INCREMENT BY 1) PRIMARY KEY, TIMESTAMP BIGINT);").withSqlRowCount("SELECT COUNT(*) FROM " + this.escapedTableName + ";").withSqlDeleteRangeTable("DELETE FROM " + this.escapedTableName + " WHERE ID IN (SELECT ID FROM " + this.escapedTableName + " ORDER BY ID ASC LIMIT {0});").withSqlDropColumn("ALTER TABLE " + this.escapedTableName + " DROP COLUMN {0};").withSqlInsertRecord("INSERT INTO " + this.escapedTableName + " ({0}) VALUES ({1});").withSqlTruncateTable("TRUNCATE TABLE " + this.escapedTableName + ";").withSqlCreateTimestampIndex("CREATE INDEX IF NOT EXISTS " + super.escapeIdentifier(String.valueOf(this.tableName) + "_TIMESTAMP") + " ON " + this.escapedTableName + " (TIMESTAMP DESC);").build();
    }

    protected Optional<String> getMappedSqlType(TypedValue<?> value) {
        return Optional.ofNullable(value).flatMap(v -> Optional.ofNullable(TYPE_MAPPING.get(v.getClass())));
    }

    private static Map<Class<? extends TypedValue<?>>, String> buildTypeMapping() {
        HashMap<Class<ByteArrayValue>, String> result = new HashMap<Class<ByteArrayValue>, String>();
        result.put(StringValue.class, "VARCHAR(102400)");
        result.put(IntegerValue.class, "INTEGER");
        result.put(LongValue.class, "BIGINT");
        result.put(BooleanValue.class, "BOOLEAN");
        result.put(DoubleValue.class, "DOUBLE");
        result.put(FloatValue.class, "FLOAT");
        result.put(ByteArrayValue.class, "BLOB");
        return Collections.unmodifiableMap(result);
    }

    protected boolean isCorrectColumnType(TypedValue<?> value, String mappedType, String actualType) {
        boolean mappedTypeEquals = Objects.equals(mappedType, actualType);
        if (mappedTypeEquals) {
            return true;
        }
        DataType dataType = value.getType();
        if (dataType == DataType.DOUBLE || dataType == DataType.FLOAT) {
            return "DOUBLE PRECISION".equals(actualType) || actualType.startsWith("FLOAT");
        }
        if (dataType == DataType.STRING) {
            return actualType.startsWith("CHARACTER VARYING");
        }
        if (dataType == DataType.BYTE_ARRAY) {
            return "BINARY LARGE OBJECT".equals(actualType);
        }
        return false;
    }
}

