/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.security.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.internal.rest.security.provider.AbstractRestSecurityService;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="security/v2")
public class SecurityRestServiceV2
extends AbstractRestSecurityService {
    private static final Logger logger = LoggerFactory.getLogger(SecurityRestServiceV2.class);
    private static final String MQTT_APP_ID = "SEC-V2";

    @Override
    public String getMqttAppId() {
        return MQTT_APP_ID;
    }

    @POST
    @RolesAllowed(value={"security"})
    @Path(value="/security-policy/apply-default-production")
    public Response applyDefaultProductionSecurityPolicy() {
        try {
            logger.debug("Processing request for method '{}'", (Object)"applyDefaultProductionSecurityPolicy");
            this.security.applyDefaultProductionSecurityPolicy();
            this.security.reloadSecurityPolicyFingerprint();
            this.security.reloadCommandLineFingerprint();
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        return Response.ok().build();
    }

    @POST
    @RolesAllowed(value={"security"})
    @Path(value="/security-policy/apply")
    public Response applySecurityPolicy(InputStream securityPolicyInputStream) {
        try {
            logger.debug("Processing request for method '{}'", (Object)"applySecurityPolicy");
            this.security.applySecurityPolicy(this.readSecurityPolicyString(securityPolicyInputStream));
            this.security.reloadSecurityPolicyFingerprint();
            this.security.reloadCommandLineFingerprint();
        }
        catch (KuraException e) {
            if (KuraErrorCode.INVALID_PARAMETER.equals((Object)e.getCode())) {
                throw DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.BAD_REQUEST, (String)e.getMessage());
            }
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
        return Response.ok().build();
    }

    private String readSecurityPolicyString(InputStream securityPolicyInputStream) {
        if (securityPolicyInputStream == null) {
            throw DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.BAD_REQUEST, (String)"Security Policy cannot be null or empty");
        }
        int totalBytesRead = 0;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        try {
            int bytesRead;
            while ((bytesRead = securityPolicyInputStream.read(data, 0, data.length)) != -1) {
                if ((totalBytesRead += bytesRead) > 0x100000) {
                    throw DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.BAD_REQUEST, (String)"Security policy too large");
                }
                buffer.write(data, 0, bytesRead);
            }
            buffer.flush();
        }
        catch (IOException e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        if (buffer.size() == 0) {
            throw DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.BAD_REQUEST, (String)"Security Policy cannot be null or empty");
        }
        CharBuffer charBuffer = SecurityRestServiceV2.getCharBuffer(buffer);
        return charBuffer.toString();
    }

    private static CharBuffer getCharBuffer(ByteArrayOutputStream buffer) {
        CharBuffer charBuffer;
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT);
        try {
            charBuffer = decoder.decode(ByteBuffer.wrap(buffer.toByteArray()));
        }
        catch (CharacterCodingException characterCodingException) {
            throw DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.BAD_REQUEST, (String)"Security Policy must be UTF-8 encoded");
        }
        return charBuffer;
    }
}

