/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.security;

import io.moquette.broker.config.IResourceLoader;
import io.moquette.broker.security.IAuthenticator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceAuthenticator
implements IAuthenticator {
    protected static final Logger LOG = LoggerFactory.getLogger(ResourceAuthenticator.class);
    private Map<String, String> m_identities = new HashMap<String, String>();

    public ResourceAuthenticator(IResourceLoader resourceLoader, String resourceName) {
        try {
            MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException nsaex) {
            LOG.error("Can't find SHA-256 for password encoding", nsaex);
            throw new RuntimeException(nsaex);
        }
        LOG.info(String.format("Loading password %s %s", resourceLoader.getName(), resourceName));
        Reader reader = null;
        try {
            reader = resourceLoader.loadResource(resourceName);
            if (reader == null) {
                LOG.warn(String.format("Parsing not existing %s %s", resourceLoader.getName(), resourceName));
            } else {
                this.parse(reader);
            }
        }
        catch (IResourceLoader.ResourceIsDirectoryException e) {
            LOG.warn(String.format("Trying to parse directory %s", resourceName));
        }
        catch (ParseException pex) {
            LOG.warn(String.format("Format error in parsing password %s %s", resourceLoader.getName(), resourceName), pex);
        }
    }

    private void parse(Reader reader) throws ParseException {
        if (reader == null) {
            return;
        }
        BufferedReader br = new BufferedReader(reader);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                int commentMarker = line.indexOf(35);
                if (commentMarker != -1) {
                    if (commentMarker == 0) continue;
                    throw new ParseException(line, commentMarker);
                }
                if (line.isEmpty() || line.matches("^\\s*$")) continue;
                int delimiterIdx = line.indexOf(58);
                String username = line.substring(0, delimiterIdx).trim();
                String password = line.substring(delimiterIdx + 1).trim();
                this.m_identities.put(username, password);
            }
        }
        catch (IOException ex) {
            throw new ParseException("Failed to read", 1);
        }
    }

    @Override
    public boolean checkValid(String clientId, String username, byte[] password) {
        if (username == null || password == null) {
            LOG.info("username or password was null");
            return false;
        }
        String foundPwq = this.m_identities.get(username);
        if (foundPwq == null) {
            return false;
        }
        String encodedPasswd = DigestUtils.sha256Hex(password);
        return foundPwq.equals(encodedPasswd);
    }
}

