/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.cloud.factory.internal;

import java.util.Map;
import org.eclipse.kura.camel.cloud.factory.internal.ServiceConfiguration;
import org.eclipse.kura.camel.cloud.factory.internal.XmlCamelCloudService;
import org.eclipse.kura.camel.component.Configuration;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelFactory
implements ConfigurableComponent {
    private static final Logger logger = LoggerFactory.getLogger(CamelFactory.class);
    public static final String FACTORY_ID = "org.eclipse.kura.camel.cloud.factory.CamelFactory";
    private XmlCamelCloudService service;
    private ServiceConfiguration configuration;

    public void activate(Map<String, Object> properties) throws Exception {
        this.setFromProperties(properties);
    }

    public void modified(Map<String, Object> properties) throws Exception {
        this.setFromProperties(properties);
    }

    private void setFromProperties(Map<String, Object> properties) throws Exception {
        String pid = Configuration.asString(properties, (String)"cloud.service.pid");
        ServiceConfiguration serviceConfiguration = new ServiceConfiguration();
        serviceConfiguration.setXml(Configuration.asString(properties, (String)"xml"));
        serviceConfiguration.setInitCode(Configuration.asString(properties, (String)"initCode"));
        serviceConfiguration.setEnableJmx(Configuration.asBoolean(properties, (String)"enableJmx", (boolean)true));
        this.createService(pid, serviceConfiguration);
    }

    public void deactivate() {
        if (this.service != null) {
            try {
                this.service.stop();
            }
            catch (Exception e) {
                logger.warn("Failed to stop", (Throwable)e);
            }
            this.service = null;
        }
    }

    private void createService(String pid, ServiceConfiguration configuration) throws Exception {
        if (pid == null) {
            return;
        }
        if (this.configuration == configuration) {
            return;
        }
        if (this.configuration != null && this.configuration.equals(configuration)) {
            return;
        }
        if (this.service != null) {
            this.service.stop();
            this.service = null;
        }
        if (configuration.isValid()) {
            this.service = new XmlCamelCloudService(FrameworkUtil.getBundle(CamelFactory.class).getBundleContext(), pid, configuration);
            this.service.start();
        }
        this.configuration = configuration;
    }
}

