/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lemminx.MockXMLLanguageServer;
import org.eclipse.lemminx.XMLLanguageServer;
import org.eclipse.lemminx.extensions.contentmodel.BaseFileTempTest;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.TextDocumentItem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class XMLExternalTest
extends BaseFileTempTest {
    private int threadSleepMs = 600;
    private MockXMLLanguageServer languageServer;

    @BeforeEach
    public void before() {
        this.languageServer = new MockXMLLanguageServer();
    }

    @Test
    public void externalDTDTest() throws InterruptedException, IOException {
        String dtdPath = this.getTempDirPath().toString() + "/note.dtd";
        String dtdContents = "<!ELEMENT note (to,from,heading,body)>\n<!ELEMENT to (#PCDATA)>\n<!ELEMENT from (#PCDATA)>\n<!ELEMENT heading (#PCDATA)>\n<!ELEMENT body (#PCDATA)>";
        String xmlContents = "<?xml version=\"1.0\"?>\n<!DOCTYPE note SYSTEM \"note.dtd\">\n<note>\n  <to>Tove</to>\n  <from>Jani</from>\n  <heading>Reminder</heading>\n  <body>Don't forget me this weekend!</body>\n</note>";
        TextDocumentItem xmlTextDocument = this.getXMLTextDocumentItem("test.xml", xmlContents);
        XMLExternalTest.createFile(dtdPath, dtdContents);
        File testDtd = new File(dtdPath);
        this.clientOpenFile(this.languageServer, xmlTextDocument);
        Thread.sleep(this.threadSleepMs);
        List<PublishDiagnosticsParams> actualDiagnostics = this.languageServer.getPublishDiagnostics();
        Assertions.assertEquals((int)1, (int)actualDiagnostics.size());
        Assertions.assertEquals((int)0, (int)actualDiagnostics.get(0).getDiagnostics().size());
        this.editFile(testDtd, 2, "");
        this.didChangedWatchedFiles(this.languageServer, testDtd);
        Thread.sleep(this.threadSleepMs);
        Assertions.assertEquals((int)2, (int)actualDiagnostics.size());
        Assertions.assertFalse((boolean)actualDiagnostics.get(1).getDiagnostics().isEmpty());
        Assertions.assertEquals((Object)"MSG_ELEMENT_NOT_DECLARED", (Object)((Diagnostic)actualDiagnostics.get(1).getDiagnostics().get(0)).getCode().getLeft());
    }

    @Test
    public void externalXSDTest() throws InterruptedException, IOException {
        String xsdPath = this.getTempDirPath().toString() + "/sequence.xsd";
        String xsdContents = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<xs:schema\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n    elementFormDefault=\"qualified\">\n  <xs:element name=\"root\">\n    <xs:complexType>\n      <xs:sequence>\n        <xs:element name=\"tag\"/>\n        <xs:element\n            name=\"optional\"\n            minOccurs=\"0\"\n            maxOccurs=\"3\"/>\n      </xs:sequence>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>";
        String xmlContents = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<root xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"sequence.xsd\">\n  <tag></tag>\n  <optional></optional>\n  <optional></optional>\n  <optional></optional>\n</root>";
        TextDocumentItem xmlTextDocument = this.getXMLTextDocumentItem("test.xml", xmlContents);
        XMLExternalTest.createFile(xsdPath, xsdContents);
        File testXsd = new File(xsdPath);
        this.clientOpenFile(this.languageServer, xmlTextDocument);
        Thread.sleep(this.threadSleepMs);
        List<PublishDiagnosticsParams> actualDiagnostics = this.languageServer.getPublishDiagnostics();
        Assertions.assertEquals((int)1, (int)actualDiagnostics.size());
        Assertions.assertEquals((int)0, (int)actualDiagnostics.get(0).getDiagnostics().size());
        this.editFile(testXsd, 12, "            maxOccurs=\"2\"/>");
        this.didChangedWatchedFiles(this.languageServer, testXsd);
        Thread.sleep(this.threadSleepMs);
        Assertions.assertEquals((int)2, (int)actualDiagnostics.size());
        Assertions.assertEquals((Object)"cvc-complex-type.2.4.f", (Object)((Diagnostic)actualDiagnostics.get(1).getDiagnostics().get(0)).getCode().getLeft());
    }

    private TextDocumentItem getXMLTextDocumentItem(String filename, String xmlContents) {
        String languageId = "xml";
        int version = 1;
        return new TextDocumentItem(this.getTempDirPath().toString().replace('\\', '/') + "/" + filename, languageId, version, xmlContents);
    }

    private void clientOpenFile(XMLLanguageServer languageServer, TextDocumentItem textDocumentItem) {
        DidOpenTextDocumentParams params = new DidOpenTextDocumentParams(textDocumentItem);
        languageServer.getTextDocumentService().didOpen(params);
    }

    private void editFile(File file, int lineNumber, String newContent) throws IOException {
        List<String> lines = Files.readAllLines(file.toPath());
        lines.set(lineNumber - 1, newContent);
        Files.write(file.toPath(), lines, new OpenOption[0]);
    }

    private void didChangedWatchedFiles(XMLLanguageServer ls, File file) {
        ArrayList<FileEvent> changes = new ArrayList<FileEvent>();
        changes.add(new FileEvent(file.toURI().toString(), FileChangeType.Changed));
        DidChangeWatchedFilesParams params = new DidChangeWatchedFilesParams(changes);
        ls.getWorkspaceService().didChangeWatchedFiles(params);
    }
}

