/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rdt.proxy;

import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.rdt.proxy.Activator;
import org.eclipse.linuxtools.internal.rdt.proxy.RDTProxyManager;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteResource;

public class RDTFileProxy
implements IRemoteFileProxy {
    private IProject project;
    private IRemoteFileService manager;
    private IRemoteResource remoteRes;

    private void initialize(URI uri) throws CoreException {
        IRemoteConnection connection = RDTProxyManager.getConnection(uri);
        if (connection == null) {
            throw new CoreException(Status.error((String)Activator.getResourceString("Connection.error")));
        }
        this.manager = (IRemoteFileService)connection.getService(IRemoteFileService.class);
    }

    public RDTFileProxy(URI uri) throws CoreException {
        this.initialize(uri);
    }

    public RDTFileProxy(IProject project) throws CoreException {
        this.project = project;
        URI uri = project.getLocationURI();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = workspaceRoot.findMember(project.getName());
        if (resource != null) {
            this.remoteRes = (IRemoteResource)resource.getAdapter(IRemoteResource.class);
            if (project.hasNature("org.eclipse.ptp.rdt.sync.core.remoteSyncNature")) {
                uri = this.remoteRes.getActiveLocationURI();
            }
        }
        this.initialize(uri);
    }

    public URI toURI(IPath path) {
        return this.manager.toURI(path);
    }

    public URI toURI(String path) {
        return this.manager.toURI(path);
    }

    public String toPath(URI uri) {
        return this.manager.toPath(uri);
    }

    public String getDirectorySeparator() {
        return this.manager.getDirectorySeparator();
    }

    public IFileStore getResource(String path) {
        return this.manager.getResource(path);
    }

    public URI getWorkingDir() {
        try {
            if (this.project.hasNature("org.eclipse.ptp.rdt.sync.core.remoteSyncNature")) {
                return this.remoteRes.getActiveLocationURI();
            }
        }
        catch (CoreException e) {
            return this.project.getLocationURI();
        }
        return this.project.getLocationURI();
    }
}

