/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.api.algorithm;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.lsat.common.ludus.api.MaxPlusException;
import org.eclipse.lsat.common.ludus.api.MinimumMakespanResult;
import org.eclipse.lsat.common.ludus.api.algorithm.MaxPlusAlgorithm;
import org.eclipse.lsat.common.ludus.backend.algebra.Matrix;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.algorithms.CycleCheck;
import org.eclipse.lsat.common.ludus.backend.algorithms.Dijkstra;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;
import org.eclipse.lsat.common.ludus.backend.fsm.FSM;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Edge;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Location;
import org.eclipse.lsat.common.ludus.backend.statespace.ComputeStateSpace;
import org.eclipse.lsat.common.ludus.backend.statespace.MaxPlusStateSpace;
import org.eclipse.lsat.common.ludus.backend.statespace.Transition;
import org.eclipse.lsat.common.mpt.api.UnconnectedResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinimumMakespanAlgorithm
extends MaxPlusAlgorithm {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinimumMakespanAlgorithm.class);

    public static MinimumMakespanResult run(FSM<Location, Edge> fsm, Map<String, Matrix> matrixMap) throws MaxPlusException, UnconnectedResourceException {
        if (CycleCheck.check(fsm)) {
            throw new MaxPlusException("Cannot compute the minimum makespan. Input CIF file contains a cycle.");
        }
        Matrix matrixFirst = matrixMap.values().iterator().next();
        for (Matrix m : matrixMap.values()) {
            if (matrixFirst.getRows() == m.getRows()) continue;
            throw new MaxPlusException("Cannot compute the minimum makespan. Matrices differ in size.");
        }
        long startTime = System.currentTimeMillis();
        MaxPlusStateSpace stateSpace = ComputeStateSpace.computeMaxPlusStateSpace(fsm, matrixFirst.getRows(), matrixMap);
        long endTime = System.currentTimeMillis();
        LOGGER.info("Max-plus state space constructed: " + stateSpace.getVertices().size() + " states and " + stateSpace.getEdges().size() + " edges. Generation took " + (endTime - startTime) + " ms.");
        startTime = System.currentTimeMillis();
        Tuple<Value, List<Transition>> result = Dijkstra.runDijkstra(stateSpace, stateSpace.getInitialConfiguration());
        endTime = System.currentTimeMillis();
        LOGGER.info("Minimum makespan computed using Dijkstra's algorithm in " + (endTime - startTime) + " ms.");
        List<String> listOfEventNames = result.getRight().stream().map(Transition::getEvent).collect(Collectors.toList());
        return new MinimumMakespanResult(result.getLeft().toDouble(), listOfEventNames);
    }
}

