/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.motioncalculator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsat.motioncalculator.MotionSetPoint;

public final class MotionSegment
implements Serializable {
    private static final long serialVersionUID = 4929045032161274589L;
    private final List<MotionSetPoint> setPoints = new ArrayList<MotionSetPoint>();
    private final String id;

    public MotionSegment(String id) {
        this.id = id;
    }

    public void addMotionSetpoint(MotionSetPoint motionSetPoint) {
        if (this.setPoints.stream().anyMatch(m -> m.getId().equals(motionSetPoint.getId()))) {
            throw new IllegalArgumentException("Motion already added for setpoint: " + motionSetPoint.getId());
        }
        this.setPoints.add(motionSetPoint);
    }

    public Collection<MotionSetPoint> getMotionSetpoints() {
        return Collections.unmodifiableCollection(this.setPoints);
    }

    public MotionSetPoint getMotionSetpoint(String id) {
        return this.setPoints.stream().filter(s -> s.getId().equals(id)).findFirst().orElse(null);
    }

    public String toString() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }
}

