/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.core.ls;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCompletionParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCompletionResult;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsSettings;
import org.eclipse.lsp4jakarta.commons.JakartaJavaFileInfo;
import org.eclipse.lsp4jakarta.commons.JakartaJavaFileInfoParams;
import org.eclipse.lsp4jakarta.commons.JavaCursorContextResult;
import org.eclipse.lsp4jakarta.commons.codeaction.CodeActionResolveData;
import org.eclipse.lsp4jakarta.commons.utils.JSONUtility;
import org.eclipse.lsp4jakarta.jdt.core.PropertiesManagerForJava;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.AbstractJakartaDelegateCommandHandler;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.ArgumentUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;

public class JakartaDelegateCommandHandlerForJava
extends AbstractJakartaDelegateCommandHandler {
    private static final String FILE_INFO_COMMAND_ID = "jakarta/java/fileInfo";
    private static final String JAVA_CODEACTION_COMMAND_ID = "jakarta/java/codeAction";
    private static final String JAVA_CODEACTION_RESOLVE_COMMAND_ID = "jakarta/java/codeActionResolve";
    private static final String JAVA_COMPLETION_COMMAND_ID = "jakarta/java/completion";
    private static final String JAVA_DIAGNOSTICS_COMMAND_ID = "jakarta/java/diagnostics";

    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor monitor) throws Exception {
        JavaLanguageServerPlugin.logInfo((String)String.format("Executing command '%s' in LSP4Jakarta JDT LS extension", commandId));
        switch (commandId) {
            case "jakarta/java/fileInfo": {
                return JakartaDelegateCommandHandlerForJava.getFileInfo(arguments, commandId);
            }
            case "jakarta/java/codeAction": {
                return JakartaDelegateCommandHandlerForJava.getCodeActionForJava(arguments, commandId, monitor);
            }
            case "jakarta/java/codeActionResolve": {
                return JakartaDelegateCommandHandlerForJava.resolveCodeActionForJava(arguments, commandId, monitor);
            }
            case "jakarta/java/completion": {
                return JakartaDelegateCommandHandlerForJava.getCompletionForJava(arguments, commandId, monitor);
            }
            case "jakarta/java/diagnostics": {
                return JakartaDelegateCommandHandlerForJava.getDiagnosticsForJava(arguments, commandId, monitor);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported command '%s'!", commandId));
    }

    private static JakartaJavaFileInfo getFileInfo(List<Object> arguments, String commandId) throws JavaModelException, CoreException {
        JakartaJavaFileInfoParams params = JakartaDelegateCommandHandlerForJava.createJavaFileInfoParams(arguments, commandId);
        return PropertiesManagerForJava.getInstance().fileInfo(params, JDTUtilsLSImpl.getInstance());
    }

    private static JakartaJavaFileInfoParams createJavaFileInfoParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one JakartaJavaFileInfoParams argument!", commandId));
        }
        String javaFileUri = ArgumentUtils.getString(obj, "uri");
        if (javaFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required JakartaJavaFileInfoParams.uri (java file URI)!", commandId));
        }
        JakartaJavaFileInfoParams params = new JakartaJavaFileInfoParams();
        params.setUri(javaFileUri);
        return params;
    }

    private static JakartaJavaCompletionResult getCompletionForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        JakartaJavaCompletionParams params = JakartaDelegateCommandHandlerForJava.createJakartaJavaCompletionParams(arguments, commandId);
        CompletionList completionList = PropertiesManagerForJava.getInstance().completion(params, JDTUtilsLSImpl.getInstance(), monitor);
        JavaCursorContextResult cursorContext = PropertiesManagerForJava.getInstance().javaCursorContext(params, JDTUtilsLSImpl.getInstance(), monitor);
        return new JakartaJavaCompletionResult(completionList, cursorContext);
    }

    private static JakartaJavaCompletionParams createJakartaJavaCompletionParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one JakartaJavaCompletionParams argument!", commandId));
        }
        String javaFileUri = ArgumentUtils.getString(obj, "uri");
        if (javaFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required JakartaJavaCompletionParams.uri (java URI)!", commandId));
        }
        Position position = ArgumentUtils.getPosition(obj, "position");
        if (position == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required JakartaJavaCompletionParams.position (completion trigger location)!", commandId));
        }
        JakartaJavaCompletionParams params = new JakartaJavaCompletionParams(javaFileUri, position);
        return params;
    }

    private static List<? extends CodeAction> getCodeActionForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        JakartaJavaCodeActionParams params = JakartaDelegateCommandHandlerForJava.createJakartaJavaCodeActionParams(arguments, commandId);
        return PropertiesManagerForJava.getInstance().codeAction(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static JakartaJavaCodeActionParams createJakartaJavaCodeActionParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one JakartaJavaCodeActionParams argument!", commandId));
        }
        TextDocumentIdentifier texdDocumentIdentifier = ArgumentUtils.getTextDocumentIdentifier(obj, "textDocument");
        if (texdDocumentIdentifier == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required JakartaJavaCodeActionParams.texdDocumentIdentifier", commandId));
        }
        Range range = ArgumentUtils.getRange(obj, "range");
        CodeActionContext context = ArgumentUtils.getCodeActionContext(obj, "context");
        boolean resourceOperationSupported = ArgumentUtils.getBoolean(obj, "resourceOperationSupported");
        boolean commandConfigurationUpdateSupported = ArgumentUtils.getBoolean(obj, "commandConfigurationUpdateSupported");
        boolean resolveSupported = ArgumentUtils.getBoolean(obj, "resolveSupported");
        JakartaJavaCodeActionParams params = new JakartaJavaCodeActionParams();
        params.setTextDocument(texdDocumentIdentifier);
        params.setRange(range);
        params.setContext(context);
        params.setResourceOperationSupported(resourceOperationSupported);
        params.setCommandConfigurationUpdateSupported(commandConfigurationUpdateSupported);
        params.setResolveSupported(resolveSupported);
        return params;
    }

    private static CodeAction resolveCodeActionForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        CodeAction unresolved = JakartaDelegateCommandHandlerForJava.createJakartaJavaCodeActionResolveParams(arguments, commandId);
        return PropertiesManagerForJava.getInstance().resolveCodeAction(unresolved, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static CodeAction createJakartaJavaCodeActionResolveParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one CodeAction argument!", commandId));
        }
        CodeAction codeAction = JSONUtility.toModel(obj, CodeAction.class);
        if (codeAction == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one CodeAction argument!", commandId));
        }
        CodeActionResolveData resolveData = JSONUtility.toModel(codeAction.getData(), CodeActionResolveData.class);
        if (resolveData == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with a CodeAction that has CodeActionResolveData!", commandId));
        }
        codeAction.setData((Object)resolveData);
        return codeAction;
    }

    private static List<PublishDiagnosticsParams> getDiagnosticsForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException {
        JakartaJavaDiagnosticsParams params = JakartaDelegateCommandHandlerForJava.createJakartaJavaDiagnosticsParams(arguments, commandId);
        return PropertiesManagerForJava.getInstance().diagnostics(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static JakartaJavaDiagnosticsParams createJakartaJavaDiagnosticsParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one JakartaJavaDiagnosticsParams argument!", commandId));
        }
        List<String> javaFileUri = ArgumentUtils.getStringList(obj, "uris");
        if (javaFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required JakartaJavaDiagnosticsParams.uri (java URIs)!", commandId));
        }
        JakartaJavaDiagnosticsSettings settings = null;
        Map<String, Object> settingsObj = ArgumentUtils.getObject(obj, "settings");
        if (settingsObj != null) {
            List<String> patterns = ArgumentUtils.getStringList(settingsObj, "patterns");
            settings = new JakartaJavaDiagnosticsSettings(patterns);
        }
        return new JakartaJavaDiagnosticsParams(javaFileUri, settings);
    }
}

