/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.commons.runtime.converter;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4mp.commons.runtime.AbstractMicroProfileRuntimeSupport;
import org.eclipse.lsp4mp.commons.runtime.DiagnosticsCollector;
import org.eclipse.lsp4mp.commons.runtime.EnumConstantsProvider;
import org.eclipse.lsp4mp.commons.runtime.ExecutionMode;
import org.eclipse.lsp4mp.commons.runtime.MicroProfileProjectRuntime;
import org.eclipse.lsp4mp.commons.runtime.MicroProfileRuntimeSupport;
import org.eclipse.lsp4mp.commons.runtime.TypeSignatureParser;
import org.eclipse.lsp4mp.commons.runtime.converter.ConverterRuntimeSupportApi;
import org.eclipse.lsp4mp.commons.runtime.converter.ConverterValidator;
import org.eclipse.lsp4mp.commons.runtime.converter.safe.EnumTypeConverterValidator;

public abstract class AbstractConverterRuntimeSupport<T>
extends AbstractMicroProfileRuntimeSupport
implements ConverterRuntimeSupportApi {
    private static final Logger LOGGER = Logger.getLogger(AbstractConverterRuntimeSupport.class.getName());
    private static final ConverterValidator NULL_CONVERTER = new ConverterValidator(){

        @Override
        public void validate(String value, int start, DiagnosticsCollector collector) {
        }

        @Override
        public boolean canValidate() {
            return false;
        }
    };
    private T config;
    private boolean initialized;
    private final Map<String, ConverterValidator> converterCache = new ConcurrentHashMap<String, ConverterValidator>();

    public AbstractConverterRuntimeSupport(MicroProfileProjectRuntime project, ExecutionMode executionMode) {
        super(project, executionMode);
    }

    @Override
    public void validate(String value, String type, EnumConstantsProvider enumConstNamesProvider, DiagnosticsCollector collector) {
        try {
            T cfg = this.getConfig();
            if (cfg == null) {
                return;
            }
            ConverterValidator validator = this.converterCache.computeIfAbsent(type, t -> this.resolveConverter(this.getProject().findType((String)t, enumConstNamesProvider, this.getExecutionMode()), cfg));
            if (validator.canValidate()) {
                validator.refreshEnumType(enumConstNamesProvider, this.getProject(), this.getExecutionMode());
                validator.validate(value, collector);
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Error while validating '" + value + "' value with type '" + type + "'", e);
        }
    }

    protected T getConfig() {
        if (this.config != null || this.initialized) {
            return this.config;
        }
        this.config = this.loadConfig();
        this.initialized = true;
        return this.config;
    }

    @Override
    public Class<? extends MicroProfileRuntimeSupport> getClassApi() {
        return ConverterRuntimeSupportApi.class;
    }

    @Override
    public boolean hasConfigProviderResolver() {
        this.getConfig();
        return this.initialized && this.config != null;
    }

    @Override
    public void reset() {
        this.config = null;
        this.initialized = false;
        this.converterCache.clear();
    }

    private ConverterValidator resolveConverter(Type type, T config) {
        Class rawTypeClass;
        if (type == null) {
            return NULL_CONVERTER;
        }
        if (type instanceof TypeSignatureParser.EnumType) {
            return new EnumTypeConverterValidator((TypeSignatureParser.EnumType)type);
        }
        Type rawType = AbstractConverterRuntimeSupport.rawTypeOf(type);
        if (type instanceof ParameterizedType) {
            Type[] typeArgs = ((ParameterizedType)type).getActualTypeArguments();
            if (rawType == List.class || rawType == Set.class) {
                return AbstractConverterRuntimeSupport.newCollectionConverter(this.resolveConverter(typeArgs[0], config));
            }
            if (rawType == Map.class) {
                return AbstractConverterRuntimeSupport.newMapConverter(this.resolveConverter(typeArgs[0], config), this.resolveConverter(typeArgs[1], config));
            }
            if (rawType == Optional.class) {
                return AbstractConverterRuntimeSupport.newOptionalConverter(this.resolveConverter(typeArgs[0], config));
            }
            if (rawType == Supplier.class || rawType != null && "jakarta.inject.Provider".equals(rawType.getTypeName())) {
                return this.resolveConverter(typeArgs[0], config);
            }
        } else if (rawType instanceof Class && (rawTypeClass = (Class)rawType).isArray()) {
            return AbstractConverterRuntimeSupport.newCollectionConverter(this.resolveConverter(rawTypeClass.getComponentType(), config));
        }
        if (!(type instanceof Class)) {
            return NULL_CONVERTER;
        }
        return this.newConverter(config, (Class)type);
    }

    private static ConverterValidator newOptionalConverter(ConverterValidator converter) {
        return converter;
    }

    private static ConverterValidator newMapConverter(ConverterValidator converter, ConverterValidator converter2) {
        return converter;
    }

    private static ConverterValidator newCollectionConverter(ConverterValidator converter) {
        return new CollectionConverter(converter);
    }

    static Type rawTypeOf(Type type) {
        if (type instanceof Class || type instanceof TypeSignatureParser.EmulateType) {
            return type;
        }
        if (type instanceof ParameterizedType) {
            return AbstractConverterRuntimeSupport.rawTypeOf(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance((Class)AbstractConverterRuntimeSupport.rawTypeOf(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        return null;
    }

    protected abstract ConverterValidator newConverter(T var1, Class<?> var2);

    protected abstract T loadConfig();

    static class CollectionConverter
    implements ConverterValidator {
        private final ConverterValidator delegate;

        CollectionConverter(ConverterValidator delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean canValidate() {
            return this.delegate.canValidate();
        }

        @Override
        public void validate(String value, int start, DiagnosticsCollector collector) {
            int startOffset = start;
            StringBuilder currentValue = new StringBuilder();
            int i = 0;
            while (i < value.length()) {
                char c = value.charAt(i);
                if (c == ',') {
                    this.delegate.validate(currentValue.toString(), startOffset, collector);
                    currentValue.setLength(0);
                    startOffset = i + 1;
                } else {
                    currentValue.append(c);
                }
                ++i;
            }
            if (!currentValue.isEmpty()) {
                this.delegate.validate(currentValue.toString(), startOffset, collector);
            }
        }
    }
}

