/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.commons.runtime.converter;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4mp.commons.runtime.DiagnosticsCollector;
import org.eclipse.lsp4mp.commons.runtime.converter.ConverterValidator;

public abstract class AbstractConverterValidator<T>
implements ConverterValidator {
    private static final Logger LOGGER = Logger.getLogger(AbstractConverterValidator.class.getName());
    private final T config;
    private Class<?> forType;
    private boolean prepared;

    public AbstractConverterValidator(T config, Class<?> forType) {
        this.config = config;
        this.forType = forType;
        this.prepared = this.prepare();
    }

    @Override
    public void validate(String value, int start, DiagnosticsCollector collector) {
        block3: {
            if (!this.prepared) {
                return;
            }
            try {
                this.convert(value);
            }
            catch (Throwable e) {
                String errorMessage = AbstractConverterValidator.getErrorMessage(e);
                if (errorMessage == null) break block3;
                collector.collect(errorMessage, "microprofile-config", "value", start, value.length());
            }
        }
    }

    private boolean prepare() {
        try {
            return this.initialize();
        }
        catch (Throwable e) {
            LOGGER.log(Level.INFO, "Error preparing converter for type " + this.forType.getTypeName(), e);
            return false;
        }
    }

    private static String getErrorMessage(Throwable e) {
        Throwable t = e;
        while (t instanceof InvocationTargetException || t != null && t.getCause() instanceof InvocationTargetException) {
            t = t.getCause();
        }
        return t != null ? t.getMessage() : e.getMessage();
    }

    @Override
    public boolean canValidate() {
        return this.prepared;
    }

    public T getConfig() {
        return this.config;
    }

    public Class<?> getForType() {
        return this.forType;
    }

    protected abstract boolean initialize() throws Exception;

    protected abstract void convert(String var1) throws Exception;
}

