/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.http.HttpClient;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.graph.Graph;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.irix.IRIs;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.FactoryRDF;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ContextAccumulator;
import org.apache.jena.sparql.util.Symbol;

public class RDFParserBuilder {
    private String uri = null;
    private Path path = null;
    private String stringToParse = null;
    private InputStream inputStream;
    private Reader javaReader = null;
    private StreamManager streamManager = null;
    private String appAcceptHeader = null;
    private Map<String, String> httpHeaders = new HashMap<String, String>();
    private HttpClient httpClient = null;
    private Lang hintLang = null;
    private Lang forceLang = null;
    private String baseURI = null;
    private ContextAccumulator contextAcc = ContextAccumulator.newBuilder(() -> RIOT.getContext());
    private boolean canonicalValues = false;
    private RDFParser.LangTagForm langTagForm = RDFParser.LangTagForm.NONE;
    private Optional<Boolean> checking = Optional.empty();
    private boolean strict = SysRIOT.isStrictMode();
    private boolean resolveURIs = true;
    private IRIxResolver resolver = null;
    private PrefixMap prefixMap = null;
    private FactoryRDF factory = null;
    private LabelToNode labelToNode = null;
    private ErrorHandler errorHandler = null;

    public static RDFParserBuilder create() {
        return new RDFParserBuilder();
    }

    private RDFParserBuilder() {
    }

    public RDFParserBuilder source(Path path) {
        this.clearSource();
        this.path = path;
        return this;
    }

    public RDFParserBuilder source(String uriOrFile) {
        this.clearSource();
        this.uri = uriOrFile;
        return this;
    }

    public RDFParserBuilder fromString(String string) {
        this.clearSource();
        this.stringToParse = string;
        return this;
    }

    public RDFParserBuilder source(InputStream input) {
        this.clearSource();
        this.inputStream = input;
        return this;
    }

    public RDFParserBuilder source(StringReader reader) {
        this.clearSource();
        this.javaReader = reader;
        return this;
    }

    @Deprecated
    public RDFParserBuilder source(Reader reader) {
        this.clearSource();
        this.javaReader = reader;
        return this;
    }

    public RDFParserBuilder streamManager(StreamManager streamManager) {
        this.streamManager = streamManager;
        return this;
    }

    private void clearSource() {
        this.uri = null;
        this.path = null;
        this.stringToParse = null;
        this.inputStream = null;
        this.javaReader = null;
    }

    public RDFParserBuilder lang(Lang lang) {
        this.hintLang = lang;
        return this;
    }

    public RDFParserBuilder strict(boolean strictMode) {
        this.strict = strictMode;
        return this;
    }

    public RDFParserBuilder forceLang(Lang lang) {
        this.forceLang = lang;
        return this;
    }

    public RDFParserBuilder acceptHeader(String acceptHeader) {
        this.appAcceptHeader = acceptHeader;
        return this;
    }

    @Deprecated
    public RDFParserBuilder httpAccept(String acceptHeader) {
        return this.acceptHeader(acceptHeader);
    }

    public RDFParserBuilder httpHeader(String header, String value) {
        this.httpHeaders.put(header, value);
        return this;
    }

    public RDFParserBuilder base(String base) {
        this.baseURI = base;
        return this;
    }

    public RDFParserBuilder resolveURIs(boolean flag) {
        this.resolveURIs = flag;
        return this;
    }

    public RDFParserBuilder resolver(IRIxResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public RDFParserBuilder prefixes(PrefixMap prefixMap) {
        this.prefixMap = prefixMap == null ? null : PrefixMapFactory.create(prefixMap);
        return this;
    }

    @Deprecated
    public RDFParserBuilder canonicalLiterals(boolean flag) {
        this.canonicalValues(flag);
        if (flag) {
            this.langTagCanonical();
        } else {
            this.langTagAsGiven();
        }
        return this;
    }

    public RDFParserBuilder canonicalValues(boolean flag) {
        this.canonicalValues = flag;
        return this;
    }

    public RDFParserBuilder langTagLowerCase() {
        return this.langTagForm(RDFParser.LangTagForm.LOWER_CASE);
    }

    public RDFParserBuilder langTagCanonical() {
        return this.langTagForm(RDFParser.LangTagForm.CANONICAL);
    }

    public RDFParserBuilder langTagAsGiven() {
        return this.langTagForm(RDFParser.LangTagForm.NONE);
    }

    private RDFParserBuilder langTagForm(RDFParser.LangTagForm form) {
        this.langTagForm = form;
        return this;
    }

    public RDFParserBuilder checking(boolean flag) {
        this.checking = Optional.of(flag);
        return this;
    }

    public RDFParserBuilder errorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
        return this;
    }

    public RDFParserBuilder factory(FactoryRDF factory) {
        this.factory = factory;
        return this;
    }

    public RDFParserBuilder labelToNode(LabelToNode labelToNode) {
        this.labelToNode = labelToNode;
        return this;
    }

    public RDFParserBuilder context(Context context2) {
        this.contextAcc.context(context2);
        return this;
    }

    public RDFParserBuilder set(Symbol symbol, Object value) {
        this.contextAcc.set(symbol, value);
        return this;
    }

    public RDFParserBuilder set(Symbol symbol, boolean value) {
        this.contextAcc.set(symbol, value);
        return this;
    }

    public void parse(StreamRDF stream) {
        this.build().parse(stream);
    }

    public void parse(Graph graph) {
        this.build().parse(graph);
    }

    public void parse(Model model) {
        this.build().parse(model);
    }

    public void parse(DatasetGraph dataset) {
        this.build().parse(dataset);
    }

    public void parse(Dataset dataset) {
        this.build().parse(dataset);
    }

    public Graph toGraph() {
        return this.build().toGraph();
    }

    public Model toModel() {
        return this.build().toModel();
    }

    public Dataset toDataset() {
        return this.build().toDataset();
    }

    public DatasetGraph toDatasetGraph() {
        return this.build().toDatasetGraph();
    }

    public RDFParser build() {
        if (this.uri == null && this.path == null && this.stringToParse == null && this.inputStream == null && this.javaReader == null) {
            throw new RiotException("No source specified");
        }
        Context context2 = this.contextAcc.context();
        HttpClient clientJDK = this.httpClient != null ? this.httpClient : HttpEnv.getDftHttpClient();
        FactoryRDF factory$ = this.buildFactoryRDF();
        ErrorHandler errorHandler$ = this.errorHandler;
        if (errorHandler$ == null) {
            errorHandler$ = ErrorHandlerFactory.getDefaultErrorHandler();
        }
        String parserBaseURI = this.baseURI != null ? IRIs.toBase((String)this.baseURI) : (this.path != null ? IRILib.filenameToIRI((String)this.path.toString()) : (this.uri != null ? IRIs.toBase((String)this.uri) : null));
        StreamManager sMgr = this.streamManager;
        if (sMgr == null) {
            sMgr = StreamManager.get(context2);
        }
        return new RDFParser(this.uri, this.path, this.stringToParse, this.inputStream, this.javaReader, sMgr, this.appAcceptHeader, this.httpHeaders, clientJDK, this.hintLang, this.forceLang, parserBaseURI, this.strict, this.checking, this.canonicalValues, this.langTagForm, this.resolveURIs, this.resolver, this.prefixMap, factory$, errorHandler$, context2);
    }

    private FactoryRDF buildFactoryRDF() {
        FactoryRDF factory$ = this.factory;
        if (factory$ == null) {
            factory$ = this.labelToNode != null ? RiotLib.factoryRDF(this.labelToNode) : RiotLib.factoryRDF();
        }
        return factory$;
    }

    public RDFParserBuilder clone() {
        RDFParserBuilder builder = new RDFParserBuilder();
        builder.uri = this.uri;
        builder.path = this.path;
        builder.stringToParse = this.stringToParse;
        builder.inputStream = this.inputStream;
        builder.javaReader = this.javaReader;
        builder.httpHeaders = Map.copyOf(this.httpHeaders);
        builder.httpClient = this.httpClient;
        builder.hintLang = this.hintLang;
        builder.forceLang = this.forceLang;
        builder.baseURI = this.baseURI;
        builder.contextAcc = this.contextAcc.clone();
        builder.checking = this.checking;
        builder.canonicalValues = this.canonicalValues;
        builder.langTagForm = this.langTagForm;
        builder.strict = this.strict;
        builder.resolveURIs = this.resolveURIs;
        builder.factory = this.factory;
        builder.labelToNode = this.labelToNode;
        builder.errorHandler = this.errorHandler;
        return builder;
    }
}

