/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.simple;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.dboe.storage.StoragePrefixes;
import org.apache.jena.dboe.storage.prefixes.PrefixEntry;
import org.apache.jena.dboe.storage.prefixes.PrefixLib;
import org.apache.jena.dboe.storage.prefixes.PrefixMapI;
import org.apache.jena.dboe.storage.prefixes.PrefixesFactory;
import org.apache.jena.graph.Node;

public class StoragePrefixesMem
implements StoragePrefixes {
    private Map<Node, PrefixMapI> map = new HashMap<Node, PrefixMapI>();

    @Override
    public String get(Node graphNode, String prefix) {
        PrefixMapI pmap = this.map.get(graphNode = PrefixLib.canonicalGraphName(graphNode));
        if (pmap == null) {
            return null;
        }
        return pmap.get(prefix);
    }

    @Override
    public Iterator<PrefixEntry> get(Node graphNode) {
        PrefixMapI pmap = this.map.get(graphNode = PrefixLib.canonicalGraphName(graphNode));
        if (pmap == null) {
            return Iter.nullIterator();
        }
        if (pmap.getPrefixMapStorage() != null) {
            return pmap.getPrefixMapStorage().iterator();
        }
        return pmap.iterator();
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        return this.map.keySet().iterator();
    }

    @Override
    public void add(Node graphNode, String prefix, String iriStr) {
        this.accessForUpdate(graphNode).add(prefix, iriStr);
    }

    @Override
    public void delete(Node graphNode, String prefix) {
        this.access(graphNode).delete(prefix);
    }

    @Override
    public void deleteAll(Node graphNode) {
        this.access(graphNode).clear();
    }

    @Override
    public boolean isEmpty() {
        if (this.map.isEmpty()) {
            return true;
        }
        return this.map.entrySet().stream().allMatch(e -> ((PrefixMapI)e.getValue()).isEmpty());
    }

    @Override
    public int size() {
        return 0;
    }

    protected PrefixMapI createPrefixMap() {
        return PrefixesFactory.createMem();
    }

    private PrefixMapI accessForUpdate(Node graphName) {
        PrefixMapI pmap = this.map.get(graphName = PrefixLib.canonicalGraphName(graphName));
        if (pmap == null) {
            pmap = this.createPrefixMap();
            this.map.put(graphName, pmap);
        }
        return pmap;
    }

    private PrefixMapI access(Node graphName) {
        PrefixMapI pmap = this.map.get(graphName = PrefixLib.canonicalGraphName(graphName));
        if (pmap == null) {
            return PrefixesFactory.empty();
        }
        return pmap;
    }
}

