/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.util.Objects;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormatVariant;

public class RDFFormat {
    public static final RDFFormatVariant PRETTY = new RDFFormatVariant("pretty");
    public static final RDFFormatVariant BLOCKS = new RDFFormatVariant("blocks");
    public static final RDFFormatVariant FLAT = new RDFFormatVariant("flat");
    public static final RDFFormatVariant ASCII = new RDFFormatVariant("ascii");
    public static final RDFFormatVariant UTF8 = new RDFFormatVariant("utf-8");
    public static final RDFFormatVariant ValueEncoding = new RDFFormatVariant("Value");
    public static final RDFFormat TURTLE_PRETTY;
    public static final RDFFormat TURTLE;
    public static final RDFFormat TTL;
    public static final RDFFormat TURTLE_BLOCKS;
    public static final RDFFormat TURTLE_FLAT;
    public static final RDFFormat NTRIPLES_UTF8;
    public static final RDFFormat NTRIPLES;
    public static final RDFFormat NT;
    public static final RDFFormat NTRIPLES_ASCII;
    public static final RDFFormat NQUADS_UTF8;
    public static final RDFFormat NQUADS;
    public static final RDFFormat NQ;
    public static final RDFFormat NQUADS_ASCII;
    public static final RDFFormat TRIG_PRETTY;
    public static final RDFFormat TRIG;
    public static final RDFFormat TRIG_BLOCKS;
    public static final RDFFormat TRIG_FLAT;
    private static final RDFFormatVariant EXPAND_PRETTY;
    private static final RDFFormatVariant EXPAND_FLAT;
    private static final RDFFormatVariant COMPACT_PRETTY;
    private static final RDFFormatVariant COMPACT_FLAT;
    private static final RDFFormatVariant FLATTEN_PRETTY;
    private static final RDFFormatVariant FLATTEN_FLAT;
    private static final RDFFormatVariant FRAME_PRETTY;
    private static final RDFFormatVariant FRAME_FLAT;
    public static final RDFFormat JSONLD_EXPAND_PRETTY;
    public static final RDFFormat JSONLD_EXPAND_FLAT;
    public static final RDFFormat JSONLD_COMPACT_PRETTY;
    public static final RDFFormat JSONLD_COMPACT_FLAT;
    public static final RDFFormat JSONLD_FLATTEN_PRETTY;
    public static final RDFFormat JSONLD_FLATTEN_FLAT;
    public static final RDFFormat JSONLD_FRAME_PRETTY;
    public static final RDFFormat JSONLD_FRAME_FLAT;
    public static final RDFFormat JSONLD_PRETTY;
    public static final RDFFormat JSONLD;
    public static final RDFFormat JSONLD_FLAT;
    public static final RDFFormatVariant ABBREV;
    public static final RDFFormatVariant PLAIN;
    public static final RDFFormat RDFXML_PRETTY;
    public static final RDFFormat RDFXML_ABBREV;
    public static final RDFFormat RDFXML;
    public static final RDFFormat RDFXML_PLAIN;
    public static final RDFFormat RDFJSON;
    public static final RDFFormat TRIX;
    public static final RDFFormat RDF_THRIFT;
    public static final RDFFormat RDF_THRIFT_VALUES;
    public static final RDFFormat RDFNULL;
    private final Lang lang;
    private final RDFFormatVariant variant;

    public RDFFormat(Lang lang) {
        this(lang, null);
    }

    public RDFFormat(Lang lang, RDFFormatVariant variant) {
        this.lang = lang;
        this.variant = variant;
    }

    public Lang getLang() {
        return this.lang;
    }

    public RDFFormatVariant getVariant() {
        return this.variant;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
        result = 31 * result + (this.variant == null ? 0 : this.variant.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RDFFormat other = (RDFFormat)obj;
        if (!Objects.equals(this.lang, other.lang)) {
            return false;
        }
        return Objects.equals(this.variant, other.variant);
    }

    public String toString() {
        if (this.variant == null) {
            return this.lang.getName();
        }
        return this.lang.getName() + "/" + this.variant;
    }

    static {
        TURTLE = TURTLE_PRETTY = new RDFFormat(Lang.TURTLE, PRETTY);
        TTL = TURTLE_PRETTY;
        TURTLE_BLOCKS = new RDFFormat(Lang.TURTLE, BLOCKS);
        TURTLE_FLAT = new RDFFormat(Lang.TURTLE, FLAT);
        NT = NTRIPLES = (NTRIPLES_UTF8 = new RDFFormat(Lang.NTRIPLES, UTF8));
        NTRIPLES_ASCII = new RDFFormat(Lang.NTRIPLES, ASCII);
        NQ = NQUADS = (NQUADS_UTF8 = new RDFFormat(Lang.NQUADS, UTF8));
        NQUADS_ASCII = new RDFFormat(Lang.NQUADS, ASCII);
        TRIG = TRIG_PRETTY = new RDFFormat(Lang.TRIG, PRETTY);
        TRIG_BLOCKS = new RDFFormat(Lang.TRIG, BLOCKS);
        TRIG_FLAT = new RDFFormat(Lang.TRIG, FLAT);
        EXPAND_PRETTY = new JSONLDVariant("expand pretty", true, JSONLDVariant.JSONLD_FORMAT.EXPAND);
        EXPAND_FLAT = new JSONLDVariant("expand flat", false, JSONLDVariant.JSONLD_FORMAT.EXPAND);
        COMPACT_PRETTY = new JSONLDVariant("compact pretty", true, JSONLDVariant.JSONLD_FORMAT.COMPACT);
        COMPACT_FLAT = new JSONLDVariant("compact flat", false, JSONLDVariant.JSONLD_FORMAT.COMPACT);
        FLATTEN_PRETTY = new JSONLDVariant("flatten pretty", true, JSONLDVariant.JSONLD_FORMAT.FLATTEN);
        FLATTEN_FLAT = new JSONLDVariant("flatten flat", false, JSONLDVariant.JSONLD_FORMAT.FLATTEN);
        FRAME_PRETTY = new JSONLDVariant("frame pretty", true, JSONLDVariant.JSONLD_FORMAT.FRAME);
        FRAME_FLAT = new JSONLDVariant("frame flat", false, JSONLDVariant.JSONLD_FORMAT.FRAME);
        JSONLD_EXPAND_PRETTY = new RDFFormat(Lang.JSONLD, EXPAND_PRETTY);
        JSONLD_EXPAND_FLAT = new RDFFormat(Lang.JSONLD, EXPAND_FLAT);
        JSONLD_COMPACT_PRETTY = new RDFFormat(Lang.JSONLD, COMPACT_PRETTY);
        JSONLD_COMPACT_FLAT = new RDFFormat(Lang.JSONLD, COMPACT_FLAT);
        JSONLD_FLATTEN_PRETTY = new RDFFormat(Lang.JSONLD, FLATTEN_PRETTY);
        JSONLD_FLATTEN_FLAT = new RDFFormat(Lang.JSONLD, FLATTEN_FLAT);
        JSONLD_FRAME_PRETTY = new RDFFormat(Lang.JSONLD, FRAME_PRETTY);
        JSONLD_FRAME_FLAT = new RDFFormat(Lang.JSONLD, FRAME_FLAT);
        JSONLD_PRETTY = JSONLD_COMPACT_PRETTY;
        JSONLD = JSONLD_COMPACT_PRETTY;
        JSONLD_FLAT = JSONLD_COMPACT_FLAT;
        ABBREV = new RDFFormatVariant("pretty");
        PLAIN = new RDFFormatVariant("plain");
        RDFXML_ABBREV = RDFXML_PRETTY = new RDFFormat(Lang.RDFXML, ABBREV);
        RDFXML = RDFXML_PRETTY;
        RDFXML_PLAIN = new RDFFormat(Lang.RDFXML, PLAIN);
        RDFJSON = new RDFFormat(Lang.RDFJSON);
        TRIX = new RDFFormat(Lang.TRIX);
        RDF_THRIFT = new RDFFormat(Lang.RDFTHRIFT);
        RDF_THRIFT_VALUES = new RDFFormat(Lang.RDFTHRIFT, ValueEncoding);
        RDFNULL = new RDFFormat(Lang.RDFNULL);
    }

    public static class JSONLDVariant
    extends RDFFormatVariant {
        private JSONLD_FORMAT format;
        private boolean prettyJson;

        JSONLDVariant(String name, boolean prettyJson, JSONLD_FORMAT format) {
            super(name);
            this.format = format;
            this.prettyJson = prettyJson;
        }

        public boolean isPretty() {
            return this.prettyJson;
        }

        private boolean isFormat(JSONLD_FORMAT fmt) {
            return fmt == this.format;
        }

        public boolean isCompact() {
            return this.isFormat(JSONLD_FORMAT.COMPACT);
        }

        public boolean isFlatten() {
            return this.isFormat(JSONLD_FORMAT.FLATTEN);
        }

        public boolean isExpand() {
            return this.isFormat(JSONLD_FORMAT.EXPAND);
        }

        public boolean isFrame() {
            return this.isFormat(JSONLD_FORMAT.FRAME);
        }

        private static enum JSONLD_FORMAT {
            COMPACT,
            FLATTEN,
            EXPAND,
            FRAME;

        }
    }
}

