/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.lang;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.builders.BuilderPrefixMapping;
import org.apache.jena.sparql.sse.lang.ParseHandlerForm;

public class ParseHandlerResolver
extends ParseHandlerForm {
    private static final String prefixTag = "prefix";
    private static final String baseTag = "base";
    private PrefixMapping topMap = null;
    private String topBase = null;
    private Prologue prologue = null;
    private ItemList declList = null;
    private Deque<Prologue> state = new ArrayDeque<Prologue>();

    public ParseHandlerResolver(Prologue p) {
        this.prologue = p;
    }

    @Override
    protected void declItem(ItemList list, Item item) {
        if (list != this.declList) {
            return;
        }
        boolean isBase = list.get(0).isSymbol(baseTag);
        boolean isPrefix = list.get(0).isSymbol(prefixTag);
        if (isBase) {
            if (!item.isNode()) {
                ParseHandlerResolver.throwException("(base ...): not an RDF node for the base.", item);
            }
            if (!item.getNode().isURI()) {
                ParseHandlerResolver.throwException("(base ...): not an IRI for the base.", item);
            }
            String baseIRI = item.getNode().getURI();
            this.prologue = this.prologue.sub(baseIRI);
            if (this.topBase == null) {
                this.topBase = baseIRI;
            }
            return;
        }
        if (isPrefix) {
            PrefixMapping newMappings = BuilderPrefixMapping.build(item);
            this.prologue = this.prologue.sub(newMappings);
            if (this.topMap == null) {
                this.topMap = newMappings;
            }
            return;
        }
        ParseHandlerResolver.throwException("Inconsistent: " + list.shortString(), list);
    }

    @Override
    protected boolean endOfDecl(ItemList list, Item item) {
        if (this.declList == list && list.size() == 2) {
            this.declList = null;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isForm(Item tag) {
        return tag.isSymbol(baseTag) || tag.isSymbol(prefixTag);
    }

    @Override
    protected void startForm(ItemList list) {
        this.declList = list;
        this.state.push(this.prologue);
    }

    private void dump() {
        for (Prologue p : this.state) {
            System.out.println("  Prologue: " + p.getBaseURI());
        }
    }

    @Override
    protected void finishForm(ItemList list) {
        this.prologue = this.state.pop();
        if (list.size() > 2) {
            Item item = list.getLast();
            super.setFormResult(item);
        }
    }

    @Override
    public void emitIRI(int line, int column, String iriStr) {
        iriStr = this.resolveIRI(iriStr, line, column);
        super.emitIRI(line, column, iriStr);
    }

    @Override
    public void emitPName(int line, int column, String pname) {
        if (this.inFormDecl()) {
            Item item = Item.createSymbol(pname, line, column);
            this.listAdd(item);
            return;
        }
        String iriStr = this.resolvePrefixedName(pname, line, column);
        super.emitIRI(line, column, iriStr);
    }

    @Override
    protected String resolvePrefixedName(String pname, int line, int column) {
        String uri;
        if (this.prologue.getPrefixMapping() == null) {
            ParseHandlerResolver.throwException("No prefix mapping for prefixed name: " + pname, line, column);
        }
        if (!StrUtils.contains((String)pname, (String)":")) {
            ParseHandlerResolver.throwException("Prefixed name does not have a ':': " + pname, line, column);
        }
        if ((uri = this.prologue.expandPrefixedName(pname)) == null) {
            ParseHandlerResolver.throwException("Can't resolve prefixed name: " + pname, line, column);
        }
        return uri;
    }

    private String resolveIRI(String iriStr, int line, int column) {
        if (this.prologue.getResolver() != null) {
            return this.prologue.getResolver().resolveToStringSilent(iriStr);
        }
        return iriStr;
    }
}

