/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.lyo.client.IOslcClient;
import org.eclipse.lyo.client.exception.ResourceNotFoundException;
import org.eclipse.lyo.oslc4j.core.model.CreationFactory;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.QueryCapability;
import org.eclipse.lyo.oslc4j.core.model.Service;
import org.eclipse.lyo.oslc4j.core.model.ServiceProvider;
import org.eclipse.lyo.oslc4j.core.model.ServiceProviderCatalog;
import org.eclipse.lyo.oslc4j.provider.jena.JenaProvidersRegistry;
import org.eclipse.lyo.oslc4j.provider.json4j.Json4JProvidersRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OslcClient
implements IOslcClient {
    private final String version;
    private Client client;
    private static final Logger logger = LoggerFactory.getLogger(OslcClient.class);

    public OslcClient() {
        this(ClientBuilder.newBuilder());
    }

    public OslcClient(String version) {
        this(ClientBuilder.newBuilder(), version);
    }

    public OslcClient(ClientBuilder clientBuilder) {
        this(clientBuilder, "2.0");
    }

    public OslcClient(ClientBuilder clientBuilder, String version) {
        for (Class provider : JenaProvidersRegistry.getProviders()) {
            clientBuilder.register(provider);
        }
        for (Class provider : Json4JProvidersRegistry.getProviders()) {
            clientBuilder.register(provider);
        }
        this.client = clientBuilder.build();
        this.version = version;
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    public <T> T getResource(String link, Class<T> clazz) {
        Response resource = this.getResource(link.toString());
        return (T)resource.readEntity(clazz);
    }

    public <T> T getResource(URI link, Class<T> clazz) {
        return this.getResource(link.toString(), clazz);
    }

    public <T> T getResource(Link link, Class<T> clazz) {
        URI value = (URI)Objects.requireNonNull(link.getValue());
        Response resource = this.getResource(value.toString());
        return (T)resource.readEntity(clazz);
    }

    public <T> List<T> getResources(URI[] links, Class<T> clazz) {
        return ((Stream)Arrays.stream(links).parallel()).map(uri -> {
            Response resource = this.getResource(uri.toString());
            return resource.readEntity(clazz);
        }).collect(Collectors.toList());
    }

    public <T> List<T> getResources(Collection<URI> links, Class<T> clazz) {
        return links.parallelStream().map(uri -> {
            Response resource = this.getResource(uri.toString());
            return resource.readEntity(clazz);
        }).collect(Collectors.toList());
    }

    public <T> List<T> getResourcesFromLinks(Collection<Link> links, Class<T> clazz) {
        URI[] uris = (URI[])links.stream().map(l -> (URI)l.getValue()).toArray(URI[]::new);
        return this.getResources(uris, clazz);
    }

    @Override
    public Response getResource(String url) {
        return this.getResource(url, null, "application/rdf+xml", null, true);
    }

    @Override
    public Response getResource(String url, String mediaType) {
        return this.getResource(url, null, mediaType, null, true);
    }

    @Override
    public Response getResource(String url, Map<String, String> requestHeaders) {
        return this.getResource(url, requestHeaders, "application/rdf+xml", null, true);
    }

    @Override
    public Response getResource(String url, Map<String, String> requestHeaders, String defaultMediaType) {
        return this.getResource(url, requestHeaders, defaultMediaType, null, true);
    }

    @Override
    public Response getResource(String url, Map<String, String> requestHeaders, String defaultMediaType, String configurationContext) {
        return this.getResource(url, requestHeaders, defaultMediaType, configurationContext, true);
    }

    @Override
    public Response getResource(String url, Map<String, String> requestHeaders, String defaultMediaType, boolean handleRedirects) {
        return this.getResource(url, requestHeaders, defaultMediaType, null, handleRedirects);
    }

    @Override
    public Response getResource(String url, Map<String, String> requestHeaders, String defaultMediaType, String configurationContext, boolean handleRedirects) {
        Response response = null;
        boolean redirect = false;
        do {
            WebTarget webTarget = this.client.target(url);
            Invocation.Builder innvocationBuilder = webTarget.request();
            boolean acceptSet = false;
            boolean versionSet = false;
            if (requestHeaders != null) {
                for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                    innvocationBuilder.header(entry.getKey(), (Object)entry.getValue());
                    if ("accept".equalsIgnoreCase(entry.getKey())) {
                        acceptSet = true;
                    }
                    if (!"OSLC-Core-Version".equalsIgnoreCase(entry.getKey())) continue;
                    versionSet = true;
                }
            }
            if (!acceptSet) {
                innvocationBuilder.accept(new String[]{defaultMediaType});
            }
            if (!versionSet) {
                innvocationBuilder.header("OSLC-Core-Version", (Object)this.version);
            }
            if (configurationContext != null) {
                innvocationBuilder.header("Configuration-Context", (Object)configurationContext);
            }
            response = innvocationBuilder.get();
            if (handleRedirects && Response.Status.fromStatusCode((int)response.getStatus()).getFamily() == Response.Status.Family.REDIRECTION) {
                url = (String)response.getStringHeaders().getFirst((Object)"Location");
                logger.debug("Following redirect to {}", (Object)url);
                response.readEntity(String.class);
                redirect = true;
                continue;
            }
            redirect = false;
        } while (redirect);
        return response;
    }

    @Override
    public Response deleteResource(String url) {
        return this.deleteResource(url, null);
    }

    @Override
    public Response deleteResource(String url, String configurationContext) {
        Response response = null;
        boolean redirect = false;
        do {
            Invocation.Builder invocationBuilder = this.client.target(url).request().header("OSLC-Core-Version", (Object)this.version);
            if (configurationContext != null) {
                invocationBuilder.header("Configuration-Context", (Object)configurationContext);
            }
            if (Response.Status.fromStatusCode((int)(response = invocationBuilder.delete()).getStatus()).getFamily() == Response.Status.Family.REDIRECTION) {
                url = (String)response.getStringHeaders().getFirst((Object)"Location");
                response.readEntity(String.class);
                redirect = true;
                continue;
            }
            redirect = false;
        } while (redirect);
        return response;
    }

    @Override
    public Response createResource(String url, Object artifact, String mediaType) {
        return this.createResource(url, artifact, mediaType, "*/*");
    }

    @Override
    public Response createResource(String url, Object artifact, String mediaType, String acceptType) {
        return this.createResource(url, artifact, mediaType, acceptType, null);
    }

    @Override
    public Response createResource(String url, Object artifact, String mediaType, String acceptType, String configurationContext) {
        Response response = null;
        boolean redirect = false;
        do {
            Invocation.Builder invocationBuilder = this.client.target(url).request().accept(new String[]{acceptType}).header("OSLC-Core-Version", (Object)this.version);
            if (configurationContext != null) {
                invocationBuilder.header("Configuration-Context", (Object)configurationContext);
            }
            if (Response.Status.fromStatusCode((int)(response = invocationBuilder.post(Entity.entity((Object)artifact, (String)mediaType))).getStatus()).getFamily() == Response.Status.Family.REDIRECTION) {
                url = (String)response.getStringHeaders().getFirst((Object)"Location");
                response.readEntity(String.class);
                redirect = true;
                continue;
            }
            redirect = false;
        } while (redirect);
        return response;
    }

    @Override
    public Response updateResource(String url, Object artifact, String mediaType) {
        return this.updateResource(url, artifact, mediaType, "*/*");
    }

    @Override
    public Response updateResource(String url, Object artifact, String mediaType, String acceptType) {
        return this.updateResource(url, artifact, mediaType, acceptType, null, null);
    }

    @Override
    public Response updateResource(String url, Object artifact, String mediaType, String acceptType, String ifMatch) {
        return this.updateResource(url, artifact, mediaType, acceptType, ifMatch, null);
    }

    @Override
    public Response updateResource(String url, Object artifact, String mediaType, String acceptType, String ifMatch, String configurationContext) {
        Response response = null;
        boolean redirect = false;
        do {
            Invocation.Builder invocationBuilder = this.client.target(url).request().accept(new String[]{acceptType}).header("OSLC-Core-Version", (Object)this.version);
            if (ifMatch != null) {
                invocationBuilder.header("If-Match", (Object)ifMatch);
            }
            if (configurationContext != null) {
                invocationBuilder.header("Configuration-Context", (Object)configurationContext);
            }
            if (Response.Status.fromStatusCode((int)(response = invocationBuilder.put(Entity.entity((Object)artifact, (String)mediaType))).getStatus()).getFamily() == Response.Status.Family.REDIRECTION) {
                url = (String)response.getStringHeaders().getFirst((Object)"Location");
                response.readEntity(String.class);
                redirect = true;
                continue;
            }
            redirect = false;
        } while (redirect);
        return response;
    }

    public WebTarget getWebResource(String capabilityUri) {
        WebTarget webTarget = this.client.target(capabilityUri);
        return webTarget;
    }

    public String lookupServiceProviderUrl(String catalogUrl, String serviceProviderTitle) throws IOException, URISyntaxException, ResourceNotFoundException {
        String retval = null;
        Response response = this.getResource(catalogUrl, "application/rdf+xml");
        if (response.getStatus() != 200) {
            logger.warn("Cannot read {} status: {}", (Object)catalogUrl, (Object)response.getStatus());
            return retval;
        }
        ServiceProviderCatalog catalog = (ServiceProviderCatalog)response.readEntity(ServiceProviderCatalog.class);
        if (catalog != null) {
            for (ServiceProvider sp : catalog.getServiceProviders()) {
                if (sp.getTitle() == null || !sp.getTitle().equalsIgnoreCase(serviceProviderTitle)) continue;
                retval = sp.getAbout().toString();
                break;
            }
        }
        if (retval == null) {
            throw new ResourceNotFoundException(catalogUrl, serviceProviderTitle);
        }
        return retval;
    }

    public String lookupQueryCapability(String serviceProviderUrl, String oslcDomain, String oslcResourceType) throws IOException, URISyntaxException, ResourceNotFoundException {
        QueryCapability defaultQueryCapability = null;
        QueryCapability firstQueryCapability = null;
        Response response = this.getResource(serviceProviderUrl, "application/rdf+xml");
        ServiceProvider serviceProvider = (ServiceProvider)response.readEntity(ServiceProvider.class);
        if (serviceProvider != null) {
            for (Service service : serviceProvider.getServices()) {
                QueryCapability[] queryCapabilities;
                URI domain = service.getDomain();
                if (domain == null || !domain.toString().equals(oslcDomain) || (queryCapabilities = service.getQueryCapabilities()) == null || queryCapabilities.length <= 0) continue;
                firstQueryCapability = queryCapabilities[0];
                for (QueryCapability queryCapability : service.getQueryCapabilities()) {
                    for (URI resourceType : queryCapability.getResourceTypes()) {
                        if (resourceType.toString() == null || !resourceType.toString().equals(oslcResourceType)) continue;
                        return queryCapability.getQueryBase().toString();
                    }
                    for (URI usage : queryCapability.getUsages()) {
                        if (usage.toString() == null || !usage.toString().equals("http://open-services.net/ns/core#default")) continue;
                        defaultQueryCapability = queryCapability;
                    }
                }
            }
        }
        if (defaultQueryCapability != null) {
            return defaultQueryCapability.getQueryBase().toString();
        }
        if (firstQueryCapability != null && firstQueryCapability.getResourceTypes().length == 0) {
            return firstQueryCapability.getQueryBase().toString();
        }
        throw new ResourceNotFoundException(serviceProviderUrl, "QueryCapability");
    }

    public CreationFactory lookupCreationFactoryResource(String serviceProviderUrl, String oslcDomain, String oslcResourceType) throws IOException, URISyntaxException, ResourceNotFoundException {
        return this.lookupCreationFactoryResource(serviceProviderUrl, oslcDomain, oslcResourceType, null);
    }

    public CreationFactory lookupCreationFactoryResource(String serviceProviderUrl, String oslcDomain, String oslcResourceType, String oslcUsage) throws IOException, URISyntaxException, ResourceNotFoundException {
        CreationFactory defaultCreationFactory = null;
        CreationFactory firstCreationFactory = null;
        Response response = this.getResource(serviceProviderUrl, "application/rdf+xml");
        ServiceProvider serviceProvider = (ServiceProvider)response.readEntity(ServiceProvider.class);
        if (serviceProvider != null) {
            for (Service service : serviceProvider.getServices()) {
                CreationFactory[] creationFactories;
                URI domain = service.getDomain();
                if (domain == null || !domain.toString().equals(oslcDomain) || (creationFactories = service.getCreationFactories()) == null || creationFactories.length <= 0) continue;
                firstCreationFactory = creationFactories[0];
                for (CreationFactory creationFactory : creationFactories) {
                    for (URI resourceType : creationFactory.getResourceTypes()) {
                        if (resourceType.toString() == null || !resourceType.toString().equals(oslcResourceType)) continue;
                        if (oslcUsage != null) {
                            for (URI factoryUsage : creationFactory.getUsages()) {
                                if (!oslcUsage.equals(factoryUsage.toString())) continue;
                                return creationFactory;
                            }
                            continue;
                        }
                        return creationFactory;
                    }
                    for (URI usage : creationFactory.getUsages()) {
                        if (usage.toString() == null || !usage.toString().equals("http://open-services.net/ns/core#default")) continue;
                        defaultCreationFactory = creationFactory;
                    }
                }
            }
        }
        if (defaultCreationFactory != null) {
            return defaultCreationFactory;
        }
        if (firstCreationFactory != null && firstCreationFactory.getResourceTypes().length == 0) {
            return firstCreationFactory;
        }
        throw new ResourceNotFoundException(serviceProviderUrl, "CreationFactory");
    }

    public String lookupCreationFactory(String serviceProviderUrl, String oslcDomain, String oslcResourceType) throws IOException, URISyntaxException, ResourceNotFoundException {
        return this.lookupCreationFactory(serviceProviderUrl, oslcDomain, oslcResourceType, null);
    }

    public String lookupCreationFactory(String serviceProviderUrl, String oslcDomain, String oslcResourceType, String oslcUsage) throws IOException, URISyntaxException, ResourceNotFoundException {
        return this.lookupCreationFactoryResource(serviceProviderUrl, oslcDomain, oslcResourceType, oslcUsage).getCreation().toString();
    }
}

