/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.core.query.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.eclipse.lyo.core.query.Identifier;
import org.eclipse.lyo.core.query.NestedProperty;
import org.eclipse.lyo.core.query.Property;
import org.eclipse.lyo.core.query.Wildcard;
import org.eclipse.lyo.core.query.impl.NestedPropertyInvocationHandler;
import org.eclipse.lyo.core.query.impl.PropertyInvocationHandler;
import org.eclipse.lyo.core.query.impl.WildcardInvocationHandler;

public class PropertiesInvocationHandler
implements InvocationHandler {
    private final CommonTree tree;
    protected final Map<String, String> prefixMap;
    private List<Property> children = null;

    public PropertiesInvocationHandler(CommonTree tree, Map<String, String> prefixMap) {
        this.tree = tree;
        this.prefixMap = prefixMap;
    }

    public PropertiesInvocationHandler() {
        this.tree = null;
        this.prefixMap = null;
        this.children = new ArrayList<Property>(1);
        this.children.add((Property)Proxy.newProxyInstance(Wildcard.class.getClassLoader(), new Class[]{Wildcard.class}, (InvocationHandler)new WildcardInvocationHandler()));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        boolean isChildren = method.getName().equals("children");
        if (isChildren && this.children != null) {
            return this.children;
        }
        this.children = PropertiesInvocationHandler.createChildren(this.tree, this.prefixMap);
        if (isChildren) {
            return this.children;
        }
        StringBuffer buffer = PropertiesInvocationHandler.childrenToString(new StringBuffer(), this.children);
        return buffer.toString();
    }

    static List<Property> createChildren(CommonTree tree, Map<String, String> prefixMap) {
        ArrayList<Property> children = new ArrayList(tree.getChildCount());
        for (int index = 0; index < tree.getChildCount(); ++index) {
            Property property;
            Tree treeChild = tree.getChild(index);
            switch (treeChild.getType()) {
                case 25: {
                    property = (Property)Proxy.newProxyInstance(Wildcard.class.getClassLoader(), new Class[]{Wildcard.class}, (InvocationHandler)new WildcardInvocationHandler());
                    break;
                }
                case 23: {
                    property = (Property)Proxy.newProxyInstance(Identifier.class.getClassLoader(), new Class[]{Identifier.class}, (InvocationHandler)new PropertyInvocationHandler((CommonTree)treeChild.getChild(0), Property.Type.IDENTIFIER, prefixMap, false));
                    break;
                }
                default: {
                    property = (Property)Proxy.newProxyInstance(NestedProperty.class.getClassLoader(), new Class[]{NestedProperty.class}, (InvocationHandler)new NestedPropertyInvocationHandler(treeChild, prefixMap));
                }
            }
            children.add(property);
        }
        children = Collections.unmodifiableList(children);
        return children;
    }

    static StringBuffer childrenToString(StringBuffer buffer, List<Property> children) {
        boolean first = true;
        for (Property property : children) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            buffer.append(property.toString());
        }
        return buffer;
    }
}

