/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.store.internals;

import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.jena.arq.querybuilder.SelectBuilder;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.tdb.TDB;
import org.apache.jena.tdb.TDBFactory;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.IResource;
import org.eclipse.lyo.oslc4j.provider.jena.JenaModelHelper;
import org.eclipse.lyo.store.ModelUnmarshallingException;
import org.eclipse.lyo.store.Store;
import org.eclipse.lyo.store.StoreAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class JenaTdbStoreImpl
implements Store {
    private static final Logger log = LoggerFactory.getLogger(JenaTdbStoreImpl.class);
    private final Dataset dataset;

    public JenaTdbStoreImpl() {
        this.dataset = TDBFactory.createDataset();
    }

    public JenaTdbStoreImpl(Dataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public boolean namedGraphExists(URI namedGraph) {
        boolean contains;
        this.dataset.begin(ReadWrite.READ);
        try {
            contains = this.dataset.containsNamedModel(namedGraph.toString());
            this.dataset.commit();
        }
        finally {
            this.dataset.end();
        }
        return contains;
    }

    @Override
    public <T extends IResource> List<T> getResources(URI namedGraph, Class<T> clazz) throws StoreAccessException, ModelUnmarshallingException {
        if (this.namedGraphExists(namedGraph)) {
            this.dataset.begin(ReadWrite.READ);
            Model model = this.dataset.getNamedModel(namedGraph.toString());
            try {
                Object[] obj = JenaModelHelper.fromJenaModel((Model)model, clazz);
                this.dataset.commit();
                IResource[] castObjects = (IResource[])Array.newInstance(clazz, obj.length);
                for (int i = 0; i < obj.length; ++i) {
                    castObjects[i] = (IResource)clazz.cast(obj[i]);
                }
                List<IResource> list = Arrays.asList(castObjects);
                return list;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | URISyntaxException | DatatypeConfigurationException | OslcCoreApplicationException e) {
                throw new ModelUnmarshallingException("Failed to buildPersistent an object from Jena model", e);
            }
            finally {
                this.dataset.end();
            }
        }
        throw new StoreAccessException(String.format("Model with namedGraph='%s' is not cached", namedGraph));
    }

    @Override
    public final <T extends IResource> boolean putResources(URI namedGraph, Collection<T> resources) throws StoreAccessException {
        try {
            Model model = JenaModelHelper.createJenaModel((Object[])resources.toArray());
            this.putJenaModel(namedGraph, model);
            return true;
        }
        catch (IllegalAccessException | InvocationTargetException | DatatypeConfigurationException | OslcCoreApplicationException e) {
            throw new StoreAccessException(e);
        }
    }

    @Override
    public final <T extends IResource> boolean appendResources(URI namedGraph, Collection<T> resources) throws StoreAccessException {
        this.dataset.begin(ReadWrite.WRITE);
        try {
            Model triplestoreModel = this.dataset.getNamedModel(String.valueOf(namedGraph));
            Model addModel = JenaModelHelper.createJenaModel((Object[])resources.toArray());
            triplestoreModel.add(addModel);
            this.dataset.commit();
        }
        catch (IllegalAccessException | InvocationTargetException | DatatypeConfigurationException | OslcCoreApplicationException e) {
            throw new StoreAccessException(e);
        }
        finally {
            this.dataset.end();
        }
        return false;
    }

    @Override
    public void clear(URI namedGraph) {
        this.dataset.begin(ReadWrite.WRITE);
        try {
            this.dataset.removeNamedModel(namedGraph.toString());
            this.dataset.commit();
        }
        finally {
            this.dataset.end();
        }
    }

    @Override
    public <T extends IResource> List<T> getResources(URI namedGraph, Class<T> clazz, int limit, int offset) throws StoreAccessException, ModelUnmarshallingException {
        List<T> resources = this.getResources(namedGraph, clazz);
        return resources.subList(offset, Math.min(resources.size(), offset + limit));
    }

    @Override
    public <T extends IResource> List<T> getResources(URI namedGraphUri, Class<T> clazz, String prefixes, String where, String searchTerms, int limit, int offset) throws StoreAccessException, ModelUnmarshallingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends IResource> List<T> getResources(URI namedGraphUri, Class<T> clazz, String prefixes, String where, String searchTerms, int limit, int offset, List<String> additionalDistinctVars, SelectBuilder additionalQueryFilter) throws StoreAccessException, ModelUnmarshallingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Model getResources(URI namedGraph, String prefixes, String where, int limit, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Model getResources(URI namedGraph, String prefixes, String where, String searchTerms, int limit, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Model getResources(URI namedGraph, String prefixes, String where, String searchTerms, int limit, int offset, List<String> additionalDistinctVars, SelectBuilder additionalQueryFilter) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> keySet() {
        this.dataset.begin(ReadWrite.READ);
        try {
            Iterator namedGraphNames = this.dataset.listNames();
            HashSet strings = Sets.newHashSet((Iterator)namedGraphNames);
            this.dataset.commit();
            HashSet hashSet = strings;
            return hashSet;
        }
        finally {
            this.dataset.end();
        }
    }

    @Override
    public void removeAll() {
        this.dataset.begin(ReadWrite.WRITE);
        try {
            this.dataset.asDatasetGraph().clear();
            this.dataset.commit();
        }
        finally {
            this.dataset.end();
        }
    }

    @Override
    public void close() {
        TDB.sync((Dataset)this.dataset);
        this.dataset.close();
    }

    @Override
    public <T extends IResource> T getResource(URI namedGraph, URI uri, Class<T> clazz) throws NoSuchElementException, StoreAccessException, ModelUnmarshallingException {
        List<T> list = this.getResources(namedGraph, clazz);
        for (IResource resource : list) {
            if (!resource.getAbout().equals(uri)) continue;
            return (T)resource;
        }
        throw new NoSuchElementException("Resource with a given URI doesn't exist under a given namedGraph");
    }

    @Override
    public void insertJenaModel(URI name, Model model) {
        this.dataset.begin(ReadWrite.WRITE);
        try {
            this.dataset.addNamedModel(name.toString(), model);
            this.dataset.commit();
        }
        finally {
            this.dataset.end();
        }
    }

    public void putJenaModel(URI name, Model model) {
        this.dataset.begin(ReadWrite.WRITE);
        try {
            this.dataset.replaceNamedModel(name.toString(), model);
            this.dataset.commit();
        }
        finally {
            this.dataset.end();
        }
        TDB.sync((Dataset)this.dataset);
    }

    @Override
    public boolean resourceExists(URI namedGraphUri, URI resourceUri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean insertResources(URI namedGraph, Object ... resources) throws StoreAccessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteResources(URI namedGraphUri, URI ... nodeUris) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteResources(URI namedGraphUri, IResource ... resources) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T extends IResource> boolean updateResources(URI namedGraphUri, T ... resources) throws StoreAccessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Model getJenaModelForSubject(URI namedGraphUri, URI subject) throws NoSuchElementException {
        throw new UnsupportedOperationException();
    }

    public boolean putResource(URI namedGraphUri, IResource resource) throws StoreAccessException, NoSuchElementException {
        throw new UnsupportedOperationException();
    }
}

