/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.store.internals;

import com.google.common.base.Strings;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.DescribeBuilder;
import org.apache.jena.arq.querybuilder.ExprFactory;
import org.apache.jena.arq.querybuilder.SelectBuilder;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.riot.RiotException;
import org.apache.jena.sparql.expr.E_Regex;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.modify.request.QuadDataAcc;
import org.apache.jena.sparql.modify.request.UpdateDataInsert;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateProcessor;
import org.eclipse.lyo.core.query.ComparisonTerm;
import org.eclipse.lyo.core.query.DecimalValue;
import org.eclipse.lyo.core.query.PName;
import org.eclipse.lyo.core.query.ParseException;
import org.eclipse.lyo.core.query.QueryUtils;
import org.eclipse.lyo.core.query.SimpleTerm;
import org.eclipse.lyo.core.query.StringValue;
import org.eclipse.lyo.core.query.UriRefValue;
import org.eclipse.lyo.core.query.Value;
import org.eclipse.lyo.core.query.WhereClause;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.IResource;
import org.eclipse.lyo.oslc4j.provider.jena.JenaModelHelper;
import org.eclipse.lyo.store.ModelUnmarshallingException;
import org.eclipse.lyo.store.Store;
import org.eclipse.lyo.store.StoreAccessException;
import org.eclipse.lyo.store.internals.JenaTdbStoreImpl;
import org.eclipse.lyo.store.internals.query.JenaQueryExecutor;
import org.eclipse.lyo.store.internals.query.SparqlQueryExecutorBasicAuthImpl;
import org.eclipse.lyo.store.internals.query.SparqlQueryExecutorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlStoreImpl
implements Store {
    public static final int TRIPLE_LIMIT = 10001;
    private static final Logger log = LoggerFactory.getLogger(JenaTdbStoreImpl.class);
    private final JenaQueryExecutor queryExecutor;

    public SparqlStoreImpl(String queryEndpoint, String updateEndpoint) {
        this(new SparqlQueryExecutorImpl(queryEndpoint, updateEndpoint));
    }

    public SparqlStoreImpl(String queryEndpoint, String updateEndpoint, String username, String password) {
        this(new SparqlQueryExecutorBasicAuthImpl(queryEndpoint, updateEndpoint, username, password));
    }

    public SparqlStoreImpl(JenaQueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    @Override
    public void insertJenaModel(URI namedGraph, Model model) {
        QuadDataAcc quadAccumulator = new QuadDataAcc();
        quadAccumulator.setGraph(NodeFactory.createURI((String)String.valueOf(namedGraph)));
        StmtIterator statementIterator = model.listStatements();
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.nextStatement();
            Triple triple = statement.asTriple();
            quadAccumulator.addTriple(triple);
        }
        UpdateDataInsert dataInsertUpdate = new UpdateDataInsert(quadAccumulator);
        UpdateProcessor up = this.queryExecutor.prepareSparqlUpdate((Update)dataInsertUpdate);
        up.execute();
    }

    @Override
    public boolean insertResources(URI namedGraph, Object ... resources) throws StoreAccessException {
        try {
            Model model = JenaModelHelper.createJenaModel((Object[])resources);
            this.insertJenaModel(namedGraph, model);
            return true;
        }
        catch (IllegalAccessException | InvocationTargetException | DatatypeConfigurationException | OslcCoreApplicationException e) {
            throw new StoreAccessException(e);
        }
    }

    @Override
    public void deleteResources(URI namedGraphUri, URI ... subjectUris) {
        QuerySolutionMap map = new QuerySolutionMap();
        for (int i = 0; i < subjectUris.length; ++i) {
            map.clear();
            map.add("graph", (RDFNode)new ResourceImpl(String.valueOf(namedGraphUri)));
            map.add("subject", (RDFNode)new ResourceImpl(String.valueOf(subjectUris[i])));
            ParameterizedSparqlString sparqlString = new ParameterizedSparqlString("WITH ?graph DELETE  { ?s ?p ?v } WHERE {?s ?p ?v . FILTER(?s = ?subject)}", map);
            String query = sparqlString.toString();
            UpdateProcessor updateProcessor = this.queryExecutor.prepareSparqlUpdate(query);
            updateProcessor.execute();
        }
    }

    @Override
    public void deleteResources(URI namedGraphUri, IResource ... resources) {
        URI[] nodeUris = new URI[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            nodeUris[i] = resources[i].getAbout();
        }
        this.deleteResources(namedGraphUri, nodeUris);
    }

    @Override
    public boolean namedGraphExists(URI namedGraphUri) {
        QuerySolutionMap map = new QuerySolutionMap();
        map.add("g", (RDFNode)new ResourceImpl(String.valueOf(namedGraphUri)));
        ParameterizedSparqlString sparqlString = new ParameterizedSparqlString("ASK {GRAPH ?g {?s ?p ?o} }", map);
        String query = sparqlString.toString();
        QueryExecution queryExecution = this.queryExecutor.prepareSparqlQuery(query);
        return queryExecution.execAsk();
    }

    @Override
    public boolean resourceExists(URI namedGraphUri, URI resourceUri) {
        QuerySolutionMap map = new QuerySolutionMap();
        map.add("g", (RDFNode)new ResourceImpl(String.valueOf(namedGraphUri)));
        map.add("s", (RDFNode)new ResourceImpl(String.valueOf(resourceUri)));
        ParameterizedSparqlString sparqlString = new ParameterizedSparqlString("ASK {GRAPH ?g {?s ?p ?o} }", map);
        String query = sparqlString.toString();
        QueryExecution queryExecution = this.queryExecutor.prepareSparqlQuery(query);
        return queryExecution.execAsk();
    }

    @Override
    public Model getJenaModelForSubject(URI namedGraphUri, URI subject) throws NoSuchElementException {
        if (!this.namedGraphExists(namedGraphUri)) {
            throw new NoSuchElementException("namedGraph '" + namedGraphUri + "' is missing from the triplestore");
        }
        Model model = this.modelFromQueryByUri(namedGraphUri, subject);
        if (model.isEmpty()) {
            throw new NoSuchElementException("resource '" + subject + "' is missing from the triplestore at namedGraph '" + namedGraphUri + "'");
        }
        return model;
    }

    @Override
    public <T extends IResource> List<T> getResources(URI namedGraph, Class<T> clazz) throws StoreAccessException, ModelUnmarshallingException {
        if (this.namedGraphExists(namedGraph)) {
            Model model = this.modelFromQueryFlat(namedGraph);
            return this.getResourcesFromModel(model, clazz);
        }
        throw new IllegalArgumentException("Named graph" + String.valueOf(namedGraph) + " was missing from the triplestore");
    }

    @Override
    public <T extends IResource> List<T> getResources(URI namedGraph, Class<T> clazz, int limit, int offset) throws StoreAccessException, ModelUnmarshallingException {
        if (this.namedGraphExists(namedGraph)) {
            Model model = this.modelFromQueryFlatPaged(namedGraph, this.getResourceNsUri(clazz), limit, offset);
            return this.getResourcesFromModel(model, clazz);
        }
        throw new IllegalArgumentException("Named graph" + String.valueOf(namedGraph) + " was missing from the triplestore");
    }

    @Override
    public <T extends IResource> List<T> getResources(URI namedGraph, Class<T> clazz, String prefixes, String where, String searchTerms, int limit, int offset) throws StoreAccessException, ModelUnmarshallingException {
        return this.getResources(namedGraph, clazz, prefixes, where, searchTerms, limit, offset, null, null);
    }

    @Override
    public <T extends IResource> List<T> getResources(URI namedGraph, Class<T> clazz, String prefixes, String where, String searchTerms, int limit, int offset, List<String> additionalDistinctVars, SelectBuilder additionalQueryFilter) throws StoreAccessException, ModelUnmarshallingException {
        String _prefixes = prefixes;
        String _where = where;
        _prefixes = (StringUtils.isEmpty((CharSequence)_prefixes) ? "" : _prefixes + ",") + this.oslcQueryPrefixes(clazz);
        _where = (StringUtils.isEmpty((CharSequence)_where) ? "" : _where + " and ") + this.oslcQueryWhere(clazz);
        Model model = this.getResources(namedGraph, _prefixes, _where, searchTerms, limit, offset, additionalDistinctVars, additionalQueryFilter);
        return this.getResourcesFromModel(model, clazz);
    }

    @Override
    public Model getResources(URI namedGraph, String prefixes, String where, int limit, int offset) {
        return this.getResources(namedGraph, prefixes, where, null, limit, offset);
    }

    @Override
    public Model getResources(URI namedGraph, String prefixes, String where, String searchTerms, int limit, int offset) {
        return this.getResources(namedGraph, prefixes, where, searchTerms, limit, offset, null, null);
    }

    @Override
    public Model getResources(URI namedGraph, String prefixes, String where, String searchTerms, int limit, int offset, List<String> additionalDistinctVars, SelectBuilder additionalQueryFilter) {
        Model execDescribe;
        if (namedGraph != null && !this.namedGraphExists(namedGraph)) {
            throw new IllegalArgumentException("Named graph" + String.valueOf(namedGraph) + " was missing from the triplestore");
        }
        SelectBuilder sparqlWhereQuery = this.constructSparqlWhere(prefixes, where, searchTerms, limit, offset, additionalDistinctVars, additionalQueryFilter);
        DescribeBuilder describeBuilder = new DescribeBuilder();
        describeBuilder.addVar((Object)"s").addGraph(namedGraph != null ? new ResourceImpl(String.valueOf(namedGraph)) : "?g", (AbstractQueryBuilder)sparqlWhereQuery);
        if (null != additionalDistinctVars) {
            for (String additionalDistinctVar : additionalDistinctVars) {
                describeBuilder.addVar((Object)additionalDistinctVar);
            }
        }
        if (log.isTraceEnabled() && !Strings.isNullOrEmpty((String)where)) {
            log.trace("SPARQL WHERE query for oslc.where='{}': {}", (Object)where, (Object)sparqlWhereQuery.buildString());
        }
        Query describeQuery = describeBuilder.build();
        String describeQueryString = describeQuery.toString();
        QueryExecution queryExecution = this.queryExecutor.prepareSparqlQuery(describeQueryString);
        try {
            execDescribe = queryExecution.execDescribe();
        }
        catch (RiotException e) {
            if (e.getCause() == null && e.getMessage().equals("[line: 2, col: 2 ] Out of place: [DOT]")) {
                return ModelFactory.createDefaultModel();
            }
            throw e;
        }
        return execDescribe;
    }

    @Override
    public <T extends IResource> T getResource(URI namedGraphUri, URI resourceUri, Class<T> clazz) throws NoSuchElementException, StoreAccessException, ModelUnmarshallingException {
        Model model = this.getJenaModelForSubject(namedGraphUri, resourceUri);
        List<T> modelResources = this.getResourcesFromModel(model, clazz);
        if (modelResources == null || modelResources.isEmpty()) {
            throw new NoSuchElementException("Empty Jena model for the subject " + resourceUri + ". Use resourceExists(g,r) method to check for resource existence before calling this method.");
        }
        return (T)((IResource)modelResources.get(0));
    }

    @Override
    public <T extends IResource> boolean updateResources(URI namedGraphUri, T ... resources) throws StoreAccessException {
        this.deleteResources(namedGraphUri, (IResource[])resources);
        return this.insertResources(namedGraphUri, resources);
    }

    @Override
    public <T extends IResource> boolean putResources(URI uri, Collection<T> resources) throws StoreAccessException {
        if (this.namedGraphExists(uri)) {
            this.clear(uri);
        }
        return this.insertResources(uri, resources.toArray());
    }

    @Override
    public <T extends IResource> boolean appendResources(URI namedGraph, Collection<T> resources) throws StoreAccessException {
        return this.insertResources(namedGraph, resources.toArray());
    }

    @Override
    public void clear(URI namedGraph) {
        QuerySolutionMap map = this.getGraphMap(namedGraph);
        ParameterizedSparqlString query = new ParameterizedSparqlString("CLEAR GRAPH ?g", map);
        UpdateProcessor up = this.queryExecutor.prepareSparqlUpdate(query.toString());
        up.execute();
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAll() {
        this.queryExecutor.prepareSparqlUpdate("CLEAR ALL").execute();
    }

    @Override
    public void close() {
        this.queryExecutor.release();
        log.debug("Underlying SPARQL connection has been released");
    }

    private <T extends IResource> String oslcQueryPrefixes(Class<T> clazz) {
        return "rdf=<http://www.w3.org/1999/02/22-rdf-syntax-ns#>";
    }

    private <T extends IResource> String oslcQueryWhere(Class<T> clazz) {
        return "rdf:type=<" + this.getResourceNsUri(clazz) + ">";
    }

    private <T extends IResource> List<T> getResourcesFromModel(Model model, Class<T> clazz) throws ModelUnmarshallingException, StoreAccessException {
        try {
            Object[] obj = JenaModelHelper.fromJenaModel((Model)model, clazz);
            IResource[] castObjects = (IResource[])Array.newInstance(clazz, obj.length);
            for (int i = 0; i < obj.length; ++i) {
                castObjects[i] = (IResource)clazz.cast(obj[i]);
            }
            return Arrays.asList(castObjects);
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException | URISyntaxException | DatatypeConfigurationException | OslcCoreApplicationException e) {
            throw new ModelUnmarshallingException(e);
        }
        catch (IllegalAccessException e) {
            throw new StoreAccessException(e);
        }
    }

    private <T extends IResource> URI getResourceNsUri(Class<T> clazz) {
        OslcNamespace oslcNamespace = clazz.getAnnotation(OslcNamespace.class);
        OslcName oslcName = clazz.getAnnotation(OslcName.class);
        String name = oslcName != null ? oslcName.value() : clazz.getSimpleName();
        return URI.create(oslcNamespace.value() + name);
    }

    private QuerySolutionMap getGraphMap(URI namedGraph) {
        QuerySolutionMap map = new QuerySolutionMap();
        map.add("g", (RDFNode)new ResourceImpl(String.valueOf(namedGraph)));
        return map;
    }

    private Model modelFromQueryFlat(URI namedGraph) {
        QuerySolutionMap map = this.getGraphMap(namedGraph);
        String queryTemplate = "DESCRIBE ?s WHERE { GRAPH ?g { ?s ?p ?o } }";
        ParameterizedSparqlString query = new ParameterizedSparqlString("DESCRIBE ?s WHERE { GRAPH ?g { ?s ?p ?o } }", map);
        QueryExecution queryExecution = this.queryExecutor.prepareSparqlQuery(query.toString());
        return queryExecution.execDescribe();
    }

    private Model modelFromQueryByUri(URI namedGraph, URI uri) {
        Model execDescribe;
        QuerySolutionMap map = this.getGraphMap(namedGraph);
        map.add("s", (RDFNode)new ResourceImpl(String.valueOf(uri)));
        String queryTemplate = "DESCRIBE ?s WHERE { GRAPH ?g { ?s ?p ?o . } }";
        ParameterizedSparqlString query = new ParameterizedSparqlString("DESCRIBE ?s WHERE { GRAPH ?g { ?s ?p ?o . } }", map);
        QueryExecution queryExecution = this.queryExecutor.prepareSparqlQuery(query.toString());
        try {
            execDescribe = queryExecution.execDescribe();
        }
        catch (RiotException e) {
            if (e.getCause() == null && e.getMessage().equals("[line: 2, col: 2 ] Out of place: [DOT]")) {
                return ModelFactory.createDefaultModel();
            }
            throw e;
        }
        return execDescribe;
    }

    private Model modelFromQueryFlatPaged(URI namedGraph, URI type, int limit, int offset) {
        Model m = ModelFactory.createDefaultModel();
        Resource typeResource = m.createResource(type.toString());
        QuerySolutionMap map = this.getGraphMap(namedGraph);
        map.add("t", (RDFNode)typeResource);
        String queryTemplate = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nDESCRIBE ?s\nWHERE {\n  GRAPH ?g {\n    ?s ?p ?o\n    {\n      SELECT DISTINCT ?s\n      WHERE {\n        ?s ?p ?o .\n        ?s rdf:type ?t.\n   }\n      LIMIT ?l\n      OFFSET ?f\n}\n}\n}\n";
        ParameterizedSparqlString query = new ParameterizedSparqlString("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nDESCRIBE ?s\nWHERE {\n  GRAPH ?g {\n    ?s ?p ?o\n    {\n      SELECT DISTINCT ?s\n      WHERE {\n        ?s ?p ?o .\n        ?s rdf:type ?t.\n   }\n      LIMIT ?l\n      OFFSET ?f\n}\n}\n}\n", map);
        query.setLiteral("l", limit);
        query.setLiteral("f", offset);
        QueryExecution queryExecution = this.queryExecutor.prepareSparqlQuery(query.toString());
        return queryExecution.execDescribe();
    }

    private SelectBuilder constructSparqlWhere(String prefixes, String where, String searchTerms, int limit, int offset, List<String> additionalDistinctVars, SelectBuilder additionalQueryFilter) {
        SelectBuilder distinctResourcesQuery = new SelectBuilder();
        Map prefixesMap = new HashMap();
        try {
            if (!StringUtils.isEmpty((CharSequence)prefixes)) {
                prefixesMap = QueryUtils.parsePrefixes((String)prefixes);
                for (Map.Entry prefix : prefixesMap.entrySet()) {
                    distinctResourcesQuery.addPrefix((String)prefix.getKey(), (String)prefix.getValue());
                }
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("prefixesExpression could not be parsed", e);
        }
        distinctResourcesQuery.addVar((Object)"s").setDistinct(true).addWhere((Object)"?s", (Object)"?p", (Object)"?o");
        if (null != additionalDistinctVars) {
            for (String additionalDistinctVar : additionalDistinctVars) {
                distinctResourcesQuery.addVar((Object)additionalDistinctVar);
            }
        }
        if (null != additionalQueryFilter) {
            distinctResourcesQuery.addWhere((AbstractQueryBuilder)additionalQueryFilter);
        }
        WhereClause whereClause = null;
        try {
            if (!StringUtils.isEmpty((CharSequence)where)) {
                whereClause = QueryUtils.parseWhere((String)where, prefixesMap);
                List parseChildren = whereClause.children();
                block11: for (SimpleTerm simpleTerm : parseChildren) {
                    SimpleTerm.Type termType = simpleTerm.type();
                    PName property = simpleTerm.property();
                    if (!termType.equals((Object)SimpleTerm.Type.COMPARISON)) {
                        throw new UnsupportedOperationException("only support for terms of type Comparisons");
                    }
                    ComparisonTerm aComparisonTerm = (ComparisonTerm)simpleTerm;
                    if (!aComparisonTerm.operator().equals((Object)ComparisonTerm.Operator.EQUALS)) {
                        throw new UnsupportedOperationException("only support for terms of type Comparisons, where the operator is 'EQUALS'");
                    }
                    Value comparisonOperand = aComparisonTerm.operand();
                    Value.Type operandType = comparisonOperand.type();
                    String predicate = property.local.equals("*") ? "?p" : property.toString();
                    switch (operandType) {
                        case DECIMAL: {
                            DecimalValue decimalOperand = (DecimalValue)comparisonOperand;
                            distinctResourcesQuery.addWhere((Object)"?s", (Object)predicate, (Object)decimalOperand.value());
                            continue block11;
                        }
                        case STRING: {
                            StringValue stringOperand = (StringValue)comparisonOperand;
                            distinctResourcesQuery.addWhere((Object)"?s", (Object)predicate, (Object)("\"" + stringOperand.value() + "\""));
                            continue block11;
                        }
                        case URI_REF: {
                            UriRefValue uriOperand = (UriRefValue)comparisonOperand;
                            distinctResourcesQuery.addWhere((Object)"?s", (Object)predicate, (Object)new ResourceImpl(uriOperand.value()));
                            continue block11;
                        }
                    }
                    throw new UnsupportedOperationException("only support for terms of type Comparisons, where the operator is 'EQUALS', and the operand is either a String, an Integer or a URI");
                }
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("whereExpression could not be parsed", e);
        }
        if (!StringUtils.isEmpty((CharSequence)searchTerms)) {
            ExprFactory factory = new ExprFactory();
            E_Regex regex = factory.regex((Object)factory.str((Object)"?o"), searchTerms, "i");
            distinctResourcesQuery.addFilter((Expr)regex);
        }
        if (limit > 0) {
            distinctResourcesQuery.setLimit(limit);
        }
        if (offset > 0) {
            distinctResourcesQuery.setOffset(offset);
        }
        SelectBuilder constructSelectQuery = new SelectBuilder();
        constructSelectQuery.addVar((Object)"s p o").addSubQuery((AbstractQueryBuilder)distinctResourcesQuery);
        return constructSelectQuery;
    }
}

