/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.ListUtils;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingProject;
import org.apache.jena.sparql.engine.iterator.QueryIterConvert;
import org.apache.jena.sparql.serializer.SerializationContext;

public class QueryIterProject
extends QueryIterConvert {
    List<Var> projectionVars;

    public QueryIterProject(QueryIterator input, List<Var> vars, ExecutionContext qCxt) {
        super(input, QueryIterProject.project(vars, qCxt), qCxt);
        this.projectionVars = vars;
    }

    static QueryIterConvert.Converter project(List<Var> vars, ExecutionContext qCxt) {
        return new Projection(vars, qCxt);
    }

    public List<Var> getProjectionVars() {
        return this.projectionVars;
    }

    @Override
    protected void details(IndentedWriter out, SerializationContext sCxt) {
        out.print(Lib.className((Object)this));
        out.print(" ");
        ListUtils.print((IndentedWriter)out, this.projectionVars);
    }

    static class Projection
    implements QueryIterConvert.Converter {
        List<Var> projectionVars;

        Projection(List<Var> vars, ExecutionContext qCxt) {
            this.projectionVars = vars;
        }

        @Override
        public Binding convert(Binding bind) {
            return new BindingProject(this.projectionVars, bind);
        }
    }
}

