/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.sys;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.dboe.DBOpEnvException;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.tdb2.sys.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOX {
    public static final Path currentDirectory = Paths.get(".", new String[0]);
    private static Logger LOG = LoggerFactory.getLogger(Util.class);

    public static RuntimeIOException exception(IOException ioException) {
        return new RuntimeIOException((Throwable)ioException);
    }

    public static RuntimeIOException exception(String message, IOException ioException) {
        return new RuntimeIOException(message, (Throwable)ioException);
    }

    public static boolean safeWrite(Path file, IOConsumer<OutputStream> writerAction) {
        Path tmp = IOX.createTempFile(file.getParent(), file.getFileName().toString(), ".tmp", new FileAttribute[0]);
        return IOX.safeWrite(file, tmp, writerAction);
    }

    public static boolean safeWrite(Path file, Path tmpFile, IOConsumer<OutputStream> writerAction) {
        try {
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(tmpFile, new OpenOption[0]));){
                writerAction.actionEx(out);
            }
            IOX.move(tmpFile, file);
            return true;
        }
        catch (IOException ex) {
            throw IOX.exception(ex);
        }
    }

    public static void delete(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException ex) {
            FmtLog.error(IOX.class, (Throwable)ex, (String)"IOException deleting %s", (Object[])new Object[]{path});
            throw IOX.exception(ex);
        }
    }

    public static void move(Path src, Path dst) {
        try {
            Files.move(src, dst, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException ex) {
            FmtLog.error(IOX.class, (Throwable)ex, (String)"IOException moving %s to %s", (Object[])new Object[]{src, dst});
            throw IOX.exception(ex);
        }
    }

    public static void copy(String srcFilename, String dstFilename) {
        Path src = Paths.get(srcFilename, new String[0]);
        if (!Files.exists(src, new LinkOption[0])) {
            throw new RuntimeIOException("No such file: " + srcFilename);
        }
        Path dst = Paths.get(dstFilename, new String[0]);
        if (Files.isDirectory(dst, new LinkOption[0])) {
            dst = dst.resolve(src.getFileName());
        }
        try {
            Files.copy(src, dst, new CopyOption[0]);
        }
        catch (IOException ex) {
            FmtLog.error(IOX.class, (Throwable)ex, (String)"IOException copying %s to %s", (Object[])new Object[]{srcFilename, dstFilename});
            throw IOX.exception(ex);
        }
    }

    public static void createDirectory(Path dir) {
        try {
            Files.createDirectory(dir, new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw IOX.exception(ex);
        }
    }

    public static Location asLocation(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new RuntimeIOException("Path is not naming a directory: " + path);
        }
        return Location.create((String)path.toString());
    }

    public static Path asPath(Location location) {
        if (location.isMem()) {
            throw new RuntimeIOException("Location is a memory location: " + location);
        }
        return Paths.get(location.getDirectoryPath(), new String[0]);
    }

    public static File asFile(Location loc) {
        return new File(loc.getDirectoryPath());
    }

    public static byte[] readAll(Path pathname) {
        try {
            return Files.readAllBytes(pathname);
        }
        catch (IOException ex) {
            throw IOX.exception(ex);
        }
    }

    public static void writeAll(Path pathname, byte[] value) {
        try {
            Files.write(pathname, value, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }
        catch (IOException ex) {
            throw IOX.exception(ex);
        }
    }

    public static Path createTempFile(Path dir, String prefix, String suffix, FileAttribute<?> ... attrs) {
        try {
            return Files.createTempFile(dir, prefix, suffix, attrs);
        }
        catch (IOException ex) {
            throw IOX.exception(ex);
        }
    }

    public static Path uniqueDerivedPath(Path path, Function<String, String> basenameMapping) {
        String base = path.getFileName().toString();
        if (basenameMapping != null) {
            base = basenameMapping.apply(base);
        }
        for (int x = 0; x < 10000; ++x) {
            String destname = base + "-" + x;
            Path destpath = path.resolveSibling(destname);
            if (Files.exists(destpath, new LinkOption[0])) continue;
            return destpath;
        }
        return null;
    }

    public static List<Path> scanForDirByPattern(Path directory, String namebase, String nameSep) {
        Pattern pattern = Pattern.compile(Pattern.quote(namebase) + Pattern.quote(nameSep) + "[\\d]+");
        ArrayList<Path> paths = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, namebase + "*");){
            for (Path entry : stream) {
                if (!pattern.matcher(entry.getFileName().toString()).matches()) {
                    throw new DBOpEnvException("Invalid filename for matching: " + entry.getFileName());
                }
                if (!Files.isDirectory(entry, new LinkOption[0])) {
                    throw new DBOpEnvException("Not a directory: " + entry);
                }
                paths.add(entry);
            }
        }
        catch (IOException ex) {
            FmtLog.warn((Logger)LOG, (String)"Can't inspect directory: (%s, %s)", (Object[])new Object[]{directory, namebase});
            throw new DBOpEnvException((Throwable)ex);
        }
        Comparator comp = (f1, f2) -> {
            int num1 = IOX.extractIndex(f1.getFileName().toString(), namebase, nameSep);
            int num2 = IOX.extractIndex(f2.getFileName().toString(), namebase, nameSep);
            return Integer.compare(num1, num2);
        };
        paths.sort(comp);
        return paths;
    }

    public static int extractIndex(String name, String namebase, String nameSep) {
        int i = namebase.length() + nameSep.length();
        String numStr = name.substring(i);
        int num = Integer.parseInt(numStr);
        return num;
    }

    public static interface IOConsumer<X> {
        public void actionEx(X var1) throws IOException;
    }
}

