/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.provider.json4j;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Providers;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.exception.MessageExtractor;
import org.eclipse.lyo.oslc4j.core.model.Error;
import org.eclipse.lyo.oslc4j.core.model.ResponseInfo;
import org.eclipse.lyo.oslc4j.core.model.ResponseInfoArray;
import org.eclipse.lyo.oslc4j.provider.json4j.JsonHelper;

@Deprecated
public abstract class AbstractOslcRdfJsonProvider {
    private static final Logger logger = Logger.getLogger(AbstractOslcRdfJsonProvider.class.getName());
    private static final Annotation[] ANNOTATIONS_EMPTY_ARRAY = new Annotation[0];
    private static final Class<Error> CLASS_OSLC_ERROR = Error.class;
    @Context
    private HttpHeaders httpHeaders;
    @Context
    protected HttpServletRequest httpServletRequest;
    @Context
    private Providers providers;

    protected AbstractOslcRdfJsonProvider() {
    }

    protected static boolean isWriteable(Class<?> type, Annotation[] annotations, MediaType requiredMediaType, MediaType actualMediaType) {
        if (type.getAnnotation(OslcResourceShape.class) != null) {
            if (annotations != null && (annotations.length > 0 || Error.class != type)) {
                for (Annotation annotation : annotations) {
                    if (!(annotation instanceof Produces)) continue;
                    Produces producesAnnotation = (Produces)annotation;
                    for (String value : producesAnnotation.value()) {
                        if (!requiredMediaType.isCompatible(MediaType.valueOf((String)value))) continue;
                        return true;
                    }
                }
                return false;
            }
            return requiredMediaType.isCompatible(actualMediaType);
        }
        return false;
    }

    protected void writeTo(boolean queryResult, Object[] objects, MediaType errorMediaType, MultivaluedMap<String, Object> map, OutputStream outputStream) throws WebApplicationException {
        String method;
        boolean isClientSide = false;
        try {
            this.httpServletRequest.getMethod();
        }
        catch (RuntimeException e) {
            isClientSide = true;
        }
        String descriptionURI = null;
        String responseInfoURI = null;
        if (queryResult && !isClientSide && "GET".equals(method = this.httpServletRequest.getMethod())) {
            responseInfoURI = descriptionURI = OSLC4JUtils.resolveURI((HttpServletRequest)this.httpServletRequest, (boolean)true);
            String queryString = this.httpServletRequest.getQueryString();
            if (queryString != null && AbstractOslcRdfJsonProvider.isOslcQuery(queryString)) {
                responseInfoURI = responseInfoURI + "?" + queryString;
            }
        }
        Map properties = isClientSide ? null : (Map)this.httpServletRequest.getAttribute("org.eclipse.lyo.oslc4j.selected.properties");
        String nextPageURI = isClientSide ? null : (String)this.httpServletRequest.getAttribute("org.eclipse.lyo.oslc4j.next.page");
        Integer totalCount = isClientSide ? null : (Integer)this.httpServletRequest.getAttribute("org.eclipse.lyo.oslc4j.total.count");
        ResponseInfoArray responseInfo = new ResponseInfoArray(null, properties, totalCount, nextPageURI);
        try {
            JSONObject jsonObject = JsonHelper.createJSON(descriptionURI, responseInfoURI, responseInfo, objects, properties);
            jsonObject.write(outputStream, true);
        }
        catch (Exception exception) {
            logger.log(Level.FINE, MessageExtractor.getMessage((String)"ErrorSerializingResource"), exception);
            throw new WebApplicationException((Throwable)exception);
        }
    }

    protected void writeTo(Object[] objects, MediaType errorMediaType, MultivaluedMap<String, Object> map, OutputStream outputStream, Map<String, Object> properties, String descriptionURI, String responseInfoURI, ResponseInfo<?> responseInfo) throws WebApplicationException {
        try {
            JSONObject jsonObject = JsonHelper.createJSON(descriptionURI, responseInfoURI, responseInfo, objects, properties);
            jsonObject.write(outputStream, true);
        }
        catch (Exception exception) {
            logger.log(Level.FINE, MessageExtractor.getMessage((String)"ErrorSerializingResource"), exception);
            throw new WebApplicationException((Throwable)exception);
        }
    }

    protected static boolean isReadable(Class<?> type, MediaType requiredMediaType, MediaType actualMediaType) {
        return type.getAnnotation(OslcResourceShape.class) != null && requiredMediaType.isCompatible(actualMediaType);
    }

    protected Object[] readFrom(Class<?> type, MediaType errorMediaType, MultivaluedMap<String, String> map, InputStream inputStream) throws WebApplicationException {
        try {
            JSONObject jsonObject = new JSONObject(inputStream);
            return JsonHelper.fromJSON(jsonObject, type);
        }
        catch (Exception exception) {
            throw new WebApplicationException((Throwable)exception, this.buildBadRequestResponse(exception, errorMediaType, map));
        }
    }

    protected Response buildBadRequestResponse(Exception exception, MediaType errorMediaType, MultivaluedMap<String, ?> map) {
        MediaType determinedErrorMediaType = this.determineErrorMediaType(errorMediaType, map);
        Error error = new Error();
        error.setStatusCode(String.valueOf(Response.Status.BAD_REQUEST.getStatusCode()));
        error.setMessage(exception.getMessage());
        Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST);
        return responseBuilder.type(determinedErrorMediaType).entity((Object)error).build();
    }

    private MediaType determineErrorMediaType(MediaType initialErrorMediaType, MultivaluedMap<String, ?> map) {
        block5: {
            try {
                List acceptableMediaTypes = this.httpHeaders.getAcceptableMediaTypes();
                if (acceptableMediaTypes != null) {
                    for (MediaType acceptableMediaType : acceptableMediaTypes) {
                        if (!this.isAcceptableMediaType(acceptableMediaType)) continue;
                        return acceptableMediaType;
                    }
                }
            }
            catch (NullPointerException exception) {
                Object acceptObject;
                if (map == null || !((acceptObject = map.getFirst((Object)"Accept")) instanceof String)) break block5;
                String[] accepts = acceptObject.toString().split(",");
                double winningQ = 0.0;
                MediaType winningMediaType = null;
                for (String accept : accepts) {
                    double q;
                    MediaType acceptMediaType = MediaType.valueOf((String)accept);
                    if (!this.isAcceptableMediaType(acceptMediaType)) continue;
                    String stringQ = (String)acceptMediaType.getParameters().get("q");
                    double d = q = stringQ == null ? 1.0 : Double.parseDouble(stringQ);
                    if (Double.compare(q, 0.0) <= 0 || winningMediaType != null && Double.compare(q, winningQ) <= 0) continue;
                    winningMediaType = acceptMediaType;
                    winningQ = q;
                }
                if (winningMediaType == null) break block5;
                return winningMediaType;
            }
        }
        return initialErrorMediaType;
    }

    private boolean isAcceptableMediaType(MediaType mediaType) {
        return !mediaType.isWildcardType() && !mediaType.isWildcardSubtype() && this.providers.getMessageBodyWriter(CLASS_OSLC_ERROR, CLASS_OSLC_ERROR, ANNOTATIONS_EMPTY_ARRAY, mediaType) != null;
    }

    protected static boolean isOslcQuery(String parmString) {
        boolean containsOslcParm = false;
        String[] uriParts = parmString.toLowerCase().split("oslc\\.", 2);
        if (uriParts.length > 1) {
            containsOslcParm = true;
        }
        return containsOslcParm;
    }
}

