/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.store.internals.query;

import java.io.IOException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;
import org.eclipse.lyo.store.internals.query.JenaQueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlQueryExecutorBasicAuthImpl
implements JenaQueryExecutor {
    private final Logger log = LoggerFactory.getLogger(SparqlQueryExecutorBasicAuthImpl.class);
    private final String queryEndpoint;
    private final String updateEndpoint;
    private final CloseableHttpClient client;
    private volatile boolean released = false;

    public SparqlQueryExecutorBasicAuthImpl(String sparqlEndpoint, String updateEndpoint, String login, String password) {
        this.queryEndpoint = sparqlEndpoint;
        this.updateEndpoint = updateEndpoint;
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(login, password);
        provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        this.client = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
    }

    @Override
    public QueryExecution prepareSparqlQuery(String query) {
        if (this.released) {
            throw new IllegalStateException("Cannot execute queries after releasing the connection");
        }
        return QueryExecutionFactory.sparqlService((String)this.queryEndpoint, (String)query, (HttpClient)this.client);
    }

    @Override
    public UpdateProcessor prepareSparqlUpdate(UpdateRequest updateRequest) {
        if (this.released) {
            throw new IllegalStateException("Cannot execute queries after releasing the connection");
        }
        return UpdateExecutionFactory.createRemote((UpdateRequest)updateRequest, (String)this.updateEndpoint, (HttpClient)this.client);
    }

    @Override
    public UpdateProcessor prepareSparqlUpdate(Update update) {
        return this.prepareSparqlUpdate(new UpdateRequest(update));
    }

    @Override
    public UpdateProcessor prepareSparqlUpdate(String query) {
        return this.prepareSparqlUpdate(UpdateFactory.create((String)query));
    }

    @Override
    public void release() {
        try {
            this.released = true;
            this.client.close();
        }
        catch (IOException e) {
            this.log.warn("Failed to close the HTTP client cleanly");
            this.log.debug("Failed to close the HTTP client cleanly", (Throwable)e);
        }
    }
}

