/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.protobuf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.iterator.IteratorSlotted;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.protobuf.ProtobufConvert;
import org.apache.jena.riot.protobuf.RiotProtobufException;
import org.apache.jena.riot.protobuf.wire.PB_RDF;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;

public class Protobuf2Binding
extends IteratorSlotted<Binding>
implements Iterator<Binding> {
    private List<Var> vars = new ArrayList<Var>();
    private List<String> varNames = new ArrayList<String>();
    private InputStream input;
    private BindingBuilder b = Binding.builder();

    public Protobuf2Binding(InputStream input) {
        this.input = input;
        this.readVars();
    }

    private void readVars() {
        try {
            PB_RDF.RDF_VarTuple vrow = PB_RDF.RDF_VarTuple.parseDelimitedFrom(this.input);
            if (vrow != null) {
                vrow.getVarsList().forEach(rv -> this.varNames.add(rv.getName()));
            }
            this.vars = Var.varList(this.varNames);
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
        }
    }

    public List<Var> getVars() {
        return this.vars;
    }

    public List<String> getVarNames() {
        return this.varNames;
    }

    protected Binding moveToNext() {
        this.b.reset();
        try {
            PB_RDF.RDF_DataTuple dataTuple = PB_RDF.RDF_DataTuple.parseDelimitedFrom(this.input);
            if (dataTuple == null) {
                return null;
            }
            List<PB_RDF.RDF_Term> row = dataTuple.getRowList();
            if (row.size() != this.vars.size()) {
                throw new RiotProtobufException(String.format("Vars %d : Row length : %d", this.vars.size(), row.size()));
            }
            for (int i = 0; i < this.vars.size(); ++i) {
                Var v = this.vars.get(i);
                PB_RDF.RDF_Term rt = row.get(i);
                if (rt.hasUndefined()) continue;
                Node n = ProtobufConvert.convert(rt);
                this.b.add(v, n);
            }
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
        }
        return this.b.build();
    }

    protected boolean hasMore() {
        return true;
    }
}

