/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.provider.jena.ordfm;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.model.TypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePackages {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourcePackages.class);
    static final Set<String> SCANNED_PACKAGES = new HashSet<String>();
    static final Map<String, List<Class<?>>> TYPES_MAPPINGS = new HashMap();

    private ResourcePackages() {
    }

    public static synchronized void mapPackage(Package pkg) {
        String packageName = pkg.getName();
        if (SCANNED_PACKAGES.contains(packageName)) {
            LOGGER.trace("> package {} already scanned", (Object)packageName);
        } else {
            int counter = 0;
            LOGGER.trace("> scanning package {}", (Object)packageName);
            ClassGraph classGraph = new ClassGraph().acceptPackages(new String[]{pkg.getName()});
            classGraph = classGraph.enableClassInfo().enableAnnotationInfo();
            try (ScanResult scanResult = classGraph.scan();){
                ClassInfoList classInforList = scanResult.getClassesWithAnnotation(OslcResourceShape.class.getName());
                for (ClassInfo classInfo : classInforList) {
                    if (classInfo.isAbstract()) {
                        LOGGER.trace("[-] Abstract class: {}", (Object)classInfo.getName());
                        continue;
                    }
                    try {
                        Class<?> rdfClass = Class.forName(classInfo.getName(), true, Thread.currentThread().getContextClassLoader());
                        String rdfType = TypeFactory.getQualifiedName(rdfClass);
                        List<Class<?>> types = TYPES_MAPPINGS.get(rdfType);
                        if (types == null) {
                            types = new ArrayList();
                            TYPES_MAPPINGS.put(rdfType, types);
                        }
                        types.add(rdfClass);
                        ++counter;
                        LOGGER.trace("[+] {} -> {}", (Object)rdfType, rdfClass);
                    }
                    catch (ClassNotFoundException ex) {
                        LOGGER.trace("[-] Unexpected missing class: {}", (Object)classInfo.getName());
                    }
                }
            }
            LOGGER.debug("< {} RDF classes found in package {}", (Object)counter, (Object)packageName);
            SCANNED_PACKAGES.add(packageName);
        }
    }

    private static Class<?> getMostConcreteClassOf(List<Class<?>> candidates) {
        int size;
        int index = 0;
        do {
            Class<?> pivot = candidates.get(index);
            Iterator<Class<?>> iterator = candidates.iterator();
            while (iterator.hasNext()) {
                Class<?> current = iterator.next();
                if (current.equals(pivot) || !current.isAssignableFrom(pivot)) continue;
                iterator.remove();
            }
        } while (++index < (size = candidates.size()));
        if (candidates.size() > 1) {
            Iterator<Class<?>> iterator = candidates.iterator();
            StringBuilder sb = new StringBuilder("Multiple classes, ");
            sb.append("not in the same inheritance tree, are annotated ");
            sb.append("to map the same RDF:type: ");
            sb.append(iterator.next().getName());
            while (iterator.hasNext()) {
                sb.append(", ");
                sb.append(iterator.next().getName());
            }
            throw new IllegalStateException(sb.toString());
        }
        return candidates.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<Class<?>> getClassOf(Resource resource, Class<?> ... preferredTypes) {
        LOGGER.trace("> resolving class for resource {}", (Object)resource.getURI());
        StmtIterator rdfTypes = resource.listProperties(RDF.type);
        ArrayList candidates = new ArrayList();
        Class<ResourcePackages> clazz = ResourcePackages.class;
        synchronized (ResourcePackages.class) {
            block3: while (rdfTypes.hasNext()) {
                Statement statement = rdfTypes.nextStatement();
                String typeURI = statement.getObject().asResource().getURI();
                List<Class<?>> rdfClasses = TYPES_MAPPINGS.get(typeURI);
                if (rdfClasses == null) {
                    LOGGER.trace("[-] Unmapped class(es) for RDF:type {}", (Object)typeURI);
                    continue;
                }
                if (rdfClasses.size() == 1) {
                    candidates.add(rdfClasses.get(0));
                    LOGGER.trace("[+] Candidate class {} found for RDF:type {}", (Object)rdfClasses.get(0).getName(), (Object)typeURI);
                    continue;
                }
                if (preferredTypes.length == 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("'preferredTypes' argument is required when more than one class (");
                    sb.append(rdfClasses.toString());
                    sb.append(") are mapped to the same RDF:type (");
                    sb.append(typeURI);
                    sb.append(")");
                    LOGGER.debug(sb.toString());
                    throw new IllegalArgumentException(sb.toString());
                }
                for (Class<?> preferredType : preferredTypes) {
                    if (!rdfClasses.contains(preferredType)) continue;
                    candidates.add(preferredType);
                    LOGGER.trace("[+] Preferred candidate class {} found for RDF:type {}", (Object)preferredType.getName(), (Object)typeURI);
                    continue block3;
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (candidates.isEmpty()) {
                LOGGER.debug("< Unmapped class for resource {}", (Object)resource.getURI());
                return Optional.empty();
            }
            Class mappedClass = candidates.size() == 1 ? (Class)candidates.get(0) : ResourcePackages.getMostConcreteClassOf(candidates);
            LOGGER.debug("< Mapped class {} for resource {}", (Object)mappedClass.getName(), (Object)resource.getURI());
            return Optional.of(mappedClass);
        }
    }

    public static void reset() {
        SCANNED_PACKAGES.clear();
        TYPES_MAPPINGS.clear();
    }
}

