/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import java.util.Objects;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphMap;
import org.apache.jena.sparql.core.DatasetGraphMapLink;
import org.apache.jena.sparql.core.DatasetGraphOne;
import org.apache.jena.sparql.core.DatasetGraphZero;
import org.apache.jena.sparql.core.NamedGraphWrapper;
import org.apache.jena.sparql.core.mem.DatasetGraphInMemory;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sys.JenaSystem;

public class DatasetGraphFactory {
    public static GraphMaker graphMakerNull;
    public static GraphMaker graphMakerMem;
    public static GraphMaker graphMakerNamedGraphMem;

    public static DatasetGraph create() {
        return new DatasetGraphMap();
    }

    public static DatasetGraph createTxnMem() {
        return new DatasetGraphInMemory();
    }

    public static DatasetGraph createGeneral() {
        return new DatasetGraphMapLink(graphMakerMem.create(null), graphMakerMem);
    }

    public static DatasetGraph cloneStructure(DatasetGraph dsg) {
        Objects.requireNonNull(dsg, "DatasetGraph must be provided");
        DatasetGraphMapLink dsg2 = new DatasetGraphMapLink(dsg.getDefaultGraph());
        Iterator<Node> names = dsg.listGraphNodes();
        while (names.hasNext()) {
            Node gn = names.next();
            dsg2.addGraph(gn, dsg.getGraph(gn));
        }
        return dsg2;
    }

    public static DatasetGraph create(Graph dftGraph) {
        return new DatasetGraphMapLink(dftGraph);
    }

    public static DatasetGraph wrap(Graph graph) {
        return DatasetGraphOne.create(graph);
    }

    public static DatasetGraph empty() {
        return DatasetGraphZero.create();
    }

    static {
        JenaSystem.init();
        graphMakerNull = name -> null;
        graphMakerMem = name -> GraphFactory.createDefaultGraph();
        graphMakerNamedGraphMem = name -> {
            Graph g = GraphFactory.createDefaultGraph();
            return new NamedGraphWrapper(name, g);
        };
    }

    public static interface GraphMaker {
        public Graph create(Node var1);
    }
}

