/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main.solver;

import java.util.Iterator;
import java.util.Objects;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.main.solver.SolverLib;
import org.apache.jena.sparql.engine.main.solver.StageMatchTriple;
import org.apache.jena.util.iterator.ExtendedIterator;

public class SolverRX3 {
    public static final boolean DATAPATH = true;

    public static Iterator<Binding> rdfStarTriple(Iterator<Binding> chain, Triple tPattern, ExecutionContext execCxt) {
        if (!SolverLib.tripleHasEmbTripleWithVars(tPattern)) {
            return SolverRX3.matchData(chain, tPattern, execCxt);
        }
        return SolverRX3.rdfStarTripleSub(chain, tPattern, execCxt);
    }

    private static Iterator<Binding> rdfStarTripleSub(Iterator<Binding> input, Triple tPattern, ExecutionContext execCxt) {
        Iterator matches = Iter.flatMap(input, binding -> SolverRX3.rdfStarTripleSub(binding, tPattern, execCxt));
        return matches;
    }

    private static Iterator<Binding> rdfStarTripleSub(Binding input, Triple xPattern, ExecutionContext execCxt) {
        Triple tPattern = Substitute.substitute(xPattern, input);
        Node s = SolverLib.nodeTopLevel(tPattern.getSubject());
        Node p = SolverLib.nodeTopLevel(tPattern.getPredicate());
        Node o = SolverLib.nodeTopLevel(tPattern.getObject());
        Graph graph = execCxt.getActiveGraph();
        ExtendedIterator graphIter = graph.find(s, p, o);
        ExtendedIterator matched = graphIter.mapWith(tData -> SolverRX3.matchTriple(input, tData, tPattern)).filterDrop(Objects::isNull);
        return matched;
    }

    private static Iterator<Binding> matchData(Iterator<Binding> chain, Triple pattern, ExecutionContext execCxt) {
        Graph g = execCxt.getActiveGraph();
        Iterator<Binding> iter = StageMatchTriple.accessTriple(chain, g, pattern, null, execCxt);
        return iter;
    }

    public static Binding matchTriple(Binding input, Triple tData, Triple tPattern) {
        BindingBuilder bb = Binding.builder(input);
        boolean r = SolverRX3.bindTriple(bb, tData, tPattern);
        return r ? bb.build() : null;
    }

    static boolean bindTriple(BindingBuilder bb, Triple tData, Triple tPattern) {
        Node sPattern = tPattern.getSubject();
        Node pPattern = tPattern.getPredicate();
        Node oPattern = tPattern.getObject();
        Node sData = tData.getSubject();
        Node pData = tData.getPredicate();
        Node oData = tData.getObject();
        if (!SolverRX3.match(bb, sData, sPattern)) {
            return false;
        }
        if (!SolverRX3.match(bb, pData, pPattern)) {
            return false;
        }
        return SolverRX3.match(bb, oData, oPattern);
    }

    private static boolean match(BindingBuilder bb, Node nData, Node nPattern) {
        if (nPattern == null) {
            return true;
        }
        if (nData == Node.ANY) {
            return true;
        }
        if ((nPattern = Var.lookup(v -> bb.get((Var)((Object)v)), nPattern)).isConcrete()) {
            return SolverLib.sameTermAs(nData, nPattern);
        }
        if (Var.isVar(nPattern)) {
            Var var = Var.alloc(nPattern);
            bb.add(var, nData);
            return true;
        }
        if (!nData.isNodeTriple()) {
            return false;
        }
        Triple tPattern = nPattern.getTriple();
        Triple tData = nData.getTriple();
        return SolverRX3.bindTriple(bb, tData, tPattern);
    }
}

