/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.Converters;
import org.apache.jena.arq.querybuilder.Order;
import org.apache.jena.arq.querybuilder.clauses.DatasetClause;
import org.apache.jena.arq.querybuilder.clauses.SelectClause;
import org.apache.jena.arq.querybuilder.clauses.SolutionModifierClause;
import org.apache.jena.arq.querybuilder.clauses.WhereClause;
import org.apache.jena.arq.querybuilder.handlers.DatasetHandler;
import org.apache.jena.arq.querybuilder.handlers.HandlerBlock;
import org.apache.jena.arq.querybuilder.handlers.SelectHandler;
import org.apache.jena.arq.querybuilder.handlers.SolutionModifierHandler;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.lang.sparql_11.ParseException;

public class DescribeBuilder
extends AbstractQueryBuilder<DescribeBuilder>
implements DatasetClause<DescribeBuilder>,
WhereClause<DescribeBuilder>,
SolutionModifierClause<DescribeBuilder>,
SelectClause<DescribeBuilder> {
    private final HandlerBlock handlerBlock;

    public DescribeBuilder() {
        this.query.setQueryDescribeType();
        this.handlerBlock = new HandlerBlock(this.query);
    }

    @Override
    public SelectHandler getSelectHandler() {
        return this.handlerBlock.getSelectHandler();
    }

    @Override
    public DescribeBuilder addVar(Object var) {
        this.getSelectHandler().addVar(Converters.makeVar(var));
        return this;
    }

    @Override
    public DescribeBuilder addVar(Expr expr, Object var) {
        this.getSelectHandler().addVar(expr, Converters.makeVar(var));
        return this;
    }

    @Override
    public DescribeBuilder addVar(String expr, Object var) throws ParseException {
        this.getSelectHandler().addVar(expr, Converters.makeVar(var));
        return this;
    }

    @Override
    public List<Var> getVars() {
        return this.getSelectHandler().getVars();
    }

    @Override
    public DescribeBuilder addOrderBy(Expr orderBy) {
        this.getSolutionModifierHandler().addOrderBy(orderBy);
        return this;
    }

    @Override
    public DescribeBuilder addOrderBy(Object orderBy) {
        this.getSolutionModifierHandler().addOrderBy(Converters.makeVar(orderBy));
        return this;
    }

    @Override
    public DescribeBuilder addOrderBy(SortCondition orderBy) {
        this.getSolutionModifierHandler().addOrderBy(orderBy);
        return this;
    }

    @Override
    public DescribeBuilder addOrderBy(Expr orderBy, Order order) {
        this.getSolutionModifierHandler().addOrderBy(orderBy, order);
        return this;
    }

    @Override
    public DescribeBuilder addOrderBy(Object orderBy, Order order) {
        this.getSolutionModifierHandler().addOrderBy(Converters.makeVar(orderBy), order);
        return this;
    }

    @Override
    public DescribeBuilder addGroupBy(Object groupBy) {
        this.getSolutionModifierHandler().addGroupBy(Converters.makeVar(groupBy));
        return this;
    }

    @Override
    public DescribeBuilder addGroupBy(Expr groupBy) {
        this.getSolutionModifierHandler().addGroupBy(groupBy);
        return this;
    }

    @Override
    public DescribeBuilder addGroupBy(Object var, Expr expr) {
        this.getSolutionModifierHandler().addGroupBy(Converters.makeVar(var), expr);
        return this;
    }

    @Override
    public DescribeBuilder addGroupBy(Object var, String expr) {
        this.getSolutionModifierHandler().addGroupBy(Converters.makeVar(var), this.makeExpr(expr));
        return this;
    }

    @Override
    public DescribeBuilder addHaving(String expression) throws ParseException {
        this.getSolutionModifierHandler().addHaving(expression);
        return this;
    }

    @Override
    public DescribeBuilder addHaving(Expr expression) throws ParseException {
        this.getSolutionModifierHandler().addHaving(expression);
        return this;
    }

    @Override
    public DescribeBuilder addHaving(Object var) throws ParseException {
        this.getSolutionModifierHandler().addHaving(Converters.makeVar(var));
        return this;
    }

    @Override
    public DescribeBuilder setLimit(int limit) {
        this.getSolutionModifierHandler().setLimit(limit);
        return this;
    }

    @Override
    public DescribeBuilder setOffset(int offset) {
        this.getSolutionModifierHandler().setOffset(offset);
        return this;
    }

    @Override
    public SolutionModifierHandler getSolutionModifierHandler() {
        return this.handlerBlock.getModifierHandler();
    }

    @Override
    public DescribeBuilder addWhere(Triple t) {
        this.getWhereHandler().addWhere(new TriplePath(t));
        return this;
    }

    @Override
    public DescribeBuilder addWhere(TriplePath t) {
        this.getWhereHandler().addWhere(t);
        return this;
    }

    @Override
    public DescribeBuilder addWhere(FrontsTriple t) {
        this.getWhereHandler().addWhere(new TriplePath(t.asTriple()));
        return this;
    }

    @Override
    public DescribeBuilder addWhere(Object s, Object p, Object o) {
        this.getWhereHandler().addWhere(this.makeTriplePath(s, p, o));
        return this;
    }

    @Override
    public DescribeBuilder addWhereValueVar(Object var) {
        this.getWhereHandler().addValueVar(this.getPrologHandler().getPrefixes(), var);
        return this;
    }

    @Override
    public DescribeBuilder addWhereValueVar(Object var, Object ... values) {
        this.getWhereHandler().addValueVar(this.getPrologHandler().getPrefixes(), var, values);
        return this;
    }

    @Override
    public <K extends Collection<?>> DescribeBuilder addWhereValueVars(Map<?, K> dataTable) {
        this.getWhereHandler().addValueVars(this.getPrologHandler().getPrefixes(), dataTable);
        return this;
    }

    @Override
    public DescribeBuilder addWhereValueRow(Object ... values) {
        this.getWhereHandler().addValueRow(this.getPrologHandler().getPrefixes(), values);
        return this;
    }

    @Override
    public DescribeBuilder addWhereValueRow(Collection<?> values) {
        this.getWhereHandler().addValueRow(this.getPrologHandler().getPrefixes(), values);
        return this;
    }

    @Override
    public List<Var> getWhereValuesVars() {
        return this.getWhereHandler().getValuesVars();
    }

    @Override
    public Map<Var, List<Node>> getWhereValuesMap() {
        return this.getWhereHandler().getValuesMap();
    }

    @Override
    public DescribeBuilder clearWhereValues() {
        this.getWhereHandler().clearValues();
        return this;
    }

    @Override
    public DescribeBuilder addOptional(Triple t) {
        this.getWhereHandler().addOptional(new TriplePath(t));
        return this;
    }

    @Override
    public DescribeBuilder addOptional(TriplePath t) {
        this.getWhereHandler().addOptional(t);
        return this;
    }

    @Override
    public DescribeBuilder addOptional(FrontsTriple t) {
        this.getWhereHandler().addOptional(new TriplePath(t.asTriple()));
        return this;
    }

    @Override
    public DescribeBuilder addOptional(Object s, Object p, Object o) {
        this.getWhereHandler().addOptional(this.makeTriplePath(s, p, o));
        return this;
    }

    @Override
    public DescribeBuilder addOptional(AbstractQueryBuilder<?> t) {
        this.getWhereHandler().addOptional(t.getWhereHandler());
        return this;
    }

    @Override
    public DescribeBuilder addFilter(String expression) throws ParseException {
        this.getWhereHandler().addFilter(expression);
        return this;
    }

    @Override
    public DescribeBuilder addFilter(Expr expression) {
        this.getWhereHandler().addFilter(expression);
        return this;
    }

    @Override
    public DescribeBuilder addSubQuery(AbstractQueryBuilder<?> subQuery) {
        this.getWhereHandler().addSubQuery(subQuery);
        return this;
    }

    @Override
    public DescribeBuilder addUnion(AbstractQueryBuilder<?> union) {
        this.getWhereHandler().addUnion(union);
        return this;
    }

    @Override
    public DescribeBuilder addGraph(Object graph, AbstractQueryBuilder<?> subQuery) {
        this.getPrologHandler().addAll(subQuery.getPrologHandler());
        this.getWhereHandler().addGraph(this.makeNode(graph), subQuery.getWhereHandler());
        return this;
    }

    @Override
    public DescribeBuilder addGraph(Object graph, FrontsTriple triple) {
        this.getWhereHandler().addGraph(this.makeNode(graph), new TriplePath(triple.asTriple()));
        return this;
    }

    @Override
    public DescribeBuilder addGraph(Object graph, Object subject, Object predicate, Object object) {
        this.getWhereHandler().addGraph(this.makeNode(graph), this.makeTriplePath(subject, predicate, object));
        return this;
    }

    @Override
    public DescribeBuilder addGraph(Object graph, Triple triple) {
        this.getWhereHandler().addGraph(this.makeNode(graph), new TriplePath(triple));
        return this;
    }

    @Override
    public DescribeBuilder addGraph(Object graph, TriplePath triplePath) {
        this.getWhereHandler().addGraph(this.makeNode(graph), triplePath);
        return this;
    }

    @Override
    public DescribeBuilder addBind(Expr expression, Object var) {
        this.getWhereHandler().addBind(expression, Converters.makeVar(var));
        return this;
    }

    @Override
    public DescribeBuilder addBind(String expression, Object var) throws ParseException {
        this.getWhereHandler().addBind(expression, Converters.makeVar(var));
        return this;
    }

    @Override
    public Node list(Object ... objs) {
        return this.getWhereHandler().list(objs);
    }

    @Override
    public DescribeBuilder addMinus(AbstractQueryBuilder<?> t) {
        this.getWhereHandler().addMinus(t);
        return this;
    }

    @Override
    public DescribeBuilder fromNamed(String graphName) {
        this.getDatasetHandler().fromNamed(graphName);
        return this;
    }

    @Override
    public DescribeBuilder fromNamed(Collection<String> graphNames) {
        this.getDatasetHandler().fromNamed(graphNames);
        return this;
    }

    @Override
    public DescribeBuilder from(String graphName) {
        this.getDatasetHandler().from(graphName);
        return this;
    }

    @Override
    public DescribeBuilder from(Collection<String> graphName) {
        this.getDatasetHandler().from(graphName);
        return this;
    }

    @Override
    public DatasetHandler getDatasetHandler() {
        return this.handlerBlock.getDatasetHandler();
    }

    @Override
    public HandlerBlock getHandlerBlock() {
        return this.handlerBlock;
    }
}

