/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.core.query.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.eclipse.lyo.core.query.BooleanValue;
import org.eclipse.lyo.core.query.ComparisonTerm;
import org.eclipse.lyo.core.query.DecimalValue;
import org.eclipse.lyo.core.query.LangedStringValue;
import org.eclipse.lyo.core.query.SimpleTerm;
import org.eclipse.lyo.core.query.StringValue;
import org.eclipse.lyo.core.query.TypedValue;
import org.eclipse.lyo.core.query.UriRefValue;
import org.eclipse.lyo.core.query.Value;
import org.eclipse.lyo.core.query.impl.BooleanValueInvocationHandler;
import org.eclipse.lyo.core.query.impl.DecimalValueInvocationHandler;
import org.eclipse.lyo.core.query.impl.LangedStringValueInvocationHandler;
import org.eclipse.lyo.core.query.impl.SimpleTermInvocationHandler;
import org.eclipse.lyo.core.query.impl.StringValueInvocationHandler;
import org.eclipse.lyo.core.query.impl.TypedValueInvocationHandler;
import org.eclipse.lyo.core.query.impl.UriRefValueInvocationHandler;

class ComparisonTermInvocationHandler
extends SimpleTermInvocationHandler {
    private final ComparisonTerm.Operator operator;
    private Value operand = null;

    public ComparisonTermInvocationHandler(Tree tree, Map<String, String> prefixMap) {
        super(tree, SimpleTerm.Type.COMPARISON, prefixMap);
        switch (((CommonTree)tree.getChild(1)).getType()) {
            case 18: {
                this.operator = ComparisonTerm.Operator.EQUALS;
                break;
            }
            case 30: {
                this.operator = ComparisonTerm.Operator.NOT_EQUALS;
                break;
            }
            case 26: {
                this.operator = ComparisonTerm.Operator.LESS_THAN;
                break;
            }
            case 27: {
                this.operator = ComparisonTerm.Operator.LESS_EQUALS;
                break;
            }
            case 19: {
                this.operator = ComparisonTerm.Operator.GREATER_THAN;
                break;
            }
            default: {
                this.operator = ComparisonTerm.Operator.GREATER_EQUALS;
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("operator")) {
            return this.operator;
        }
        boolean isOperand = methodName.equals("operand");
        if (!isOperand && !methodName.equals("toString")) {
            return super.invoke(proxy, method, args);
        }
        if (this.operand == null) {
            CommonTree treeOperand = (CommonTree)this.tree.getChild(2);
            this.operand = ComparisonTermInvocationHandler.createValue((Tree)treeOperand, "unspported literal value type", this.prefixMap);
        }
        if (isOperand) {
            return this.operand;
        }
        return ((ComparisonTerm)proxy).property().toString() + this.operator.toString() + this.operand.toString();
    }

    static Value createValue(Tree treeOperand, String errorPrefix, Map<String, String> prefixMap) {
        switch (treeOperand.getType()) {
            case 23: {
                return (Value)Proxy.newProxyInstance(UriRefValue.class.getClassLoader(), new Class[]{UriRefValue.class}, (InvocationHandler)new UriRefValueInvocationHandler(treeOperand));
            }
            case 7: {
                return (Value)Proxy.newProxyInstance(BooleanValue.class.getClassLoader(), new Class[]{BooleanValue.class}, (InvocationHandler)new BooleanValueInvocationHandler(treeOperand));
            }
            case 13: {
                return (Value)Proxy.newProxyInstance(DecimalValue.class.getClassLoader(), new Class[]{DecimalValue.class}, (InvocationHandler)new DecimalValueInvocationHandler(treeOperand));
            }
            case 46: {
                return (Value)Proxy.newProxyInstance(StringValue.class.getClassLoader(), new Class[]{StringValue.class}, (InvocationHandler)new StringValueInvocationHandler(treeOperand));
            }
            case 48: {
                return (Value)Proxy.newProxyInstance(TypedValue.class.getClassLoader(), new Class[]{TypedValue.class}, (InvocationHandler)new TypedValueInvocationHandler(treeOperand, prefixMap));
            }
            case 24: {
                return (Value)Proxy.newProxyInstance(LangedStringValue.class.getClassLoader(), new Class[]{LangedStringValue.class}, (InvocationHandler)new LangedStringValueInvocationHandler(treeOperand));
            }
        }
        throw new IllegalStateException(errorPrefix + ": " + treeOperand.getText());
    }
}

