/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.parser;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.jena.ext.com.google.common.collect.ArrayListMultimap;
import org.apache.jena.ext.com.google.common.collect.Multimap;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.other.G;
import org.apache.jena.shacl.engine.Parameter;
import org.apache.jena.shacl.engine.constraint.SparqlComponent;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.ShaclParseException;
import org.apache.jena.shacl.sys.C;
import org.apache.jena.shacl.vocabulary.SHACL;

public class Parameters {
    static List<Parameter> parseParameters(Graph shapesGraph, Node sccNode) {
        List<Parameter> params = G.listSP((Graph)shapesGraph, (Node)sccNode, (Node)SHACL.parameter).stream().map(pn -> Parameters.parseParameter(shapesGraph, sccNode, pn)).collect(Collectors.toList());
        return params;
    }

    private static Parameter parseParameter(Graph shapesGraph, Node sccNode, Node parameterNode) {
        Node path = G.getZeroOrOneSP((Graph)shapesGraph, (Node)parameterNode, (Node)SHACL.path);
        if (!path.isURI()) {
            throw new ShaclParseException("SparqlConstraintComponent: Not a URI for parameter name: " + path);
        }
        String sparqlName = path.getLocalName();
        boolean isOptional = G.contains((Graph)shapesGraph, (Node)parameterNode, (Node)SHACL.optional, (Node)C.TRUE);
        List<Constraint> constraints = null;
        return new Parameter(path, sparqlName, isOptional, constraints);
    }

    public static Multimap<Parameter, Node> parameterValues(Graph shapesGraph, Node sh, SparqlComponent scc) {
        ArrayListMultimap paramValues = ArrayListMultimap.create();
        scc.getParams().forEach(arg_0 -> Parameters.lambda$parameterValues$1(shapesGraph, sh, (Multimap)paramValues, arg_0));
        return paramValues;
    }

    public static boolean doesShapeHaveAllParameters(Graph shapesGraph, Node sh, List<Node> required) {
        for (Node p : required) {
            if (G.contains((Graph)shapesGraph, (Node)sh, (Node)p, null)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$parameterValues$1(Graph shapesGraph, Node sh, Multimap paramValues, Parameter param) {
        List values = G.listSP((Graph)shapesGraph, (Node)sh, (Node)param.getParameterPath());
        if (!values.isEmpty()) {
            paramValues.putAll((Object)param, (Iterable)values);
        }
    }
}

