/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import java.util.Map;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.RiotChars;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.Quad;

public class NodeFmtLib {
    private static final NodeFormatter ttlFormatter = new NodeFormatterTTL();
    private static final NodeFormatter ntFormatter = new NodeFormatterNT();
    private static final String nullStr = "<null>";
    private static PrefixMap dftPrefixMap = PrefixMapFactory.create();
    static char encodeMarkerChar;
    private static char LabelLeadingLetter;

    public static String str(Triple t) {
        return NodeFmtLib.strNodesTTL(t.getSubject(), t.getPredicate(), t.getObject());
    }

    public static String str(Quad q) {
        return NodeFmtLib.strNodesTTL(q.getGraph(), q.getSubject(), q.getPredicate(), q.getObject());
    }

    @Deprecated
    public static String str(Node node) {
        return NodeFmtLib.strNT(node);
    }

    public static String strTTL(Node node) {
        return NodeFmtLib.strNode(node, ttlFormatter);
    }

    public static String strNT(Node node) {
        return NodeFmtLib.strNode(node, ttlFormatter);
    }

    private static void strNT(IndentedWriter w, Node node) {
        NodeFmtLib.formatNode(w, node, ntFormatter);
    }

    private static void strTTL(IndentedWriter w, Node node) {
        NodeFmtLib.formatNode(w, node, ttlFormatter);
    }

    public static String str(Node node, PrefixMap prefixMap) {
        return NodeFmtLib.str(node, null, prefixMap);
    }

    public static String str(Node node, String base, PrefixMap prefixMap) {
        IndentedLineBuffer sw = new IndentedLineBuffer();
        NodeFmtLib.formatNode((IndentedWriter)sw, node, base, prefixMap);
        return sw.toString();
    }

    @Deprecated
    public static String strNodes(Node ... nodes) {
        return NodeFmtLib.strNodesNT(nodes);
    }

    public static String strNodesNT(Node ... nodes) {
        return NodeFmtLib.strNodes(NodeFmtLib::strNT, nodes);
    }

    public static String strNodesTTL(Node ... nodes) {
        return NodeFmtLib.strNodes(NodeFmtLib::strTTL, nodes);
    }

    private static String strNodes(BiConsumer<IndentedWriter, Node> output, Node ... nodes) {
        IndentedLineBuffer sw = new IndentedLineBuffer();
        boolean first = true;
        for (Node n : nodes) {
            if (!first) {
                sw.append(" ", new Object[0]);
            }
            first = false;
            if (n == null) {
                sw.append("null", new Object[0]);
                continue;
            }
            output.accept((IndentedWriter)sw, n);
        }
        return sw.toString();
    }

    @Deprecated
    public static void serialize(IndentedWriter w, Node node, String base, PrefixMap prefixMap) {
        NodeFmtLib.formatNode(w, node, base, prefixMap);
    }

    private static void formatNode(IndentedWriter w, Node node, NodeFormatter formatter) {
        formatter.format((AWriter)w, node);
    }

    private static void formatNode(IndentedWriter w, Node node, String base, PrefixMap prefixMap) {
        NodeFormatter formatter = base == null && prefixMap == null ? ntFormatter : new NodeFormatterTTL(base, prefixMap);
        formatter.format((AWriter)w, node);
    }

    private static String strNode(Node node, NodeFormatter formatter) {
        IndentedLineBuffer sw = new IndentedLineBuffer();
        formatter.format((AWriter)sw, node);
        return sw.toString();
    }

    public static String displayStr(RDFNode obj) {
        if (obj == null) {
            return nullStr;
        }
        return NodeFmtLib.displayStr(obj.asNode());
    }

    public static String displayStr(Triple t) {
        if (t == null) {
            return nullStr;
        }
        return NodeFmtLib.displayStrNodes(t.getSubject(), t.getPredicate(), t.getObject());
    }

    public static String displayStr(Node node) {
        if (node == null) {
            return nullStr;
        }
        return NodeFmtLib.str(node, null, dftPrefixMap);
    }

    private static String displayStrNodes(Node ... nodes) {
        StringJoiner sj = new StringJoiner(" ");
        for (Node n : nodes) {
            sj.add(NodeFmtLib.displayStr(n));
        }
        return sj.toString();
    }

    public static String encodeBNodeLabel(String label) {
        StringBuilder buff = new StringBuilder();
        buff.append(LabelLeadingLetter);
        for (int i = 0; i < label.length(); ++i) {
            char ch = label.charAt(i);
            if (ch == encodeMarkerChar) {
                buff.append(ch);
                buff.append(ch);
                continue;
            }
            if (RiotChars.isA2ZN(ch)) {
                buff.append(ch);
                continue;
            }
            Chars.encodeAsHex((StringBuilder)buff, (char)encodeMarkerChar, (char)ch);
        }
        return buff.toString();
    }

    public static String decodeBNodeLabel(String label) {
        StringBuilder buffer = new StringBuilder();
        if (label.charAt(0) != LabelLeadingLetter) {
            return label;
        }
        for (int i = 1; i < label.length(); ++i) {
            char ch = label.charAt(i);
            if (ch != encodeMarkerChar) {
                buffer.append(ch);
                continue;
            }
            char ch2 = label.charAt(i + 1);
            if (ch2 == encodeMarkerChar) {
                ++i;
                buffer.append(ch);
                continue;
            }
            char hiC = label.charAt(++i);
            int hi = Bytes.hexCharToInt((char)hiC);
            char loC = label.charAt(++i);
            int lo = Bytes.hexCharToInt((char)loC);
            int combined = hi << 4 | lo;
            buffer.append((char)combined);
        }
        return buffer.toString();
    }

    static {
        PrefixMapping pm = ARQConstants.getGlobalPrefixMap();
        Map map = pm.getNsPrefixMap();
        for (Map.Entry e2 : map.entrySet()) {
            dftPrefixMap.add((String)e2.getKey(), (String)e2.getValue());
        }
        encodeMarkerChar = (char)88;
        LabelLeadingLetter = (char)66;
    }
}

