/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.tools.codegenerator.ui.popupMenus;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.lyo.tools.codegenerator.ui.Activator;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DialogServices {
    public static void showMessage(final String title, final String message) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                String[] buttonLabels = new String[]{"OK"};
                MessageDialog dialog = new MessageDialog(shell, title, null, message, 0, buttonLabels, 1);
                dialog.open();
            }
        });
    }

    public static String promptForFolder(String title, String message, String initialFolder) {
        class DirectoryDialogThread
        implements Runnable {
            String title;
            String message;
            String initialFolder;
            String selectedFolder;

            public String getSelectedFolder() {
                return this.selectedFolder;
            }

            public DirectoryDialogThread(String t, String m, String i) {
                this.title = t;
                this.message = m;
                this.initialFolder = i;
            }

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                DirectoryDialog dialog = new DirectoryDialog(shell, 4096);
                dialog.setFilterPath(this.initialFolder);
                dialog.setMessage(this.message);
                dialog.setText(this.title);
                this.selectedFolder = dialog.open();
            }
        }
        DirectoryDialogThread dialogThread = new DirectoryDialogThread(title, message, initialFolder);
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)dialogThread);
        return dialogThread.getSelectedFolder();
    }

    public static File getGenerationTargetFolder(File modellingProjectBaseFolder) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals("generator.properties");
            }
        };
        File[] projectFolderPropertiesFiles = modellingProjectBaseFolder.listFiles(filter);
        String generationPath = null;
        if (projectFolderPropertiesFiles.length == 1 && !projectFolderPropertiesFiles[0].isDirectory()) {
            Properties props = new Properties();
            File propertiesFile = projectFolderPropertiesFiles[0];
            try {
                props.load(new FileInputStream(propertiesFile));
            }
            catch (FileNotFoundException e) {
                Status status = new Status(4, "org.eclipse.lyo.tools.codegenerator.ui", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
                DialogServices.showMessage("Exception!", "an Exception occurred reading the properties file:\"" + propertiesFile + "\". Please see the error log.");
                return null;
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.lyo.tools.codegenerator.ui", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
                DialogServices.showMessage("Exception!", "an Exception occurred reading the properties file:\"" + propertiesFile + "\". Please see the error log.");
                return null;
            }
            generationPath = props.getProperty("generationPath");
        }
        if (generationPath == null || generationPath.length() == 0) {
            generationPath = DialogServices.promptForFolder("Enter Generation Base Folder", "Select the base folder for your generation.\nNOTE: To provide a default path, set a \"generationPath\" property in a \"generator.properties\" file, in the same location as your toolchain model.", modellingProjectBaseFolder.toString());
        }
        if (generationPath == null || generationPath.length() == 0) {
            return null;
        }
        File generationPathFile = new File(generationPath);
        if (!generationPathFile.exists() || !generationPathFile.isDirectory()) {
            DialogServices.showMessage("Exception!", "Generation path " + generationPath + " must be an existing directory.");
            return null;
        }
        return generationPathFile;
    }

    public static File getModellingProjectBaseFolder(EObject self) {
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)self);
        URI rootUri = EcoreUtil.getURI((EObject)rootContainer);
        URI resolvedRootUri = CommonPlugin.resolve((URI)rootUri);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath location = Path.fromOSString((String)resolvedRootUri.toFileString());
        IFile ifile = workspace.getRoot().getFileForLocation(location);
        File projectLocation = ifile.getProject().getLocation().toFile();
        return projectLocation;
    }
}

